/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import jp.jasminesoft.jfc.JFCClientAbortException;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.TableConfigManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.dao.DataAccessException;

public class JFCErrorMessageConverter {
    public static final String JFCErrorMessageConverterResourceName = "errormsgconv";
    private static JFCErrorMessageConverter _instance;
    private String dbType = TableConfigManager.getInstance().getDbtype();
    private static final Logger logger;

    private JFCErrorMessageConverter() {
    }

    private ResourceBundle rb(String locale) {
        return JFCUtils.getResourceBundleInLocaleStrings(locale, JFCErrorMessageConverterResourceName);
    }

    public static JFCErrorMessageConverter getInstance() {
        if (_instance == null) {
            _instance = new JFCErrorMessageConverter();
        }
        return _instance;
    }

    public String get(Exception e, String locale) {
        return this.get(e, new ConvertParameter(), locale);
    }

    public String get(Exception e, String[][] params, String locale) {
        return this.get(e, new ConvertParameter(params), locale);
    }

    private String[][] createParams(EntityInfo einfo) {
        String[][] params = new String[einfo.items.length][];
        int i = 0;
        for (EntityModelitemInfo eminfo : einfo.items) {
            String[] sa = new String[]{this.getModelitemName4convertErrorMessage(einfo, eminfo), eminfo.label};
            params[i++] = sa;
        }
        return params;
    }

    private String getModelitemName4convertErrorMessage(EntityInfo einfo, EntityModelitemInfo eminfo) {
        Object name = eminfo.name;
        if (this.dbType.startsWith("postgresql")) {
            name = eminfo.primaryKey ? einfo.tablename : einfo.tablename + "_" + (String)name;
        }
        return name;
    }

    public String get(Exception e, ConvertParameter params, String locale) {
        if (params == null) {
            params = new ConvertParameter();
        } else if (params.params == null && params.einfo != null) {
            params.params = this.createParams(params.einfo);
        }
        if (e == null) {
            logger.debug("1 e is null");
            return "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("1 e.getClass() " + e.getClass());
            Throwable e1 = e;
            while (e1.getCause() != null) {
                logger.debug("1 e1.getCause() " + e1.getCause());
                e1 = e1.getCause();
            }
        }
        if (e instanceof PersistenceException && e.getCause() != null) {
            e = (Exception)e.getCause();
        }
        String msg = null;
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof DataAccessException) {
            msg = this.get((Exception)e.getCause(), params, locale);
        } else if (e instanceof GenericJDBCException) {
            GenericJDBCException ge = (GenericJDBCException)e;
            SQLException se = ge.getSQLException();
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof ConstraintViolationException) {
            ConstraintViolationException ce = (ConstraintViolationException)e;
            SQLException se = ce.getSQLException();
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof JFCClientAbortException) {
            msg = this.convertMessage((JFCClientAbortException)e, params, locale);
        }
        if (StringUtils.isBlank((CharSequence)msg) && e != null) {
            msg = this.convertExceptionToMessage(e, params, locale);
        }
        return msg;
    }

    protected String convertExceptionToMessage(Exception exception, ConvertParameter params, String locale) {
        String message;
        if (exception == null) {
            return "";
        }
        String messageKey = exception.getClass().getSimpleName();
        try {
            message = this.rb(locale).getString(messageKey);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                String arg = exception.getMessage();
                if (StringUtils.isBlank((CharSequence)arg)) {
                    arg = "";
                }
                message = MessageFormat.format(message, arg);
            }
            logger.debug(message);
        }
        catch (MissingResourceException e) {
            logger.debug("MissingResourceException", (Throwable)e);
            message = "";
        }
        return message;
    }

    private String convertMessage(SQLException se, ConvertParameter cparams, String locale) {
        logger.debug("1 se.getClass() " + se.getClass());
        if (se instanceof BatchUpdateException && se.getCause() instanceof SQLException) {
            se = (SQLException)se.getCause();
            logger.debug("2 se.getClass() " + se.getClass());
        }
        while (se.getNextException() != null) {
            se = se.getNextException();
            logger.debug("3 se.getClass() " + se.getClass());
        }
        String state = se.getSQLState();
        logger.debug("state " + state);
        String message = null;
        ResourceBundle rb = this.rb(locale);
        String original_message_pattern_key = this.createPropKey("original_pattern", state);
        String original_message_pattern = null;
        try {
            original_message_pattern = rb.getString(original_message_pattern_key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (original_message_pattern != null) {
            Pattern pattern = Pattern.compile(original_message_pattern);
            Matcher matcher = pattern.matcher(se.getMessage());
            if (!matcher.find()) {
                matcher = pattern.matcher(se.getMessage().toLowerCase());
            }
            if (matcher.find(0)) {
                String hitstr = matcher.group(1);
                message = this.convertMessage(se, cparams, rb, state, hitstr);
            }
        }
        if (message == null) {
            String message_key = this.createPropKey("state", state);
            try {
                message = rb.getString(message_key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return message;
    }

    private String convertMessage(Exception exception, ConvertParameter cparams, ResourceBundle rb, String state, String hitstr) {
        String[][] params;
        String message;
        String replace_message_key;
        logger.debug("cparams " + cparams);
        if (cparams.einfo != null && cparams.einfo.isCompositeKey()) {
            logger.debug("isCompositeKey true");
            replace_message_key = this.createPropKey("replace_message_compositekey", state);
            String hitstr1 = hitstr;
            if (hitstr1.toLowerCase().equals(cparams.einfo.tablename.toLowerCase())) {
                hitstr1 = cparams.einfo.label;
            }
            if ((message = this.convertMessage(exception, rb, replace_message_key, hitstr1)) != null) {
                logger.debug("1 message " + message);
                return message;
            }
        }
        replace_message_key = this.createPropKey("replace_message", state);
        String[][] stringArray = params = cparams != null ? cparams.params : null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!hitstr.toLowerCase().equals(params[i][0].toLowerCase())) continue;
                hitstr = params[i][1];
                break;
            }
        }
        message = this.convertMessage(exception, rb, replace_message_key, hitstr);
        logger.debug("2 message " + message);
        return message;
    }

    private String convertMessage(Exception exception, ResourceBundle rb, String replace_message_key, String hitstr) {
        String replace_message = null;
        try {
            replace_message = rb.getString(replace_message_key);
        }
        catch (MissingResourceException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00104), LogCodeManager.getMessage(LogCode.JFC00104, replace_message_key));
            return null;
        }
        Object[] oa = new Object[]{hitstr};
        String message = new MessageFormat(replace_message).format(oa);
        return message;
    }

    private String convertMessage(JFCClientAbortException cae, ConvertParameter params, String locale) {
        String message;
        String message_key = "JFCClientAbortException";
        try {
            message = this.rb(locale).getString("JFCClientAbortException");
            logger.debug(message);
        }
        catch (MissingResourceException e) {
            logger.debug("MissingResourceException", (Throwable)e);
            message = "";
        }
        return message;
    }

    private String createPropKey(String key, String state) {
        StringBuffer sb = new StringBuffer(this.dbType);
        sb.append(".");
        sb.append(key);
        sb.append(".");
        sb.append(state);
        return sb.toString();
    }

    static {
        logger = LogManager.getLogger((String)JFCErrorMessageConverter.class.getName());
    }

    public static class ConvertParameter {
        EntityInfo einfo;
        String[][] params;

        public ConvertParameter() {
        }

        public ConvertParameter(String[][] params) {
            this.params = params;
        }

        public ConvertParameter(EntityInfo einfo) {
            this.einfo = einfo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("einfo: ");
            sb.append(this.einfo);
            sb.append(", params: [");
            for (String[] param : this.params) {
                sb.append("[");
                for (String p : param) {
                    sb.append("\"");
                    sb.append(p);
                    sb.append("\",");
                }
                sb.append("]");
            }
            return sb.toString();
        }
    }

    public static class EntityInfo {
        String modelid;
        String tablename;
        String label;
        EntityModelitemInfo[] items;

        public EntityInfo(String modelid, String tablename, String label, EntityModelitemInfo[] items) {
            this.modelid = modelid;
            this.tablename = tablename;
            this.label = label;
            this.items = items;
        }

        public boolean isCompositeKey() {
            int cnt = 0;
            for (EntityModelitemInfo eminfo : this.items) {
                if (eminfo.primaryKey) {
                    ++cnt;
                }
                if (cnt < 2) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ modelid: \"");
            sb.append(this.modelid);
            sb.append("\", tablename: \"");
            sb.append(this.tablename);
            sb.append("\", label: \"");
            sb.append(this.label);
            sb.append("\", items: [");
            for (EntityModelitemInfo item : this.items) {
                sb.append(item);
                sb.append(",");
            }
            sb.append("]}");
            return sb.toString();
        }
    }

    public static class EntityModelitemInfo {
        boolean primaryKey;
        boolean unique;
        String uniqueKey;
        String name;
        String label;

        public EntityModelitemInfo(boolean primaryKey, boolean unique, String uniqueKey, String name, String label) {
            this.primaryKey = primaryKey;
            this.unique = unique;
            this.uniqueKey = uniqueKey;
            this.name = name;
            this.label = label;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ primaryKey: ");
            sb.append(this.primaryKey);
            sb.append(", unique: ");
            sb.append(this.unique);
            sb.append(", uniqueKey: ");
            sb.append(this.uniqueKey);
            sb.append(", name: \"");
            sb.append(this.name);
            sb.append("\", label: \"");
            sb.append(this.label);
            sb.append("\"}");
            return sb.toString();
        }
    }
}

