/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCQuartzJobManagerBase;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.model.jfcjobschedule.IJfcjobschedule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;

public class JFCQuartzJobManagerBaseV1MSA
extends JFCQuartzJobManagerBase {
    protected static final String NOT_SEND_KEY = JFCQuartzJobManagerBase.class.getName() + "_notsend";
    private static final Logger logger = LogManager.getLogger(JFCQuartzJobManagerBaseV1MSA.class);
    @Autowired(required=false)
    protected AbstractDomainSupport domainSupport;
    @Autowired(required=false)
    @Qualifier(value="topicJmsTemplate")
    protected JmsTemplate topicJmsTemplate;
    @Autowired(required=false)
    @Qualifier(value="domainJmsTemplate")
    protected JmsTemplate domainJmsTemplate;
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler sched;
    @Autowired(required=false)
    @Qualifier(value="schedulerRAM")
    private Scheduler schedRAM;
    @Autowired(required=false)
    @Qualifier(value="schedulerDomain")
    private Scheduler schedDomain;
    private String scheduleRAMJobTopicName;
    private String scheduleJobNowTopicName;
    private String domainidScheduleDomainJobQueueNameHeader;
    private String domainidScheduleJobNowQueueNameHeader;

    protected Integer getInstanceDomainid() {
        return this.domainSupport.id();
    }

    protected boolean isCommonDomain(int id) {
        return this.domainSupport.isCommonDomain(id);
    }

    public void setScheduleRAMJobTopicName(String topicName) {
        this.scheduleRAMJobTopicName = topicName;
    }

    public String getScheduleRAMJobTopicName() {
        return this.scheduleRAMJobTopicName;
    }

    public void setScheduleJobNowTopicName(String topicName) {
        this.scheduleJobNowTopicName = topicName;
    }

    public String getScheduleJobNowTopicName() {
        return this.scheduleJobNowTopicName;
    }

    public String getDomainidScheduleDomainJobQueueNameHeader() {
        return this.domainidScheduleDomainJobQueueNameHeader;
    }

    public void setDomainidScheduleDomainJobQueueNameHeader(String queueNameHeader) {
        this.domainidScheduleDomainJobQueueNameHeader = queueNameHeader;
    }

    public String getDomainidScheduleJobNowQueueNameHeader() {
        return this.domainidScheduleJobNowQueueNameHeader;
    }

    public void setDomainidScheduleJobNowQueueNameHeader(String queueNameHeader) {
        this.domainidScheduleJobNowQueueNameHeader = queueNameHeader;
    }

    @Override
    public void scheduleAllJob() {
        List<IJfcjobschedule> list = this.getAllJob();
        this.unscheduleJob(this.sched);
        this.unscheduleJob(this.schedRAM);
        this.unscheduleJob(this.schedDomain);
        this.scheduleJob(list, TargetJobscheduleType.ALL);
    }

    @Override
    public void updateJobAll() {
        this.scheduleJDBCJob();
        this.sendScheduleRAMJobMessage();
    }

    private void scheduleJDBCJob() {
        List<IJfcjobschedule> list = this.getJDBCJob();
        this.unscheduleJob(this.sched);
        this.unscheduleJob(this.schedDomain);
        this.scheduleJob(list, TargetJobscheduleType.ALL);
        this.sendScheduleDomainJobMessage();
    }

    @Override
    public void scheduleDomainJob() {
        List<IJfcjobschedule> list = this.getJDBCJob();
        this.unscheduleJob(this.schedDomain);
        this.scheduleJob(list, TargetJobscheduleType.DOMAINONLY);
    }

    @Override
    public void scheduleRAMJob() {
        List<IJfcjobschedule> list = this.getRAMJob();
        this.unscheduleJob(this.schedRAM);
        this.scheduleJob(list, TargetJobscheduleType.ALL);
    }

    @Override
    public void initializeScheduler() {
        this.addJFCJobTriggerListener(this.sched);
        this.fireInitializeScheduler(this.sched, 1);
        this.addJFCJobTriggerListener(this.schedRAM);
        this.fireInitializeScheduler(this.schedRAM, 2);
        if (logger.isDebugEnabled()) {
            logger.debug("jobmanager.process");
        }
        try {
            this.scheduleAllJob();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void scheduleJob(Collection<IJfcjobschedule> jfcjobschedule_ary, TargetJobscheduleType type) {
        Map<String, IJfcjobschedule> jmap = this.createJobscheduleMap(jfcjobschedule_ary);
        this.scheduleJobs(jmap, type);
    }

    protected void scheduleJobs(Map<String, IJfcjobschedule> jmap, TargetJobscheduleType type) {
        Set<String> jobnames = jmap.values().stream().map(m -> m.getJobname()).collect(Collectors.toSet());
        Map<String, SortedSet<Integer>> jobnameDomainidMap = this.domainSupport.getExecutableDomainIdForJobnames(jobnames);
        HashMap<JobDetail, Set<? extends Trigger>> map_sched = new HashMap<JobDetail, Set<? extends Trigger>>();
        HashMap<JobDetail, Set<? extends Trigger>> map_schedRAM = new HashMap<JobDetail, Set<? extends Trigger>>();
        HashMap<JobDetail, Set<? extends Trigger>> map_schedDomain = new HashMap<JobDetail, Set<? extends Trigger>>();
        for (String jobName : jmap.keySet()) {
            IJfcjobschedule schedule = jmap.get(jobName);
            SortedSet<Integer> domainidSet = jobnameDomainidMap.get(jobName);
            if (domainidSet == null) {
                logger.error("Failed get domainidSet " + schedule);
                continue;
            }
            String exectype = schedule.getExectype();
            if (exectype == null) {
                exectype = "one";
            }
            if (exectype.equals("all")) {
                if (domainidSet.size() == 0) {
                    this.addJobDetail(map_schedRAM, jobName, schedule);
                    continue;
                }
                if (!domainidSet.contains(this.getInstanceDomainid())) continue;
                this.addJobDetail(map_schedRAM, jobName, schedule);
                continue;
            }
            if (exectype.equals("one")) {
                if (domainidSet.size() == 0) {
                    this.addJobDetail(map_sched, jobName, schedule);
                    continue;
                }
                int d = (Integer)domainidSet.iterator().next();
                if (d != this.getInstanceDomainid()) continue;
                this.addJobDetail(map_schedDomain, jobName, schedule);
                continue;
            }
            if (!exectype.equals("domain")) continue;
            int[] domain = schedule.getDomain();
            if (domain.length == 0) {
                logger.warn("jobschedule " + schedule.getId() + " has no relation to any domain.");
                continue;
            }
            int d = this.getInstanceDomainid();
            boolean b = Arrays.stream(domain).anyMatch(i -> i == d);
            if (!b) continue;
            if (domainidSet.size() == 0 || domainidSet.contains(d)) {
                this.addJobDetail(map_schedDomain, jobName, schedule);
                continue;
            }
            logger.warn("jobschedule " + schedule.getId() + " can't execute in domain " + d + ".");
        }
        try {
            if (type == TargetJobscheduleType.ALL) {
                if (map_sched.size() > 0) {
                    this.sched.scheduleJobs(map_sched, true);
                }
                if (map_schedRAM.size() > 0) {
                    this.schedRAM.scheduleJobs(map_schedRAM, true);
                }
            }
            if (this.schedDomain != null && map_schedDomain.size() > 0) {
                this.schedDomain.scheduleJobs(map_schedDomain, true);
            }
            logger.info("Jobs is successfully registerd.");
        }
        catch (Exception e) {
            logger.error("Jobs cannot be registered. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void scheduleJobNow(ActionParameter p, IJfcjobschedule schedule) {
        SortedSet<Integer> domainidSet = this.domainSupport.getExecutableDomainid(schedule.getJobname());
        if (domainidSet == null) {
            logger.error("Failed get domainidSet " + schedule);
            throw new IllegalStateException();
        }
        String exectype = schedule.getExectype();
        if (exectype == null) {
            exectype = "one";
        }
        if (exectype.equals("all")) {
            if (this.getJobparam(schedule, NOT_SEND_KEY) != null) {
                if (domainidSet.size() == 0 || domainidSet.contains(this.getInstanceDomainid())) {
                    super.scheduleJobNow(p, schedule, this.schedRAM);
                }
                return;
            }
            IJfcjobschedule newjfcjobschedule = (IJfcjobschedule)schedule.clone();
            this.addJobparam(newjfcjobschedule, NOT_SEND_KEY, Boolean.TRUE.toString());
            this.sendScheduleJobNowMessage(newjfcjobschedule);
            return;
        }
        if (exectype.equals("one")) {
            this.scheduleJobNowExectypeOne(p, schedule, domainidSet);
            return;
        }
        if (exectype.equals("domain")) {
            this.scheduleJobNowExectypeDomain(p, schedule, domainidSet);
            return;
        }
        logger.error("Unknown jfcjobschedule exec type. " + schedule);
        throw new IllegalStateException();
    }

    private void scheduleJobNowExectypeOne(ActionParameter p, IJfcjobschedule schedule, SortedSet<Integer> domainidSet) {
        if (domainidSet.size() == 0) {
            super.scheduleJobNow(p, schedule, this.sched);
            return;
        }
        if (domainidSet.contains(this.getInstanceDomainid())) {
            super.scheduleJobNow(p, schedule, this.schedDomain);
            return;
        }
        if (this.getJobparam(schedule, NOT_SEND_KEY) != null) {
            logger.error("not_send_key exists " + schedule);
            return;
        }
        IJfcjobschedule newjfcjobschedule = (IJfcjobschedule)schedule.clone();
        this.addJobparam(newjfcjobschedule, NOT_SEND_KEY, Boolean.TRUE.toString());
        int domainid = (Integer)domainidSet.iterator().next();
        this.sendScheduleJobNowDomainMessage(newjfcjobschedule, domainid);
    }

    private void scheduleJobNowExectypeDomain(ActionParameter p, IJfcjobschedule schedule, SortedSet<Integer> domainidSet) {
        int[] domain = schedule.getDomain();
        if (domain.length == 0) {
            logger.warn("jobschedule " + schedule.getId() + " has no relation to any domain.");
            return;
        }
        int myd = this.getInstanceDomainid();
        boolean b = Arrays.stream(domain).anyMatch(i -> i == myd);
        if (b) {
            if (domainidSet.size() == 0 || domainidSet.contains(myd)) {
                super.scheduleJobNow(p, schedule, this.schedDomain);
            } else {
                logger.warn("jobschedule " + schedule.getId() + " can't execute in domain " + myd + ".");
            }
        }
        if (this.getJobparam(schedule, NOT_SEND_KEY) != null) {
            return;
        }
        for (int d : domain) {
            if (d == myd || this.isCommonDomain(d)) continue;
            if (domainidSet.size() == 0 || domainidSet.contains(d)) {
                IJfcjobschedule newjfcjobschedule = (IJfcjobschedule)schedule.clone();
                this.addJobparam(newjfcjobschedule, NOT_SEND_KEY, Boolean.TRUE.toString());
                this.sendScheduleJobNowDomainMessage(newjfcjobschedule, d);
                continue;
            }
            logger.warn("jobschedule " + schedule.getId() + " can't execute in domain " + d + ".");
        }
    }

    public void sendScheduleRAMJobMessage() {
        if (logger.isDebugEnabled()) {
            logger.debug("send message");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cmd", "scheduleRAMJob");
        this.topicJmsTemplate.convertAndSend(this.getScheduleRAMJobTopicName(), param);
    }

    public void sendScheduleJobNowMessage(IJfcjobschedule schedule) {
        if (logger.isDebugEnabled()) {
            logger.debug("send message");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cmd", "scheduleJobNow");
        param.put("msg", schedule);
        this.topicJmsTemplate.convertAndSend(this.getScheduleJobNowTopicName(), param);
    }

    private void sendScheduleDomainJobMessage() {
        int[] allids = this.domainSupport.allIds();
        if (logger.isDebugEnabled()) {
            logger.debug("allids " + Arrays.stream(allids).mapToObj(Integer::toString).collect(Collectors.joining(",")));
        }
        for (int id : allids) {
            Integer domainid;
            if (this.isCommonDomain(id) || id == (domainid = this.getInstanceDomainid())) continue;
            String destination = this.domainidScheduleDomainJobQueueNameHeader + id;
            this.sendDomainMessage("scheduleDomainJob", null, destination);
        }
    }

    public void sendScheduleJobNowDomainMessage(IJfcjobschedule schedule, int domainid) {
        String destination = this.domainidScheduleJobNowQueueNameHeader + domainid;
        this.sendDomainMessage("scheduleJobNow", schedule, destination);
    }

    public void sendDomainMessage(String cmd, Object msg, String destination) {
        if (logger.isDebugEnabled()) {
            logger.debug("send message " + cmd);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cmd", cmd);
        if (msg != null) {
            param.put("msg", msg);
        }
        this.domainJmsTemplate.convertAndSend(destination, param);
    }

    @Override
    protected void shutdownScheduler() {
        if (this.sched != null) {
            try {
                this.sched.shutdown(true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.schedRAM != null) {
            try {
                this.schedRAM.shutdown(true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.schedDomain != null) {
            try {
                this.schedDomain.shutdown(true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    static enum TargetJobscheduleType {
        ALL,
        DOMAINONLY;

    }
}

