/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.CssFileManager;
import jp.jasminesoft.jfc.EmptyHttpServletRequest;
import jp.jasminesoft.jfc.FontsizeFileManager;
import jp.jasminesoft.jfc.InitLoaderFormInfoUtil;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.Changelog;
import jp.jasminesoft.jfc.app.ChangelogFormatter;
import jp.jasminesoft.jfc.app.HibernateMasterJprincipal;
import jp.jasminesoft.jfc.app.MasterJprincipal;
import jp.jasminesoft.jfc.app.SetJuserToRequestProcessor;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.controller.UserPreferenceController;
import jp.jasminesoft.jfc.core.charset.Charsets;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.core.resources.PropertyUtils;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemString;
import jp.jasminesoft.jfc.model.csslist.Cssitem;
import jp.jasminesoft.jfc.model.csslist.Csslist;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizeitem;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizelist;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.tag.CheckLogonBase;
import jp.jasminesoft.util.DateRange;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.FileUtil;
import jp.jasminesoft.util.LocaleUtil;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringFilter;
import jp.jasminesoft.util.StringURLFilter;
import jp.jasminesoft.util.StringUtil;
import net.arnx.jsonic.JSON;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class JFCUtils {
    private static final String DEFAULT_LOCALE;
    private static final Logger logger;
    private static final String USER_UNKNOWN = "unknown";
    private static final HashMap<String, String> PrimaryKeyEntityMap;
    private static boolean isJuserAttributeByRequest;
    private static boolean isRecordBrowserTypeIntoLog;
    private static String PRIMARYKEY_LOCALE;
    private static final String JholidayModernCalendarviewColor;
    private static String _isHolidayScriptName;
    private static int canReadMaxWaitCount;
    private static int canReadWaitMillSec;
    private static boolean isOutputStatusToConsole;
    private static boolean isOutputThreadNameToLog;
    private static boolean isOutputUpdateListChildNoChangeMessage;
    private static final String AppResourceName = "jfcapp";
    private static final String ErrorResourceName = "errormsg";
    private static final String UNKNOWN_USER_LOGHEADER = "(unknown@localhost)";
    public static final String ADMIN_USER_LOGHEADER = "(admin@localhost)";
    public static final String UserInfoMapAttrName = "__jfc_userinfoMap";
    private static final String SessionIdParamName = "sessionId";
    private static JfcConfig jfcConfig;
    private static String _serverIP;
    private static final String[] VolatilityValueRequestKeys;
    private static final String InternetAccount_UsernameHeader = "internet";
    private static MemoryMXBean mbean;

    public static void setJfcConfig(JfcConfig jfcConfig1) {
        jfcConfig = jfcConfig1;
    }

    public static JfcConfig getJfcConfig() {
        return jfcConfig;
    }

    public static final String logmsg(ActionParameter p, String msg) {
        String username = null;
        username = p != null ? JFCUtils.getUsername(p) : UNKNOWN_USER_LOGHEADER;
        return JFCUtils.logmsg(username, msg);
    }

    public static final String logmsg(User user, String msg) {
        String username = null;
        username = user != null ? JFCUtils.getUsername(user) : UNKNOWN_USER_LOGHEADER;
        return JFCUtils.logmsg(username, msg);
    }

    public static final String logmsg(String username, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(username);
        if (msg != null) {
            sb.append(msg);
        }
        return sb.toString();
    }

    public static final String getUsername(ActionParameter p) {
        if (p == null) {
            return "";
        }
        return JFCUtils.getUsername(p.user, p.request);
    }

    public static final String getUsername(User user) {
        return JFCUtils.getUsername(user, null);
    }

    public static final String getUsername(User user, HttpServletRequest request) {
        String browserType;
        String hostname;
        String username = JFCUtils.getUserBasename(user);
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(username);
        if (jfcConfig.isOutputRemoteAddrInLogData() && request != null && (hostname = JFCUtils.getRealIP(request)) != null) {
            sb.append("@");
            sb.append(hostname);
        }
        if (request != null && isRecordBrowserTypeIntoLog && StringUtils.isNotBlank((CharSequence)(browserType = (String)request.getAttribute("__jfc_browser_type")))) {
            sb.append("|").append(browserType);
        }
        sb.append(") ");
        return sb.toString();
    }

    public static final String getRealIP(ActionParameter p) {
        return JFCUtils.getRealIP(p.request);
    }

    public static final String getRealIP(HttpServletRequest request) {
        int i;
        String hostname = null;
        if (request == null) {
            return hostname;
        }
        HttpSession session = request.getSession();
        hostname = (String)session.getAttribute("__jfc_realIP");
        if (hostname != null) {
            return hostname;
        }
        String[] REALIP_PARAMETERNAMES = new String[]{"X-Forwarded-For", "X-Real-IP"};
        String[] pnamestr = jfcConfig.getRealIPParameterNames();
        if (pnamestr != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("realIP_parameter_name " + pnamestr);
            }
            REALIP_PARAMETERNAMES = pnamestr;
        } else if (logger.isDebugEnabled()) {
            logger.debug("realIP_parameter_name is blank " + pnamestr);
        }
        for (String paramname : REALIP_PARAMETERNAMES) {
            hostname = request.getHeader(paramname);
            if (logger.isDebugEnabled()) {
                logger.debug("paramname=" + paramname + " hostname=" + hostname);
            }
            if (!StringUtils.isBlank((CharSequence)hostname) && !USER_UNKNOWN.equals(hostname)) break;
        }
        if (StringUtils.isBlank((CharSequence)hostname)) {
            hostname = request.getRemoteHost();
            if (logger.isDebugEnabled()) {
                logger.debug("RemoteHost hostname=" + hostname);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("before comma check hostname=" + hostname);
        }
        if (!StringUtils.isBlank((CharSequence)hostname) && (i = hostname.indexOf(44)) >= 0) {
            hostname = hostname.substring(0, i).trim();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("end hostname=" + hostname);
        }
        session.setAttribute("__jfc_realIP", (Object)hostname);
        return hostname;
    }

    public static final String getServerIP() {
        if (_serverIP != null) {
            return _serverIP;
        }
        TreeSet<String> set = new TreeSet<String>();
        try {
            for (NetworkInterface n : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress addr : Collections.list(n.getInetAddresses())) {
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    set.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        _serverIP = set.size() > 0 ? String.join((CharSequence)" ", set) : "(unknown)";
        return _serverIP;
    }

    public static final String getClientHostname(ActionParameter p) {
        return JFCUtils.getClientHostname(p.request);
    }

    public static final String getClientHostname(HttpServletRequest request) {
        String ip = JFCUtils.getRealIP(request);
        String hostname = null;
        try {
            if (ip != null) {
                hostname = InetAddress.getByName(ip).getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static final String getUserBasename(User user) {
        return user != null ? user.getUsername() : USER_UNKNOWN;
    }

    public static final int[] getJgroupid(User user) {
        if (user != null) {
            int[] jgroupids = user.getGroupId();
            Arrays.sort(jgroupids);
            return jgroupids;
        }
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public static final boolean isExistPreference(String key, User user) {
        if (key == null || user == null) {
            return false;
        }
        Item item = user.getPreferenceItem(key);
        return item != null;
    }

    public static boolean isValidValue(String s) {
        boolean ret = true;
        if (s == null || s.length() == 0) {
            return ret;
        }
        try {
            DateRange range = new DateRange(s);
            ret = range.isInclude(new Date());
        }
        catch (RuntimeException e) {
            ret = false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static boolean isValidValue(java.sql.Date d) {
        if (d == null) {
            return true;
        }
        return JFCUtils.isValidValue("-" + ExcelFunction.TEXT((double)ExcelFunction.DATE((Object)d), (String)"yyyy/MM/dd"));
    }

    public static boolean isValidValue(Time t) {
        return t == null;
    }

    public static boolean isValidValue(Timestamp dt) {
        if (dt == null) {
            return true;
        }
        return JFCUtils.isValidValue("-" + ExcelFunction.TEXT((Date)ExcelFunction.TODATE((Object)dt), (String)"yyyy/MM/dd"));
    }

    public static boolean isValidValue(Boolean b) {
        return b == null;
    }

    public static boolean isValidValue(Short s) {
        return s == null;
    }

    public static boolean isValidValue(Byte b) {
        return b == null;
    }

    public static boolean isValidValue(Integer i) {
        return i == null;
    }

    public static boolean isValidValue(Float f) {
        return f == null;
    }

    public static boolean isValidValue(Double d) {
        return d == null;
    }

    public static boolean isValidValue(Long l) {
        return l == null;
    }

    public static boolean isValidValue(long l) {
        return false;
    }

    public static boolean isValidValue(double d) {
        return false;
    }

    public static int[] createSelectValueAsIntArray(int value) {
        int[] array = new int[]{value};
        return array;
    }

    public static String encodePrimaryKey(String s) {
        int aposindex;
        if (s == null) {
            return "";
        }
        StringBuffer buf = null;
        int oldindex = 0;
        while ((aposindex = JFCUtils.indexOfPrimaryKeyEntity(s, oldindex)) >= 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (oldindex < aposindex) {
                buf.append(s.substring(oldindex, aposindex));
            }
            switch (s.charAt(aposindex)) {
                case '\'': {
                    buf.append("&amp;apos;");
                    break;
                }
                case '\"': {
                    buf.append("&amp;quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;amp;");
                    break;
                }
                case ':': {
                    buf.append("&amp;colon;");
                    break;
                }
                case '$': {
                    buf.append("&amp;dollar;");
                    break;
                }
                case '\\': {
                    buf.append("&amp;yen;");
                }
            }
            oldindex = aposindex + 1;
        }
        if (buf == null) {
            return s;
        }
        if (oldindex < s.length()) {
            buf.append(s.substring(oldindex));
        }
        return buf.toString();
    }

    public static int indexOfPrimaryKeyEntity(String s, int index) {
        if (s == null) {
            return -1;
        }
        while (index < s.length()) {
            char c = s.charAt(index);
            switch (c) {
                case '\"': 
                case '$': 
                case '&': 
                case '\'': 
                case ':': 
                case '\\': {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    public static String decodePrimaryKey(String s) {
        if (s != null) {
            return StringUtil.replace((String)s, PrimaryKeyEntityMap);
        }
        return null;
    }

    public static String createHTTPGetParameterForPrimaryKey(String key, String value) {
        StringBuilder sb = new StringBuilder();
        StringURLFilter filter = new StringURLFilter("UTF-8");
        if (key.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) < 0) {
            sb.append(key);
            sb.append("=");
            sb.append(filter.filter(JFCUtils.encodePrimaryKey(value)));
        } else {
            String[] keys = key.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
            String[] values = value.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
            for (int i = 0; i < keys.length; ++i) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(keys[i]);
                sb.append("=");
                sb.append(filter.filter(values[i]));
            }
        }
        return sb.toString();
    }

    public static String getLocaleStringByAcceptLanguage(String locale_strs) {
        return JFCUtils.getLocaleStringByAcceptLanguage(locale_strs, DEFAULT_LOCALE);
    }

    public static String getLocaleStringByAcceptLanguage(String locale_strs, String default_locale_str) {
        if (locale_strs == null || locale_strs.length() == 0) {
            return default_locale_str;
        }
        ResourceBundle rb = JFCUtils.getResourceBundleInLocaleStrings(locale_strs);
        Locale rb_locale = rb.getLocale();
        String ret = null;
        StringTokenizer st = new StringTokenizer(locale_strs, ",");
        while (st.hasMoreTokens()) {
            Locale l;
            String locale_str = st.nextToken();
            int semi = locale_str.indexOf(59);
            if (semi >= 0) {
                locale_str = locale_str.substring(0, semi);
            }
            if ((l = JFCUtils.createLocale(locale_str = locale_str.trim())) == null || !locale_str.startsWith(rb_locale.getLanguage())) continue;
            ret = locale_str;
            if (ret.indexOf("-") <= 0) break;
            ret = ret.replace("-", "_");
            break;
        }
        if (ret == null) {
            ret = default_locale_str;
        }
        return ret;
    }

    public static String getRValue(String key, String locale_str) {
        return JFCUtils.getRValue(key, locale_str, true);
    }

    public static String getRValue(String key, String locale_str, boolean isConvert) {
        String ret;
        block7: {
            if (locale_str == null) {
                return key;
            }
            ret = null;
            ResourceBundle rb = JFCUtils.getResourceBundleInLocaleStrings(locale_str);
            if (rb == null && logger.isDebugEnabled()) {
                logger.debug("No resource bundle by locale " + locale_str + " is found.");
            }
            if (rb != null && key != null) {
                try {
                    ret = rb.getString(key);
                }
                catch (MissingResourceException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("Missing resource by locale " + locale_str + ", key " + key, (Throwable)e);
                }
            }
        }
        if (ret == null) {
            ret = "";
        }
        if (ret.indexOf("&") >= 0) {
            ret = StringUtil.replaceAll((String)ret, (String)"&nbsp;", (String)" ");
        }
        return ret;
    }

    public static ResourceBundle getResourceBundleInLocaleStrings(String locale_strs) {
        return JFCUtils.getResourceBundleInLocaleStrings(locale_strs, AppResourceName);
    }

    public static ResourceBundle getResourceBundleInLocaleStrings(String locale_strs, String resourceName) {
        ResourceBundle rb = null;
        if (locale_strs == null || locale_strs.length() == 0) {
            locale_strs = DEFAULT_LOCALE;
        }
        StringTokenizer st = new StringTokenizer(locale_strs, ",");
        while (st.hasMoreTokens()) {
            Locale locale;
            String locale_str = st.nextToken();
            int semi = locale_str.indexOf(59);
            if (semi >= 0) {
                locale_str = locale_str.substring(0, semi);
            }
            if ((locale = JFCUtils.createLocale(locale_str = locale_str.trim())) == null || (rb = JFCUtils.getProperResourceBundle(resourceName, locale)) == null) continue;
            break;
        }
        if (rb == null) {
            rb = JFCUtils.getResourceBundleInLocaleStrings("en");
        }
        return rb;
    }

    public static ResourceBundle getProperResourceBundle(String resourceName, Locale locale) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(resourceName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (rb != null && !rb.getLocale().getLanguage().equals(locale.getLanguage())) {
            rb = null;
        }
        return rb;
    }

    public static Locale createLocale(String locale_str) {
        if (locale_str.indexOf("-") > 0) {
            locale_str = locale_str.replace("-", "_");
        }
        if (locale_str.equals("*")) {
            return Locale.getDefault();
        }
        String language = null;
        String country = null;
        String variant = null;
        StringTokenizer st = new StringTokenizer(locale_str, "-_");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (language == null) {
                language = token;
                continue;
            }
            if (country == null) {
                country = token.toUpperCase();
                continue;
            }
            if (variant != null) continue;
            variant = token.toUpperCase();
        }
        Locale locale = null;
        if (language != null) {
            locale = country != null ? new Locale(language, country) : new Locale(language);
        }
        try {
            locale.getISO3Language();
        }
        catch (MissingResourceException e) {
            logger.warn("Illegal language in locale. language:" + language, (Throwable)e);
            locale = null;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)country)) {
                locale.getISO3Country();
            }
        }
        catch (MissingResourceException e) {
            logger.warn("Illegal country in locale. country:" + country, (Throwable)e);
            locale = null;
        }
        return locale;
    }

    public static String createBrowserLocaleExpression(Locale locale) {
        String language = locale.getLanguage();
        if (StringUtils.isBlank((CharSequence)language)) {
            return DEFAULT_LOCALE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(language);
        String country = locale.getCountry();
        if (StringUtils.isNotBlank((CharSequence)country)) {
            sb.append("-").append(country.toLowerCase());
        }
        return sb.toString();
    }

    public static Locale primarykeyLocale() {
        return new Locale(PRIMARYKEY_LOCALE);
    }

    public static String getRValue(String key, String value1, String locale_str) {
        Object[] args = new Object[]{value1};
        String _fmt = JFCUtils.getRValue(key, locale_str);
        if (_fmt != null) {
            MessageFormat form = new MessageFormat(_fmt);
            return form.format(args);
        }
        return value1;
    }

    public static String getRValue(String key, String value1, String value2, String locale_str) {
        Object[] args = new Object[]{value1, value2};
        String _fmt = JFCUtils.getRValue(key, locale_str);
        if (_fmt != null) {
            MessageFormat form = new MessageFormat(_fmt);
            return form.format(args);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(value1);
        sb.append(",");
        sb.append(value2);
        return sb.toString();
    }

    public static String getRValue(String key, String value1, String value2, String value3, String locale_str) {
        Object[] args = new Object[]{value1, value2, value3};
        String _fmt = JFCUtils.getRValue(key, locale_str);
        if (_fmt != null) {
            MessageFormat form = new MessageFormat(_fmt);
            return form.format(args);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(value1);
        sb.append(",");
        sb.append(value2);
        sb.append(",");
        sb.append(value3);
        return sb.toString();
    }

    public static String getRValue(String key, Object[] args, String locale_str) {
        String _fmt = JFCUtils.getRValue(key, locale_str);
        if (_fmt != null) {
            MessageFormat form = new MessageFormat(_fmt);
            return form.format(args);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            sb.append(o.toString());
            if (i >= args.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getRValue(String key, ResourceBundle rb) {
        String ret;
        block3: {
            if (rb == null) {
                return key;
            }
            ret = "";
            try {
                ret = rb.getString(key);
            }
            catch (MissingResourceException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Missing resource, key " + key, (Throwable)e);
            }
        }
        return ret;
    }

    public static String getRValue(String key, Object[] args, ResourceBundle rb) {
        String ret;
        block4: {
            if (rb == null) {
                return key;
            }
            ret = "";
            try {
                String _fmt;
                String string = _fmt = rb != null ? rb.getString(key) : null;
                if (_fmt != null) {
                    MessageFormat form = new MessageFormat(_fmt);
                    ret = form.format(args);
                }
            }
            catch (MissingResourceException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Missing resource, key " + key, (Throwable)e);
            }
        }
        return ret;
    }

    public static String getNumberAsString(ActionParameter p, String s) {
        NumberFormat nf = NumberFormat.getInstance(JFCUtils.createLocale(p.locale));
        try {
            Number n = nf.parse(s);
            if (n != null) {
                return n.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BigDecimal.ZERO.toString();
    }

    public static String Message(ActionParameter p, String key) {
        return JFCUtils.Message0(p, AppResourceName, key);
    }

    public static String ErrorMessage(ActionParameter p, String key) {
        return JFCUtils.Message0(p, ErrorResourceName, key);
    }

    public static String Message0(ActionParameter p, String resource, String key) {
        String ret;
        block6: {
            String locale_str = JFCUtils.getLocale(p);
            if (locale_str == null) {
                return key;
            }
            ret = null;
            ResourceBundle rb = JFCUtils.getResourceBundleInLocaleStrings(locale_str, resource);
            if (rb == null && logger.isDebugEnabled()) {
                logger.debug("No resource bundle " + resource + " by locale " + locale_str + " is found.");
            }
            if (rb != null && key != null) {
                try {
                    ret = rb.getString(key);
                }
                catch (MissingResourceException e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Missing resource " + resource + " by locale " + locale_str + ", key " + key, (Throwable)e);
                }
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static String Message0(ActionParameter p, String resource, String key, Object ... value) {
        block7: {
            String locale_str = JFCUtils.getLocale(p);
            if (locale_str == null) {
                return key;
            }
            String _fmt = null;
            ResourceBundle rb = JFCUtils.getResourceBundleInLocaleStrings(locale_str, resource);
            if (rb == null && logger.isDebugEnabled()) {
                logger.debug("No resource bundle " + resource + " by locale " + locale_str + " is found.");
            }
            if (rb != null && key != null) {
                try {
                    _fmt = rb.getString(key);
                    if (_fmt != null) {
                        MessageFormat form = new MessageFormat(_fmt);
                        return form.format(value);
                    }
                }
                catch (MissingResourceException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("Missing resource " + resource + " by locale " + locale_str + ", key " + key, (Throwable)e);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            Object o = value[i];
            sb.append(o.toString());
            if (i >= value.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String Message(ActionParameter p, String key, Object ... value) {
        return JFCUtils.Message0(p, AppResourceName, key, value);
    }

    public static String ErrorMessage(ActionParameter p, String key, Object ... value) {
        return JFCUtils.Message0(p, ErrorResourceName, key, value);
    }

    public static String getHTTPDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(new Date());
    }

    public static final String createDateMapKey(int year, int month, int day) {
        StringBuilder sb = new StringBuilder();
        sb.append(year);
        sb.append("-");
        sb.append(month);
        sb.append("-");
        sb.append(day);
        return sb.toString();
    }

    public static final String createCssPath(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String css = (String)session.getAttribute("__jfc_cssfilename");
        String path = request.getServletPath();
        String uri = request.getRequestURI();
        String url = request.getRequestURL().toString();
        int path_len = path.length();
        int uri_len = uri.length();
        int url_len = url.length();
        String webappname = uri.substring(0, uri_len - path_len);
        String hostpart = url.substring(0, url_len - uri_len);
        StringBuilder sb = new StringBuilder();
        sb.append(hostpart);
        sb.append(webappname);
        sb.append("/");
        sb.append(css);
        return sb.toString();
    }

    public static String createDeployHomePath(ServletContext sc) {
        String deployPath = sc.getRealPath(".");
        String footer = "." + File.separator;
        if (deployPath != null && deployPath.endsWith(footer)) {
            deployPath = deployPath.substring(0, deployPath.length() - footer.length());
        }
        return deployPath;
    }

    public static String createAppHomePath(ServletContext sc) {
        String deployPath = sc.getRealPath(".");
        int ptr = deployPath.indexOf("webapps");
        if (ptr < 0) {
            return "./apphome";
        }
        String appHomePath = deployPath.substring(0, ptr - 1);
        return appHomePath;
    }

    public static String getMD5Hash(HttpSession session) {
        String sid = null;
        if (session != null) {
            sid = session.getId();
        }
        if (sid != null) {
            sid = StringUtil.getMD5Hash((String)sid);
        }
        if (sid == null) {
            sid = "";
        }
        return sid;
    }

    public static String[] getJuserPrincipalNameInCandidate(User user, String ... candidates) {
        LinkedHashSet<String> candidateSet = new LinkedHashSet<String>();
        Subject subject = user.getLoginContext().getSubject();
        HashSet pSet = subject != null ? subject.getPrincipals() : new HashSet();
        for (Principal principal : pSet) {
            String __name = principal.getName();
            for (String candidate : candidates) {
                if (!__name.equals(candidate)) continue;
                candidateSet.add(__name);
            }
        }
        return candidateSet.toArray(new String[0]);
    }

    public static String getFirstJuserPrincipalNameInCandidate(User user, String ... candidates) {
        String ret = null;
        String[] ss = JFCUtils.getJuserPrincipalNameInCandidate(user, candidates);
        if (ss != null && ss.length > 0) {
            ret = ss[0];
        }
        return ret;
    }

    public static boolean hasSinglePrincipal(User user, String principal_name) {
        HashSet<String> principalNameSet = new HashSet<String>();
        principalNameSet.add(principal_name);
        principalNameSet.add("all");
        return JFCUtils.hasPrincipal0(user, principalNameSet);
    }

    public static boolean hasPrincipalRestrictively(User user, String ... principal_names) {
        HashSet<String> principalNameSet = new HashSet<String>();
        for (String principal_name : principal_names) {
            principalNameSet.add(principal_name);
        }
        return JFCUtils.hasPrincipal0(user, principalNameSet);
    }

    public static boolean hasPrincipal(User user, String ... principal_names) {
        HashSet<String> principalNameSet = new HashSet<String>();
        for (String principal_name : principal_names) {
            principalNameSet.add(principal_name);
        }
        principalNameSet.add("all");
        return JFCUtils.hasPrincipal0(user, principalNameSet);
    }

    private static boolean hasPrincipal0(User user, Set<String> principalNameSet) {
        boolean ret = false;
        if (user == null) {
            return ret;
        }
        Subject subject = user.getLoginContext().getSubject();
        HashSet pSet = subject != null ? subject.getPrincipals() : new HashSet();
        for (Principal principal : pSet) {
            String __name = principal.getName();
            if (!principalNameSet.contains(__name)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static String[] getPrincipals(User user) {
        if (user == null) {
            return new String[0];
        }
        Subject subject = user.getLoginContext().getSubject();
        if (subject == null) {
            return new String[0];
        }
        return (String[])subject.getPrincipals().stream().map(s -> s.getName()).filter(s -> StringUtils.isNotEmpty((CharSequence)s)).toArray(String[]::new);
    }

    public static Jprincipal[] getAllPrincipals(ActionParameter p) {
        MasterJprincipal masterJprincipal = HibernateMasterJprincipal.getInstance();
        return masterJprincipal.getData();
    }

    public static boolean isValidPermission(User user, String permactions, String default_permname) {
        return JFCUtils.isValidPermission(user, permactions, null, default_permname);
    }

    public static boolean isValidPermission(User user, String permactions, String permname, String default_permname) {
        if (JFCUtils.hasPrincipal(user, "all")) {
            return true;
        }
        CheckLogonBase checklogon = new CheckLogonBase();
        if (permname != null) {
            checklogon.setPermname(permname);
        } else {
            checklogon.setPermname(default_permname);
        }
        checklogon.setPermactions(permactions);
        checklogon.setPermclassname("jp.jasminesoft.jfc.JFCAppPermission");
        boolean ret = checklogon.checkLogon(user);
        return ret;
    }

    public static ActionParameter createActionParameter(ApplicationContext appctx) {
        return JFCUtils.createActionParameter(null, null, null, null, appctx);
    }

    public static ActionParameter createActionParameter(User user, ApplicationContext appctx) {
        return JFCUtils.createActionParameter(null, null, user, null, appctx);
    }

    public static HttpServletRequest createEmptyHttpServletRequest(ActionParameter p) {
        HttpSession session;
        EmptyHttpServletRequest request = new EmptyHttpServletRequest(p.appctx);
        request.setAttribute("__jfc_screen_id", p.request.getAttribute("__jfc_screen_id"));
        request.setAttribute("__jfc_screen_type", p.request.getAttribute("__jfc_screen_type"));
        request.setAttribute("__jfc_status", p.request.getAttribute("__jfc_status"));
        request.setAttribute("__jfc_script_fileresloader", p.request.getAttribute("__jfc_script_fileresloader"));
        request.setAttribute("__jfc_PageLockUtils_LOCKOBJECT_CONTAINER_APPMAP_KEY", p.request.getAttribute("__jfc_PageLockUtils_LOCKOBJECT_CONTAINER_APPMAP_KEY"));
        request.setAttribute("__jfc_browser_type", "");
        JFCUtils.setVolatilityValueToRequestObject(request);
        JFCUtils.setHasAllPrincipalStatus(p.user, request);
        Map userinfoMap = (Map)p.request.getAttribute(UserInfoMapAttrName);
        if (userinfoMap != null) {
            request.setAttribute(UserInfoMapAttrName, new HashMap(userinfoMap));
        }
        if ((session = p.request.getSession()) != null) {
            request.setSessionId(session.getId());
        }
        return request;
    }

    public static ActionParameter createActionParameter(HttpServletRequest request, HttpServletResponse response, User user, Jfcerrors errors, ApplicationContext appctx) {
        Item item;
        if (request == null) {
            request = new EmptyHttpServletRequest(appctx);
            request.setAttribute("__jfc_screen_id", (Object)USER_UNKNOWN);
            request.setAttribute("__jfc_screen_type", (Object)USER_UNKNOWN);
            request.setAttribute("__jfc_status", (Object)"");
            request.setAttribute("__jfc_browser_type", (Object)"");
        }
        JFCUtils.setVolatilityValueToRequestObject(request);
        JFCUtils.setHasAllPrincipalStatus(user, request);
        if (errors == null) {
            errors = new Jfcerrors();
        }
        String locale = null;
        if (user != null && (item = user.getPreferenceItem("locale")) != null) {
            locale = item.getContent();
        }
        if (locale == null) {
            locale = JFCUtils.getLocaleStringByAcceptLanguage(request.getHeader("accept-language"));
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        ActionParameter p = new ActionParameter(request, response, new HashMap<String, Object>(), new HashMap<String, Object>(), new HashMap<String, Object>(), errors, user, null, "", null, "", logger, null, locale, appctx);
        return p;
    }

    public static Connection getConnection() throws Exception {
        try {
            DataSource ds = JFCUtils._getDataSource();
            return ds.getConnection();
        }
        catch (Throwable e) {
            throw new Exception("Failed to create datasource java:comp/env/jdbc/jfc", e);
        }
    }

    public static Connection getConnectionSilently(Logger logger) {
        try {
            return JFCUtils.getConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static DataSource getDataSource() {
        try {
            return JFCUtils._getDataSource();
        }
        catch (NamingException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00106), LogCodeManager.getMessage(LogCode.JFC00106, "java:comp/env/jdbc/jfc"));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static DataSource _getDataSource() throws NamingException {
        InitialContext initCtx = null;
        DataSource ds = null;
        try {
            initCtx = new InitialContext();
            DataSource dataSource = ds = (DataSource)initCtx.lookup("java:comp/env/jdbc/jfc");
            return dataSource;
        }
        finally {
            if (initCtx != null) {
                initCtx.close();
                initCtx = null;
            }
        }
    }

    public static void releaseConnection(Connection con, Statement st, ResultSet rs) throws Exception {
        if (rs != null) {
            rs.close();
        }
        if (st != null) {
            st.close();
        }
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }

    public static void releaseConnection(Connection con) throws Exception {
        JFCUtils.releaseConnection(con, null, null);
    }

    public static void releaseConnectionSilently(Connection con, Logger logger) {
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void skipUpdatetime(ActionParameter p) {
        if (p.pageMap != null) {
            p.pageMap.put("__jfc_control.skipUpdatetime", Boolean.TRUE);
        }
    }

    public static final String separatePrimaryKey(String s, int index) {
        String[] tokens = s.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
        return tokens[index];
    }

    public static final String aggregatePrimaryKey(String ... pkeys) {
        if (pkeys != null && pkeys.length == 1) {
            return pkeys[0];
        }
        if (pkeys == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pkeys.length; ++i) {
            sb.append(pkeys[i]);
            if (i >= pkeys.length - 1) continue;
            sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
        }
        return sb.toString();
    }

    public static final void resetVolatilityValueToRequestObject(HttpServletRequest request) {
        request.setAttribute("__jfc_V_TODAY", (Object)ExcelFunction.TODAY());
        Timestamp now = ExcelFunction.NOWM();
        request.setAttribute("__jfc_V_NOWM", (Object)now);
        request.setAttribute("__jfc_V_NOW", (Object)now);
    }

    public static final void setVolatilityValueToRequestObject(HttpServletRequest request) {
        boolean isNull = false;
        for (String key : VolatilityValueRequestKeys) {
            if (request.getAttribute(key) != null) continue;
            isNull = true;
            break;
        }
        if (isNull) {
            JFCUtils.resetVolatilityValueToRequestObject(request);
        }
    }

    public static final Map<String, Object> getVolatilityValueToRequestObject(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : VolatilityValueRequestKeys) {
            map.put(key, request.getAttribute(key));
        }
        return map;
    }

    public static final void setVolatilityValueToRequestObject(HttpServletRequest request, Map<String, Object> map) {
        for (String key : VolatilityValueRequestKeys) {
            request.setAttribute(key, map.get(key));
        }
    }

    public static final void setHasAllPrincipalStatus(User user, HttpServletRequest request) {
        if (user != null && JFCUtils.hasPrincipal(user, "all")) {
            request.setAttribute("__jfc_hasAllPrincipal", (Object)new Boolean(true));
        }
    }

    public static final double __rand(String itemname, ActionParameter p) {
        Double __value = (Double)p.request.getAttribute(itemname);
        if (__value != null) {
            return __value;
        }
        __value = (Double)p.pageMap.get(itemname);
        if (__value != null) {
            return __value;
        }
        __value = ExcelFunction.RAND();
        p.request.setAttribute(itemname, (Object)__value);
        p.pageMap.put(itemname, __value);
        return __value;
    }

    public static final double __randbetween(String itemname, ActionParameter p, int min, int max) {
        Double __value = (Double)p.request.getAttribute(itemname);
        if (__value != null) {
            return __value;
        }
        __value = (Double)p.pageMap.get(itemname);
        if (__value != null) {
            return __value;
        }
        __value = ExcelFunction.RANDBETWEEN((int)min, (int)max);
        p.request.setAttribute(itemname, (Object)__value);
        p.pageMap.put(itemname, __value);
        return __value;
    }

    public static final String __randstr(String itemname, ActionParameter p, int keta) {
        String __value = (String)p.request.getAttribute(itemname);
        if (__value != null) {
            return __value;
        }
        __value = (String)p.pageMap.get(itemname);
        if (__value != null) {
            return __value;
        }
        __value = ExcelFunction.RANDSTR((int)keta);
        p.request.setAttribute(itemname, (Object)__value);
        p.pageMap.put(itemname, __value);
        return __value;
    }

    public static final String __randstr(String itemname, ActionParameter p, int keta, String expat) {
        String __value = (String)p.request.getAttribute(itemname);
        if (__value != null) {
            return __value;
        }
        __value = ExcelFunction.RANDSTR((int)keta, (String)expat);
        p.request.setAttribute(itemname, (Object)__value);
        return __value;
    }

    public static final String getJuserAttribute(ActionParameter p, String itemname) {
        Map<String, String> userinfoMap = null;
        if (isJuserAttributeByRequest) {
            userinfoMap = (HashMap<String, String>)p.request.getAttribute(UserInfoMapAttrName);
            if (userinfoMap == null) {
                userinfoMap = new HashMap<String, String>();
                if (p.appctx != null && p instanceof ActionParameter) {
                    ((SetJuserToRequestProcessor)p.appctx.getBean("SetJuserToRequestProcessor")).process(userinfoMap, p);
                }
                p.request.setAttribute(UserInfoMapAttrName, userinfoMap);
            }
        } else {
            HttpSession session = p.request.getSession();
            if (session == null) {
                return "";
            }
            userinfoMap = (Map)session.getAttribute(UserInfoMapAttrName);
            if (userinfoMap == null) {
                userinfoMap = new HashMap();
                if (p.appctx != null && p instanceof ActionParameter) {
                    ((SetJuserToRequestProcessor)p.appctx.getBean("SetJuserToRequestProcessor")).process(userinfoMap, p);
                }
                session.setAttribute(UserInfoMapAttrName, userinfoMap);
            }
        }
        String s = userinfoMap != null ? (String)userinfoMap.get(itemname) : null;
        return s != null ? s : "";
    }

    public static final String getLocale(ActionParameter p) {
        if (p.request == null) {
            return "";
        }
        HttpSession session = p.request.getSession();
        String locale = session != null ? (String)session.getAttribute("__jfc_locale") : "";
        return locale;
    }

    public static final boolean needsFileClear(ActionParameter p) {
        boolean isFileClearCommand = false;
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi != null) {
            for (String key : multi.getParameterList()) {
                String value;
                Object[] sa;
                if (!key.endsWith("_jshclear") || (sa = multi.getContentsList(key)) == null || sa.length <= 0 || !(sa[0] instanceof String) || (value = (String)sa[0]).length() <= 0) continue;
                isFileClearCommand = true;
                break;
            }
        }
        return isFileClearCommand;
    }

    public static final boolean isInputErrorOrClearButton(ActionParameter p) {
        if (p.errors.sizeJfcerror() > 0) {
            return true;
        }
        if (p.action != null && (p.action.startsWith("Clear") || "AllClear".equals(p.action))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)p.request.getParameter("btnClear"))) {
            return true;
        }
        return JFCUtils.needsFileClear(p);
    }

    public static final boolean isInputErrorOrClearOrAddRemoveAction(ActionParameter p) {
        if (p.errors.sizeJfcerror() > 0) {
            return true;
        }
        if (p.action != null && (p.action.startsWith("Clear") || "AllClear".equals(p.action))) {
            return true;
        }
        if (p.cmd == CommandType.AddItem || p.cmd == CommandType.RemoveItem) {
            return true;
        }
        return JFCUtils.needsFileClear(p);
    }

    public static final boolean isUpdateCommand(ActionParameter p) {
        return p.cmd == CommandType.DoUpdate || p.cmd == CommandType.DoInsert || p.cmd == CommandType.DoDelete || p.cmd == CommandType.DoDeleteAll || p.cmd == CommandType.DoUpdateAll || p.cmd == CommandType.UpdateListExecute;
    }

    public static final boolean isContainerOperationCommand(ActionParameter p) {
        return p.cmd == CommandType.AddItem || p.cmd == CommandType.RemoveItem || p.cmd == CommandType.MoveUpItem || p.cmd == CommandType.MoveDownItem;
    }

    public static String replaceCRExpression(String s) {
        s = StringUtil.replaceAll((String)s, (String)"\r\n", (String)"<br/>");
        s = StringUtil.replaceAll((String)s, (String)"\n", (String)"<br/>");
        s = StringUtil.replaceAll((String)s, (String)"\r", (String)"<br/>");
        return s;
    }

    public static String removeCRExpression(String s) {
        s = StringUtil.replaceAll((String)s, (String)"\r\n", (String)"");
        s = StringUtil.replaceAll((String)s, (String)"\n", (String)"");
        s = StringUtil.replaceAll((String)s, (String)"\r", (String)"");
        return s;
    }

    public static String interpretContentByLocale(ActionParameter p, String s) {
        return JFCUtils.interpretContentByLocale(s, p.locale, DEFAULT_LOCALE);
    }

    public static String interpretContentByLocale(String s, String locale) {
        return JFCUtils.interpretContentByLocale(s, locale, DEFAULT_LOCALE);
    }

    public static String interpretContentByLocale(String s, String locale, String defaultLocale) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (!s.startsWith("{") && (locale == null || locale.equals(defaultLocale))) {
            return s;
        }
        String ret = null;
        Map map = null;
        try {
            map = (Map)JSON.decode((String)s);
        }
        catch (Exception e) {
            return s;
        }
        if (map == null || map.size() == 0) {
            return s;
        }
        Object o = map.get(locale);
        if (o != null) {
            ret = o instanceof String ? (String)o : o.toString();
        }
        if (ret == null) {
            Object _o;
            String candidate;
            String p_candidate = "";
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                candidate = null;
                _o = it.next();
                candidate = _o instanceof String ? (String)_o : _o.toString();
                if (!locale.startsWith(candidate) || p_candidate.length() >= candidate.length()) continue;
                p_candidate = candidate;
            }
            o = map.get(p_candidate);
            if (o != null) {
                ret = o instanceof String ? (String)o : o.toString();
            }
            if (ret == null) {
                p_candidate = "";
                it = map.keySet().iterator();
                while (it.hasNext()) {
                    candidate = null;
                    _o = it.next();
                    candidate = _o instanceof String ? (String)_o : _o.toString();
                    if (!candidate.startsWith(locale) || p_candidate.length() >= candidate.length()) continue;
                    p_candidate = candidate;
                }
                o = map.get(p_candidate);
                if (o != null) {
                    ret = o instanceof String ? (String)o : o.toString();
                }
            }
        }
        if (ret == null) {
            if (map != null && (o = map.get(defaultLocale)) != null) {
                ret = o instanceof String ? (String)o : o.toString();
            }
            if (ret == null) {
                ret = s;
            }
        }
        return ret;
    }

    public static int getWizardPage(ActionParameter p) {
        String _key = (String)p.request.getAttribute("__jfc_keyname");
        if (_key == null && (_key = (String)p.pageMap.get("__jfc_keyname")) == null) {
            _key = (String)p.redirectMap.get("__jfc_keyname");
        }
        return JFCUtils.getWizardPage(p, _key);
    }

    public static int getWizardPage(ActionParameter p, String key) {
        int ret = 0;
        if (key != null) {
            Object o;
            if (!((String)key).startsWith("__jfc_")) {
                key = "__jfc_" + (String)key + "_wpage";
            }
            if ((o = p.request.getAttribute((String)key)) == null && (o = p.pageMap.get(key)) == null) {
                o = p.redirectMap.get(key);
            }
            if (o != null && o instanceof Integer) {
                ret = (Integer)o;
            }
        }
        return ret;
    }

    public static void removeCachedModel4Calc(ActionParameter p, String modelId, String pmodelKey) {
        HashSet<Object> removeSet = new HashSet<Object>();
        removeSet.add("datas_" + modelId + "_lp");
        Enumeration em = p.request.getAttributeNames();
        while (em.hasMoreElements()) {
            String _s = (String)em.nextElement();
            if (_s.startsWith(pmodelKey)) {
                removeSet.add(_s);
            }
            if (!_s.startsWith(modelId) || !_s.endsWith("_ary")) continue;
            removeSet.add(_s);
        }
        for (String string : removeSet) {
            p.request.removeAttribute(string);
        }
    }

    public static int getResultSize(ActionParameter p) {
        FinderContextResultBeanWrapper rbean = (FinderContextResultBeanWrapper)p.request.getAttribute("jfc_result");
        if (rbean != null) {
            return rbean.getSize();
        }
        return -1;
    }

    public static boolean isAcceptFontsizeFilename(FontsizeFileManager fsman, String _fontsizefilename, ActionParameter p) {
        if (_fontsizefilename == null) {
            return false;
        }
        Fontsizelist fontsizelist = fsman.getFontsizelist(p);
        if (fontsizelist == null) {
            return false;
        }
        Fontsizeitem[] items = fontsizelist.getFontsizeitem();
        if (items == null) {
            return false;
        }
        for (Fontsizeitem item : items) {
            if (!_fontsizefilename.equals(item.getContent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAcceptCssFilename(CssFileManager cssman, String _cssfilename) {
        if (_cssfilename == null) {
            return false;
        }
        Csslist csslist = cssman.getCsslist();
        if (csslist == null) {
            return false;
        }
        Cssitem[] items = csslist.getCssitem();
        if (items == null) {
            return false;
        }
        for (Cssitem item : items) {
            if (!_cssfilename.equals(item.getContent())) continue;
            return true;
        }
        return false;
    }

    public static String getEvent(ActionParameter p) {
        if (p == null || p.action == null) {
            return "";
        }
        return p.action;
    }

    public static String getAllChangelog(ActionParameter p) {
        String pkeyAsString = (String)p.request.getAttribute("__pkeyAsString");
        Object __jfc_changelog_keyname = "__jfc_changelog";
        if (StringUtils.isNotBlank((CharSequence)pkeyAsString)) {
            __jfc_changelog_keyname = (String)__jfc_changelog_keyname + "_" + pkeyAsString;
        }
        StringBuilder sb = new StringBuilder();
        Object[] changelogs = (Changelog[])p.request.getAttribute((String)__jfc_changelog_keyname);
        if (ArrayUtils.isNotEmpty((Object[])changelogs)) {
            ChangelogFormatter fmt = ChangelogFormatter.getInstance();
            for (Object changelog : changelogs) {
                sb.append(fmt.format((Changelog)changelog));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String getLocaleString() {
        return DEFAULT_LOCALE;
    }

    public static String getLocaleString(HttpServletRequest request) {
        return request != null ? JFCUtils.getLocaleString(request.getLocale()) : DEFAULT_LOCALE;
    }

    public static String getLocaleString(Locale locale) {
        String locale_str = LocaleUtil.getLocaleString((Locale)locale);
        if (StringUtils.isEmpty((CharSequence)locale_str)) {
            locale_str = DEFAULT_LOCALE;
        }
        return locale_str;
    }

    public static String getLogHeader(ActionParameter p) {
        return JFCUtils.getLogHeader(p, null, null);
    }

    public static String getLogHeader(ActionParameter p, String status, String msg) {
        StringBuilder sb = JFCUtils.getLogHeader0(p, status);
        if (isOutputThreadNameToLog) {
            sb.append(" Start  ").append(Thread.currentThread().getName());
        }
        if (msg != null) {
            sb.append(":");
            sb.append(msg);
        }
        sb.append(" ");
        return sb.toString();
    }

    public static String endLog(ActionParameter p, String status, String msg) {
        if (!isOutputThreadNameToLog) {
            return null;
        }
        StringBuilder sb = JFCUtils.getLogHeader0(p, status);
        sb.append(" Finish ").append(Thread.currentThread().getName());
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }

    private static StringBuilder getLogHeader0(ActionParameter p, String status) {
        StringBuilder sb = new StringBuilder();
        String userinfo = JFCUtils.getUsername(p);
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            userinfo = UNKNOWN_USER_LOGHEADER;
        }
        sb.append(userinfo);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            sb.append(status);
        }
        sb.append("|");
        if (p.cmd != null) {
            sb.append((Object)p.cmd);
        }
        return sb;
    }

    public static String getAttributeKey4SaveIndex(String header, String pmodelname, String modelitemname) {
        StringBuffer key = new StringBuffer();
        key.append(header).append(pmodelname).append("_").append(modelitemname.replace('/', '_')).append("_index");
        return key.toString();
    }

    public static boolean isInternetAccount(String username) {
        return username.startsWith(InternetAccount_UsernameHeader);
    }

    public static final String getRequestParameter(ActionParameter p, String itemname, StringFilter filter) {
        return JFCUtils.getRequestParameter(p, itemname, filter, null);
    }

    public static final String getRequestParameter(ActionParameter p, String itemname, StringFilter filter, Object obj) {
        Object value;
        String string = value = p != null && p.request != null ? p.request.getParameter(itemname) : null;
        if (StringUtils.isNotBlank(value)) {
            value = filter.filter((String)value);
        } else {
            Enumeration _names = p.request.getParameterNames();
            block12: while (_names.hasMoreElements()) {
                String _name = (String)_names.nextElement();
                int ptr = _name.indexOf("action_");
                if (ptr < 0) continue;
                if (ptr > 0) {
                    _name = _name.substring(ptr);
                }
                int _beginIndex = _name.indexOf(":");
                int _endIndex = _name.lastIndexOf(":");
                if (_beginIndex <= 0 || _endIndex <= 0 || _beginIndex == _endIndex) continue;
                String _itemname = _name.substring(_beginIndex + 1, _endIndex);
                if (_itemname.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) < 0) {
                    if (!_itemname.equals(itemname)) continue;
                    value = filter.filter(_name.substring(_endIndex + 1));
                    break;
                }
                String _value = _name.substring(_endIndex + 1);
                String[] keys = _itemname.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
                String[] values = _value.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
                for (int i = 0; i < keys.length; ++i) {
                    if (!keys[i].equals(itemname)) continue;
                    value = filter.filter(values[i]);
                    break block12;
                }
            }
            if (StringUtils.isBlank((CharSequence)value) && obj != null) {
                Class<?> clazz = obj.getClass();
                boolean doGetMethod = true;
                try {
                    Object ret;
                    Method checker = clazz.getMethod(SourceGeneratorUtil.checkMethod((String)itemname), new Class[0]);
                    if (checker != null && (ret = checker.invoke(obj, null)) != null && ret instanceof Boolean) {
                        Boolean b = (Boolean)ret;
                        doGetMethod = b;
                    }
                }
                catch (NoSuchMethodException checker) {
                }
                catch (SecurityException checker) {
                }
                catch (IllegalAccessException checker) {
                }
                catch (IllegalArgumentException checker) {
                }
                catch (InvocationTargetException checker) {
                    // empty catch block
                }
                if (doGetMethod) {
                    try {
                        Method getter = clazz.getMethod(SourceGeneratorUtil.getterMethod((String)itemname), new Class[0]);
                        Object ret = getter.invoke(obj, null);
                        value = ret == null ? null : (ret.getClass().isArray() && Array.getLength(ret) == 0 ? null : ret.toString());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
        }
        return value;
    }

    public static final Object getAttributeInSession(ActionParameter p, String name) {
        return p != null && p.request != null && p.request.getSession() != null ? p.request.getSession().getAttribute(name) : null;
    }

    public static String[] getPrimarykeyName(ActionParameter p, String modelId) {
        if (p == null || p.appctx == null) {
            return new String[0];
        }
        String beanId = StringUtil.capFirst((String)modelId) + "Helper";
        Object helper = p.appctx.getBean(beanId);
        if (helper != null) {
            try {
                Object[] params = new Object[]{p};
                Object value = MethodUtils.invokeStaticMethod(helper.getClass(), (String)"getPrimarykeyName", (Object[])params);
                if (value != null && value.getClass().isArray()) {
                    String[] ret = (String[])value;
                    return ret;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getObjectInRequestOrSessionAttribute(ActionParameter p, String key) {
        if (p.request != null) {
            Object o = p.request.getAttribute(key);
            if (o != null) {
                return o;
            }
            HttpSession session = p.request.getSession();
            if (session != null && (o = session.getAttribute(key)) != null) {
                return o;
            }
        }
        return null;
    }

    public static long getAggregateCount(ActionParameter p, String modelid, String modelitemname) {
        Number num = (Number)JFCUtils.getAggregateValue("Count", modelid, modelitemname, p);
        if (num == null) {
            return -1L;
        }
        return num.longValue();
    }

    public static long getAggregateSum(ActionParameter p, String modelid, String modelitemname) {
        Number num = (Number)JFCUtils.getAggregateValue("Sum", modelid, modelitemname, p);
        if (num == null) {
            return -1L;
        }
        return num.longValue();
    }

    public static double getAggregateAvg(ActionParameter p, String modelid, String modelitemname) {
        Number num = (Number)JFCUtils.getAggregateValue("Avg", modelid, modelitemname, p);
        if (num == null) {
            return -1.0;
        }
        return num.doubleValue();
    }

    public static Object getAggregateMax(ActionParameter p, String modelid, String modelitemname) {
        return JFCUtils.getAggregateValue("Max", modelid, modelitemname, p);
    }

    public static Object getAggregateMin(ActionParameter p, String modelid, String modelitemname) {
        return JFCUtils.getAggregateValue("Min", modelid, modelitemname, p);
    }

    private static Object getAggregateValue(String type, String modelid, String modelitemname, ActionParameter p) {
        String key;
        if (p.request == null) {
            return null;
        }
        HttpSession session = p.request.getSession();
        Map map = (Map)session.getAttribute(key = "__jfc_aggregate_results_" + "Get" + type + "ShowList" + StringUtil.capFirst((String)modelid) + "ProcessBean");
        if (map == null) {
            return null;
        }
        return map.get(modelitemname);
    }

    public static boolean isRestAPI(ActionParameter p) {
        if (p == null) {
            return false;
        }
        return JFCUtils.isRestAPI(p.request);
    }

    public static boolean isRestAPI(HttpServletRequest request) {
        String s;
        String string = s = request != null ? request.getServletPath() : "";
        return s.startsWith("/rest/") || s.startsWith("/v3/");
    }

    public static boolean isRestAPIWithHeaderAuth(ActionParameter p) {
        if (p == null) {
            return false;
        }
        return JFCUtils.isRestAPIWithHeaderAuth(p.request);
    }

    public static boolean isRestAPIWithHeaderAuth(HttpServletRequest request) {
        if (!JFCUtils.isRestAPI(request)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)request.getHeader("X-Wagby-Authorization"));
    }

    public static boolean isSimpleUpdate(ActionParameter p) {
        return Boolean.TRUE.equals(p.request.getAttribute("__jfc_is_simple_update"));
    }

    public static boolean needsVersionItem(ActionParameter p) {
        if (!JFCUtils.isRestAPI(p)) {
            return false;
        }
        String screenType = (String)p.request.getAttribute("__jfc_screen_type");
        if (!"update".equals(screenType)) {
            return false;
        }
        return JFCUtils.isSimpleUpdate(p);
    }

    public static String getJholidayModernCalendarviewColor() {
        return JholidayModernCalendarviewColor;
    }

    public static Charset getDownloadCharset(String rawMimeType) {
        if (StringUtils.isBlank((CharSequence)rawMimeType)) {
            return Charsets.Shift_JIS.charset();
        }
        MimeType mimeType = null;
        try {
            mimeType = new MimeType(rawMimeType);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            // empty catch block
        }
        if (mimeType == null || !"text".equals(mimeType.getPrimaryType())) {
            return Charsets.Shift_JIS.charset();
        }
        return jfcConfig.getDownloadCharset();
    }

    public static void clearSessionCache(HttpSession session) {
        UserPreferenceController.clearSessionCache(session);
        session.removeAttribute(UserInfoMapAttrName);
        ArrayList<String> removeAttrs = new ArrayList<String>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            if (!attr.startsWith("__user.menubar.cache.key_")) continue;
            removeAttrs.add(attr);
        }
        for (String attr : removeAttrs) {
            session.removeAttribute(attr);
        }
    }

    public static boolean isSystemModel(String id) {
        return InitLoaderFormInfoUtil.IS_SYSTEM_MODEL(id);
    }

    public static String eval(String code, String filename, ActionParameter p) {
        ScriptEngine engine = null;
        Object ret = null;
        String modelId = null;
        if (filename != null && p != null) {
            engine = (ScriptEngine)p.request.getAttribute("__jfc_script_engine_" + filename);
        }
        if (engine == null) {
            ScriptEngineManager manager = new ScriptEngineManager();
            engine = manager.getEngineByName("JavaScript");
        }
        if (p != null) {
            Enumeration em = p.request.getAttributeNames();
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                if (!key.startsWith("__jsobj_")) continue;
                modelId = key.substring("__jsobj_".length());
                break;
            }
        }
        if (engine != null) {
            try {
                if (modelId != null) {
                    code = StringUtil.replaceAll((String)code, (String)"This()", modelId);
                }
                ret = engine.eval(code);
            }
            catch (ScriptException e) {
                e.printStackTrace();
                throw new BusinessLogicException(e);
            }
        } else {
            throw new BusinessLogicException("Failed to access engine object.");
        }
        return ret != null ? ret.toString() : null;
    }

    public static void main(String[] args) {
        String s1 = "{ \"ja\":\"\u3053\u3093\u306b\u3061\u306f\", \"en\":\"hello\" }";
        System.out.println(JFCUtils.interpretContentByLocale(s1, "ja"));
        System.out.println(JFCUtils.interpretContentByLocale(s1, "en"));
        System.out.println(JFCUtils.interpretContentByLocale(s1, "ja_JP"));
        System.out.println(JFCUtils.interpretContentByLocale(s1, "kr"));
        String s2 = "\u3042";
        System.out.println(JFCUtils.interpretContentByLocale(s2, "ja"));
        System.out.println(JFCUtils.interpretContentByLocale(s2, "en"));
        System.out.println(JFCUtils.interpretContentByLocale(s2, "ja_JP"));
        System.out.println(JFCUtils.interpretContentByLocale(s2, "kr"));
    }

    public static User getUserInSession(HttpServletRequest request) {
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        return JFCUtils.getUserInSession(request.getSession(), (ApplicationContext)appctx);
    }

    public static User getUserInSession(HttpSession session, HttpServletRequest request) {
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        return JFCUtils.getUserInSession(session, (ApplicationContext)appctx);
    }

    public static User getUserInSession(ActionParameter p) {
        return JFCUtils.getUserInSession(p.request.getSession(), p.appctx);
    }

    public static User getUserInSession(HttpSession session, ApplicationContext appctx) {
        if (session == null) {
            return null;
        }
        try {
            User user = (User)session.getAttribute("__jfc_user");
            if (user == null) {
                return null;
            }
            user.setSession(session);
            user.setApplicationContext(appctx);
            session.setAttribute("__jfc_user", (Object)user);
            return user;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static void setUserInSession(HttpSession session, User user) {
        User olduser = (User)session.getAttribute("__jfc_user");
        if (olduser != null) {
            HttpSession s1 = olduser.getSession();
            if (s1 != null) {
                logger.debug("olduser.session.id " + s1.getId());
                if (s1.getId().equals(session.getId())) {
                    logger.debug("olduser.session set null");
                    olduser.setSession(null);
                }
            } else {
                logger.debug("olduser.session is null");
            }
            logger.debug("olduser.sessionid " + olduser.getSessionId());
            if (session.getId().equals(olduser.getSessionId())) {
                logger.debug("olduser.sessionid set null");
                olduser.setSessionId(null);
            }
        } else {
            logger.debug("olduser is null");
        }
        if (logger.isDebugEnabled()) {
            if (user.getSession() != null) {
                logger.debug("user.sessionid " + user.getSession().getId());
            } else {
                logger.debug("user.session is null");
            }
            logger.debug("sessionId:" + session.getId());
        }
        session.setAttribute("__jfc_user", (Object)user);
        if (user.getSession() == null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, "JFCUtils");
            if (olduser != null) {
                olduser.valueUnbound(event);
            }
            user.valueBound(event);
        }
    }

    public static void logmsgHeapInfo(ActionParameter p, String msg, Logger logger) {
        MemoryUsage usage = mbean.getHeapMemoryUsage();
        long used = usage.getUsed();
        long max = usage.getMax();
        double percent = (double)used / (double)max * 100.0;
        double used_mb = (double)used / 1000000.0;
        double max_mb = (double)max / 1000000.0;
        StringBuilder sb = new StringBuilder(msg);
        sb.append(" used=").append(String.format("%,.2f Mbyte", used_mb));
        sb.append(" (").append(String.format("%,d bytes.)", used));
        sb.append(" max=").append(String.format("%,.2f MByte", max_mb));
        sb.append(" (").append(String.format("%,d bytes.)", max));
        sb.append(" rate=").append(String.format("%.2f", percent)).append(" %");
        logger.info(JFCUtils.logmsg(p, sb.toString()));
    }

    public static File createFile(String filename) {
        String CATALINA_HOME_HEADER = "$catalina.home";
        String UPLOAD_DIR_HEADER = "$upload_dir";
        if (filename.startsWith("$catalina.home")) {
            String rdir1 = JFCUtils.removeHeaderKeyword(filename, "$catalina.home");
            return new File(JFCUtils.getCatalinaHomeDir(), rdir1);
        }
        if (filename.startsWith("$upload_dir")) {
            String rdir1 = JFCUtils.removeHeaderKeyword(filename, "$upload_dir");
            return new File(JFCUtils.getUploadDir(), rdir1);
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return null;
    }

    public static String getCatalinaHomeDir() {
        return System.getProperty("catalina.home");
    }

    public static File getUploadDir() {
        String UPLOAD_DIR_PATH = "../../upload_dir";
        return new File("../../upload_dir");
    }

    private static String removeHeaderKeyword(String rdirname, String keyword) {
        String rdir1 = null;
        for (int i = keyword.length(); i < rdirname.length(); ++i) {
            char c = rdirname.charAt(i);
            if (c == '/' || c == '\\') continue;
            rdir1 = rdirname.substring(i);
            break;
        }
        if (rdir1 == null) {
            throw new IllegalStateException();
        }
        return rdir1;
    }

    public static void debug(ActionParameter p) {
        JFCUtils.debug_attrs(p, true);
        JFCUtils.debug_session(p, true);
        JFCUtils.debug_params(p);
    }

    public static void debugAll(ActionParameter p) {
        JFCUtils.debug_attrs(p, false);
        JFCUtils.debug_session(p, false);
        JFCUtils.debug_params(p);
    }

    public static void debug(String type, ActionParameter p) {
        if ("p".equals(type = type != null ? type.toLowerCase() : "") || "param".equals(type)) {
            JFCUtils.debug_params(p);
        } else if ("a".equals(type) || "attribute".equals(type)) {
            JFCUtils.debug_attrs(p, true);
        } else if ("s".equals(type) || "session".equals(type)) {
            JFCUtils.debug_session(p, true);
        }
    }

    public static void debugAll(String type, ActionParameter p) {
        if ("p".equals(type = type != null ? type.toLowerCase() : "") || "param".equals(type)) {
            JFCUtils.debug_params(p);
        } else if ("a".equals(type) || "attribute".equals(type)) {
            JFCUtils.debug_attrs(p, false);
        } else if ("s".equals(type) || "session".equals(type)) {
            JFCUtils.debug_session(p, false);
        }
    }

    private static void debug_attrs(ActionParameter p, boolean ignoreOtherObject) {
        System.out.println("Attribute ::");
        Enumeration _names = p.request.getAttributeNames();
        while (_names.hasMoreElements()) {
            String _name = (String)_names.nextElement();
            if (ignoreOtherObject && (_name.startsWith("org.") || _name.startsWith("__spring") || _name.endsWith(".FILTERED") || _name.endsWith(".js"))) continue;
            Object _value = p.request.getAttribute(_name);
            System.out.println("  " + _name + "=" + _value.toString());
        }
    }

    private static void debug_session(ActionParameter p, boolean ignoreOtherObject) {
        System.out.println("Session ::");
        Enumeration _names = p.request.getSession().getAttributeNames();
        while (_names.hasMoreElements()) {
            String _name = (String)_names.nextElement();
            if (ignoreOtherObject && (_name.startsWith("javax.") || _name.startsWith("SPRING_"))) continue;
            Object _value = p.request.getSession().getAttribute(_name);
            System.out.println("  " + _name + "=" + _value.toString());
        }
    }

    private static void debug_params(ActionParameter p) {
        System.out.println("Parameter ::");
        Enumeration _names = p.request.getParameterNames();
        while (_names.hasMoreElements()) {
            String _name = (String)_names.nextElement();
            String _value = p.request.getParameter(_name);
            System.out.println("  " + _name + "=" + _value);
        }
    }

    public static void debugKey(ActionParameter p) {
        JFCUtils.debugKey(p, true);
    }

    public static void debugKey(ActionParameter p, boolean ignoreOtherObject) {
        String _name;
        System.out.println("Parameter ::");
        Enumeration _names = p.request.getParameterNames();
        while (_names.hasMoreElements()) {
            _name = (String)_names.nextElement();
            System.out.println("  " + _name);
        }
        System.out.println("Attribute ::");
        _names = p.request.getAttributeNames();
        while (_names.hasMoreElements()) {
            _name = (String)_names.nextElement();
            if (ignoreOtherObject && (_name.startsWith("org.") || _name.startsWith("__spring") || _name.endsWith(".FILTERED") || _name.endsWith(".js"))) continue;
            System.out.println("  " + _name);
        }
    }

    public static void debugKey(HttpServletRequest request) {
        if (request == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration _names = request.getAttributeNames();
        while (_names.hasMoreElements()) {
            String _name = (String)_names.nextElement();
            if (_name.startsWith("org.") || _name.startsWith("__spring") || _name.endsWith(".FILTERED") || _name.endsWith(".js")) continue;
            sb.append(_name).append(" ");
        }
        System.out.println(sb.toString());
    }

    public static void debugKey(HttpSession session) {
        if (session == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration _names = session.getAttributeNames();
        while (_names.hasMoreElements()) {
            String _name = (String)_names.nextElement();
            if (_name.startsWith("org.") || _name.startsWith("__spring") || _name.endsWith(".FILTERED") || _name.endsWith(".js")) continue;
            sb.append(_name).append(" ");
        }
        System.out.println(sb.toString());
    }

    public static Object getSynchronizedLock(HttpSession session) {
        if (session == null) {
            throw new NullPointerException("session must not be null.");
        }
        return session.getId().intern();
    }

    public static boolean waitUntilCanRead(String filename) {
        return JFCUtils.waitUntilCanRead(new File(filename));
    }

    public static boolean waitUntilCanRead(File f) {
        return FileUtil.canRead((File)f, (int)canReadMaxWaitCount, (int)canReadWaitMillSec);
    }

    public static String getIsHolidayScriptName() {
        return _isHolidayScriptName;
    }

    public static boolean getIsOutputStatusToConsole() {
        return isOutputStatusToConsole;
    }

    public static ServletContext getServletContext(ApplicationContext appctx) {
        if (appctx == null) {
            return null;
        }
        return (ServletContext)appctx.getBean(ServletContext.class);
    }

    public static boolean checkControllerPermission(String controllerBeanId, ActionParameter p) {
        return ((BaseController)p.appctx.getBean(controllerBeanId, BaseController.class)).checkPermissionNoLog(p);
    }

    public static String getEnv(String name) {
        String v;
        Properties properties;
        block5: {
            properties = null;
            try {
                properties = PropertyUtils.loadResourceQuietly("application.properties");
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        String string = v = properties != null ? properties.getProperty(name) : null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        v = System.getProperty(name);
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        v = System.getenv(name);
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        return null;
    }

    public static boolean isCheckLogonPermission(String pclassname, String pname, String action, ActionParameter p) {
        CheckLogonBase cl = new CheckLogonBase(p.request);
        cl.setPermclassname(pclassname);
        cl.setPermname(pname);
        cl.setPermactions(action);
        return cl.checkLogon(p.user);
    }

    public static boolean isCheckLogonPrincipal(String principals, ActionParameter p) {
        CheckLogonBase cl = new CheckLogonBase(p.request);
        cl.setPrincipals(principals);
        return cl.checkLogon(p.user);
    }

    public static File createTempFile(String modelId, String suffix) {
        StringBuilder sb = new StringBuilder();
        ResourceManager savedirresman = new ResourceManager("savedir");
        String savedir = savedirresman.getValue("savedir." + modelId);
        savedir = StringUtil.replace((String)savedir, (String)"${catalina.home}", (String)System.getProperty("catalina.home"));
        sb.append(savedir);
        try {
            Path path = Paths.get(sb.toString(), new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            return Files.createTempFile(path, "__tmp", "." + suffix, new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isCSRFTokenValid(ActionParameter p) {
        if (p == null) {
            return false;
        }
        if (!JFCUtils.checkClientSessionId(p)) {
            return true;
        }
        String hashedClientId = JFCUtils.getClientSessionId(p);
        if (hashedClientId == null || hashedClientId.trim().length() < 1) {
            return false;
        }
        HttpSession session = p.request.getSession();
        String sessionId = session.getId();
        if (sessionId == null || sessionId.trim().length() < 1) {
            return false;
        }
        String hashedServerId = StringUtil.getMD5Hash((String)sessionId.trim());
        return hashedClientId.equals(hashedServerId);
    }

    private static boolean checkClientSessionId(ActionParameter p) {
        if (p == null) {
            return false;
        }
        Boolean b = (Boolean)p.request.getAttribute("__jfc_check_client_session_id");
        if (b != null && b == Boolean.FALSE) {
            return false;
        }
        String check = JFCUtils.getServletContext(p.appctx).getInitParameter("check_client_session_id");
        if (check == null || check.trim().length() < 1 || check.trim().equalsIgnoreCase("false")) {
            return false;
        }
        return check.trim().equalsIgnoreCase("true");
    }

    private static String getClientSessionId(ActionParameter p) {
        Object obj;
        String sessionId = p.request.getParameter(SessionIdParamName);
        if (sessionId != null) {
            return sessionId;
        }
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi != null && multi.isMultipartContent(p.request) && (obj = multi.getContents(SessionIdParamName)) != null && obj instanceof String) {
            sessionId = (String)obj;
        }
        return sessionId;
    }

    public static String getPContent(JFCPresentationModelitemString item) {
        if (item == null) {
            return null;
        }
        return item.getContent();
    }

    public static JFCPresentationModelitemStorerefBase getSelectedModelitem(JFCPresentationModelitemStorerefBase[] items) {
        if (items == null) {
            return null;
        }
        if (items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            if (items[0] == null) {
                return null;
            }
            return items[0];
        }
        for (JFCPresentationModelitemStorerefBase item : items) {
            if (!item.getChoose()) continue;
            return item;
        }
        return null;
    }

    public static boolean isTransferUlpItem(ActionParameter p, Object items1, Object items2) {
        String screentype = (String)p.request.getAttribute("__jfc_screen_type");
        if (screentype == null || !screentype.equals("insert")) {
            return false;
        }
        if (p.action.startsWith("GetXml")) {
            return false;
        }
        if (items1 == null) {
            return items2 != null;
        }
        if (items2 == null) {
            return true;
        }
        if (items1 instanceof JFCPresentationModelitemStorerefBase[]) {
            if (!items1.getClass().equals(items2.getClass())) {
                logger.error("failed different class. items1.class:" + items1.getClass() + " items2.class:" + items2.getClass());
                return true;
            }
            return JFCUtils.isTransferUlpItem((JFCPresentationModelitemStorerefBase[])items1, (JFCPresentationModelitemStorerefBase[])items2);
        }
        if (items1 instanceof JFCPresentationModelitemString) {
            if (!(items2 instanceof JFCPresentationModelitemString)) {
                logger.error("failed different class. items1.class:" + items1.getClass() + " items2.class:" + items2.getClass());
                return true;
            }
            return JFCUtils.isTransferUlpItem((JFCPresentationModelitemString)items1, (JFCPresentationModelitemString)items2);
        }
        logger.error("Not supported items type. items1.class:" + items1.getClass() + " items2.class:" + items2.getClass());
        return false;
    }

    private static boolean isTransferUlpItem(JFCPresentationModelitemStorerefBase[] items1, JFCPresentationModelitemStorerefBase[] items2) {
        JFCPresentationModelitemStorerefBase item1 = JFCUtils.getSelectedModelitem(items1);
        JFCPresentationModelitemStorerefBase item2 = JFCUtils.getSelectedModelitem(items2);
        return JFCUtils.isTransferUlpItem(item1, item2);
    }

    private static boolean isTransferUlpItem(JFCPresentationModelitemStorerefBase item1b, JFCPresentationModelitemStorerefBase item2b) {
        if (item1b == null) {
            return item2b != null;
        }
        if (item2b == null) {
            return true;
        }
        List<Method> mlist = JFCUtils.getJshpkeyMethods(item1b);
        List<String> item1value = JFCUtils.getPStorerefId(item1b, mlist);
        List<String> item2value = JFCUtils.getPStorerefId(item2b, mlist);
        int len = item1value.size();
        if (len != item2value.size()) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            String item2;
            String item1 = item1value.get(i);
            if (StringUtils.equals((CharSequence)item1, (CharSequence)(item2 = item2value.get(i)))) continue;
            return true;
        }
        return false;
    }

    private static List<Method> getJshpkeyMethods(JFCPresentationModelitemStorerefBase item) {
        Method[] methods;
        Class<?> itemclass = item.getClass();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = itemclass.getMethods()) {
            String methodname;
            if (method.getParameterCount() > 0 || !method.getReturnType().equals(String.class) || !(methodname = method.getName()).startsWith("get") || !methodname.endsWith("JshpkeyAsString")) continue;
            list.add(method);
        }
        return list;
    }

    private static List<String> getPStorerefId(JFCPresentationModelitemStorerefBase item, List<Method> mlist) {
        if (item == null) {
            return Collections.emptyList();
        }
        ArrayList<String> vlist = new ArrayList<String>();
        vlist.add(item.getIdAsString());
        for (Method method : mlist) {
            try {
                String value = (String)method.invoke((Object)item, new Object[0]);
                vlist.add(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("failed invoke getXXXJshpkeyAsString method", (Throwable)e);
            }
        }
        return vlist;
    }

    private static boolean isTransferUlpItem(JFCPresentationModelitemString items1, JFCPresentationModelitemString items2) {
        String item2id;
        String item1id = JFCUtils.getPContent(items1);
        return !StringUtils.equals((CharSequence)item1id, (CharSequence)(item2id = JFCUtils.getPContent(items2)));
    }

    public static boolean getIsOutputUpdateListChildNoChangeMessage() {
        return isOutputUpdateListChildNoChangeMessage;
    }

    public static <FKEY_ENTITY extends ContainerBase<FKEY_ENTITY>> void getShowArrayDatas(FinderContext<?> finderContext, JFCEntityService<FKEY_ENTITY, ?> entityService, List<FKEY_ENTITY> pageEntityList, List<FKEY_ENTITY> allEntityList) {
        List<FKEY_ENTITY> fkeyEntityList = null;
        if (pageEntityList != null) {
            fkeyEntityList = entityService.find(finderContext);
            if (fkeyEntityList == null) {
                return;
            }
            pageEntityList.addAll(fkeyEntityList);
            if (allEntityList == null) {
                return;
            }
            if (!finderContext.isNextPage() && !finderContext.isPrevPage()) {
                allEntityList.addAll(fkeyEntityList);
                return;
            }
        } else if (allEntityList == null) {
            return;
        }
        FinderContext finderContext2 = new FinderContext(finderContext);
        finderContext2.setPageSize(Integer.MAX_VALUE);
        finderContext2.setFirstResult(0);
        List<FKEY_ENTITY> coll = entityService.find(finderContext2);
        if (coll == null) {
            if (fkeyEntityList != null) {
                allEntityList.addAll(fkeyEntityList);
            }
            return;
        }
        allEntityList.addAll(coll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        logger = LogManager.getLogger(JFCUtils.class);
        isJuserAttributeByRequest = false;
        isRecordBrowserTypeIntoLog = false;
        _isHolidayScriptName = null;
        canReadMaxWaitCount = 10;
        canReadWaitMillSec = 10;
        isOutputStatusToConsole = false;
        isOutputThreadNameToLog = false;
        isOutputUpdateListChildNoChangeMessage = false;
        PrimaryKeyEntityMap = new HashMap();
        PrimaryKeyEntityMap.put("&apos;", "'");
        PrimaryKeyEntityMap.put("&quot;", "\"");
        PrimaryKeyEntityMap.put("&amp;", "&");
        PrimaryKeyEntityMap.put("&colon;", ":");
        PrimaryKeyEntityMap.put("&dollar;", "$");
        PrimaryKeyEntityMap.put("&yen;", "\\");
        String BundleBaseName = "jfcbase";
        ResourceBundle res = null;
        try {
            res = ResourceBundle.getBundle(BundleBaseName);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String StrIsJuserAttributeByRequest = null;
        try {
            StrIsJuserAttributeByRequest = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.getJuserAttributeByRequest") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(StrIsJuserAttributeByRequest) && Boolean.valueOf(StrIsJuserAttributeByRequest).booleanValue()) {
            isJuserAttributeByRequest = true;
        }
        String StrIsRecordBrowserTypeIntoLog = null;
        try {
            StrIsRecordBrowserTypeIntoLog = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.IsRecordBrowserTypeIntoLog") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(StrIsRecordBrowserTypeIntoLog) && Boolean.valueOf(StrIsRecordBrowserTypeIntoLog).booleanValue()) {
            isRecordBrowserTypeIntoLog = true;
        }
        String jholidayModernCalendarviewColor = null;
        try {
            jholidayModernCalendarviewColor = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.jholidayModernCalendarviewColor") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        JholidayModernCalendarviewColor = StringUtils.isNotBlank(jholidayModernCalendarviewColor) ? jholidayModernCalendarviewColor : "Calendar1";
        Object defaultLocale = null;
        String userLanguage = System.getProperty("user.language");
        String userCountry = System.getProperty("user.country");
        if (StringUtils.isNotBlank((CharSequence)userLanguage)) {
            defaultLocale = userLanguage;
            if (!"ja".equals(userLanguage) && StringUtils.isNotBlank((CharSequence)userCountry)) {
                defaultLocale = (String)defaultLocale + "_" + userCountry;
            }
        }
        try {
            String jfcbase_defaultLocale;
            String string = jfcbase_defaultLocale = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.defaultLocale") : null;
            if (StringUtils.isNotBlank((CharSequence)jfcbase_defaultLocale)) {
                defaultLocale = jfcbase_defaultLocale;
            }
        }
        catch (MissingResourceException jfcbase_defaultLocale) {
            // empty catch block
        }
        DEFAULT_LOCALE = StringUtils.isNotBlank((CharSequence)defaultLocale) ? defaultLocale : Locale.getDefault().getLanguage();
        String strPrimarykeyLocale = DEFAULT_LOCALE;
        try {
            strPrimarykeyLocale = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.primarykeyLocale") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)strPrimarykeyLocale)) {
            PRIMARYKEY_LOCALE = strPrimarykeyLocale;
        }
        try {
            String jfcbase_canReadMaxWaitCount;
            String string = jfcbase_canReadMaxWaitCount = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.canReadMaxWaitCount") : null;
            if (StringUtils.isNotBlank((CharSequence)jfcbase_canReadMaxWaitCount)) {
                canReadMaxWaitCount = NumberUtils.toInt((String)jfcbase_canReadMaxWaitCount);
            }
        }
        catch (MissingResourceException jfcbase_canReadMaxWaitCount) {
            // empty catch block
        }
        try {
            String jfcbase_canReadWaitMillSec;
            String string = jfcbase_canReadWaitMillSec = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.canReadWaitMillSec") : null;
            if (StringUtils.isNotBlank((CharSequence)jfcbase_canReadWaitMillSec)) {
                canReadWaitMillSec = NumberUtils.toInt((String)jfcbase_canReadWaitMillSec);
            }
        }
        catch (MissingResourceException jfcbase_canReadWaitMillSec) {
            // empty catch block
        }
        try {
            String jfcbase_isHolidayScriptName;
            String string = jfcbase_isHolidayScriptName = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.getIsHolidayScriptName") : null;
            if (StringUtils.isNotBlank((CharSequence)jfcbase_isHolidayScriptName)) {
                _isHolidayScriptName = jfcbase_isHolidayScriptName;
            }
        }
        catch (MissingResourceException jfcbase_isHolidayScriptName) {
        }
        finally {
            if (_isHolidayScriptName == null) {
                _isHolidayScriptName = "script/_isHoliday.js";
            }
        }
        String isOutputStatusToConsoleStr = null;
        try {
            isOutputStatusToConsoleStr = res != null ? res.getString("jp.jasminesoft.jfc.JFCUtils.isOutputStatusToConsole") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(isOutputStatusToConsoleStr)) {
            isOutputStatusToConsole = Boolean.parseBoolean(isOutputStatusToConsoleStr);
        }
        String isOutputThreadNameToLogStr = null;
        try {
            isOutputThreadNameToLogStr = res != null ? res.getString("jp.jasminesoft.jfc.controller.BaseController.isOutputThreadNameToLog") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(isOutputThreadNameToLogStr)) {
            isOutputThreadNameToLog = Boolean.valueOf(isOutputThreadNameToLogStr);
        }
        String isOutputUpdateListChildNoChangeMessageStr = null;
        try {
            isOutputUpdateListChildNoChangeMessageStr = res != null ? res.getString("jp.jasminesoft.jfc.controller.DbUpdateListBaseController.isOutputUpdateListChildNoChangeMessage") : null;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(isOutputUpdateListChildNoChangeMessageStr)) {
            isOutputUpdateListChildNoChangeMessage = Boolean.valueOf(isOutputUpdateListChildNoChangeMessageStr);
        }
        VolatilityValueRequestKeys = new String[]{"__jfc_V_TODAY", "__jfc_V_NOW", "__jfc_V_NOWM"};
        mbean = ManagementFactory.getMemoryMXBean();
    }
}

