/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.tools.license_update.LicenseUpdator;
import jp.jasminesoft.jfc.tools.license_update.LicenseUpdatorException;
import org.apache.http.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KickLicenseUpdator {
    private static Logger logger = LogManager.getLogger(KickLicenseUpdator.class);
    private Map<String, String> paramMap = new HashMap<String, String>();
    private PathProvider pathProvider;

    public KickLicenseUpdator(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
        this.paramMap.put("propfilepath", pathProvider.getPath("/WEB-INF/licenseUpdator.properties"));
        this.paramMap.put("licensefilepath", pathProvider.getPath("/WEB-INF/classes/wagby-licensekey.xml"));
    }

    protected String getClasspathString() {
        String[] jars = new String[]{"j_license_update.jar", "commons-httpclient.jar", "commons-logging.jar", "commons-codec.jar", "log4j.jar"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < jars.length; ++i) {
            if (i > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(this.pathProvider.getPath("/WEB-INF/lib/" + jars[i]));
        }
        logger.info("(admin@localhost) classpath:" + sb.toString());
        return sb.toString();
    }

    protected List<String> prepareParameter(Map<String, String> param) {
        ArrayList<String> pbParam = new ArrayList<String>();
        pbParam.add("java");
        pbParam.add("-cp");
        pbParam.add(this.getClasspathString());
        pbParam.add("jp.jasminesoft.jfc.tools.license_update.LicenseUpdator");
        if (param != null) {
            this.paramMap.putAll(param);
        }
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            pbParam.add(entry.getKey() + "=" + entry.getValue());
        }
        return pbParam;
    }

    protected String kickLicenseUpdator(Map<String, String> param, String command, String locale) {
        String ret = null;
        if (param != null) {
            this.paramMap.putAll(param);
        }
        LicenseUpdator updator = new LicenseUpdator(this.paramMap);
        if ("update".equals(command)) {
            try {
                updator.updateLicense();
            }
            catch (IllegalArgumentException e) {
                logger.warn("(admin@localhost) " + e.getMessage());
                ret = JFCUtils.getRValue("__jfc_common.msg.licenseupdator.error.load_properties", locale);
            }
            catch (HttpException e) {
                logger.warn("(admin@localhost) " + e.getMessage(), (Throwable)e);
                ret = JFCUtils.getRValue("__jfc_common.msg.licenseupdator.error.connection", locale);
            }
            catch (IOException e) {
                logger.error("(admin@localhost) " + e.getMessage(), (Throwable)e);
                ret = JFCUtils.getRValue("__jfc_common.msg.licenseupdator.error.save_licensekey", locale);
            }
            catch (LicenseUpdatorException e) {
                logger.error("(admin@localhost) " + e.getMessage(), (Throwable)e);
                ret = JFCUtils.getRValue("__jfc_common.msg.licenseupdator.error.checklog", locale);
            }
        }
        if (ret == null) {
            try {
                updator.storeProperties();
            }
            catch (Exception e) {
                logger.warn("(admin@localhost) " + e.getMessage(), (Throwable)e);
                ret = JFCUtils.getRValue("__jfc_common.msg.licenseupdator.error.save_properties", locale);
            }
        }
        return ret;
    }

    public String kickUpdateProcess(Map<String, String> param, String locale) {
        return this.kickLicenseUpdator(param, "update", locale);
    }

    public String kickSaveProcess(Map<String, String> param, String locale) {
        return this.kickLicenseUpdator(param, "save", locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String kickLicenseUpdatorAsProcessBuilder(List<String> pbParam) {
        Process prcs = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            prcs = new ProcessBuilder(pbParam).redirectErrorStream(true).start();
            br = new BufferedReader(new InputStreamReader(prcs.getInputStream()));
            String s = br.readLine();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
            }
        }
        catch (IOException e) {
            logger.error("(admin@localhost) " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error("(admin@localhost) " + e.getMessage(), (Throwable)e);
                }
            }
        }
        logger.info("(admin@localhost) result:" + sb.toString());
        return sb.toString();
    }

    public String kickUpdateProcessAsProcessBuilder(Map<String, String> param) {
        List<String> pbParam = this.prepareParameter(param);
        pbParam.add("update");
        return this.kickLicenseUpdatorAsProcessBuilder(pbParam);
    }

    public String kickSaveProcessAsProcessBuilder(Map<String, String> param) {
        List<String> pbParam = this.prepareParameter(param);
        pbParam.add("save");
        return this.kickLicenseUpdatorAsProcessBuilder(pbParam);
    }

    public static interface PathProvider {
        public String getPath(String var1);
    }
}

