/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import jp.jasminesoft.jfc.ClusterEvent;
import jp.jasminesoft.jfc.ClusterListener;
import jp.jasminesoft.jfc.ClusterManager;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.LockManagerDbImpl;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockManagerClusterImpl
extends LockManagerDbImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger((String)LockManagerClusterImpl.class.getName());

    public LockManagerClusterImpl() {
        ClusterManager clusterman = ClusterManagerFactory.getClusterManager();
        if (!clusterman.getUseCluster()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00804), LogCodeManager.getMessage(LogCode.JFC00804, new String[0]));
        }
        this.setMachinename(clusterman.getThisMachinename());
        if (this.getMachinename() == null || "".equals(this.getMachinename())) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00805), LogCodeManager.getMessage(LogCode.JFC00805, new String[0]));
        }
        logger.debug("running cluster, lock manager machine " + this.getMachinename());
        clusterman.addClusterListener(new ClusterListener(){

            @Override
            public void addResponseMachine(ClusterEvent event) {
            }

            @Override
            public void removeResponseMachine(ClusterEvent event) {
                String machinename = event.getMachinename();
                LockManagerClusterImpl.this.clear(machinename);
            }
        });
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[LockManagerClusterImpl lockCount:");
        sb.append(this.lockCount);
        sb.append("]");
        return sb.toString();
    }
}

