/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jp.jasminesoft.jfc.LockSingleManager;
import jp.jasminesoft.jfc.LockSingleObject;
import jp.jasminesoft.jfc.LockSingleObjectImpl;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockManagerImpl
implements Serializable,
LockSingleManager {
    private static final Logger logger = LogManager.getLogger((String)LockManagerImpl.class.getName());
    protected HashMap lockobjKeyMap;
    protected List<String> disabledModelIds = new ArrayList<String>();

    public LockManagerImpl() {
        this.lockobjKeyMap = new HashMap();
    }

    @Override
    public synchronized LockSingleObject addLockObject(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return null;
        }
        ArrayList<LockSingleObject> list = (ArrayList<LockSingleObject>)this.lockobjKeyMap.get(lo.getLockName());
        if (list != null) {
            if (list.size() != 0) {
                if (lo.isLockForAll()) {
                    for (LockSingleObject _lo : list) {
                        if (_lo.getSessionId().equals(lo.getSessionId())) continue;
                        logger.debug(lo + " has already locked (1). canceled.");
                        return _lo;
                    }
                } else {
                    for (LockSingleObject _lo : list) {
                        if (!_lo.isLockForAll() && !LockManagerImpl.equalsPrimaryKey(_lo.getLockDataKey(), lo.getLockDataKey())) continue;
                        if (_lo.getSessionId().equals(lo.getSessionId())) {
                            logger.debug(lo + " has already locked same session id. skip to add lock object.");
                            return null;
                        }
                        if (_lo.isLockForAll()) {
                            logger.debug(lo + " has already locked all. canceled.");
                            return _lo;
                        }
                        logger.debug(lo + " has locked " + _lo.getUsername() + ". canceled.");
                        return _lo;
                    }
                }
            }
        } else {
            list = new ArrayList<LockSingleObject>();
            this.lockobjKeyMap.put(lo.getLockName(), list);
        }
        list.add(lo);
        logger.debug("add " + lo);
        return null;
    }

    @Override
    public synchronized boolean isLocked(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return true;
        }
        List list = (List)this.lockobjKeyMap.get(lo.getLockName());
        if (list == null) {
            return false;
        }
        if (list.size() == 0) {
            return false;
        }
        for (LockSingleObject _lo : list) {
            if (_lo.isLockForAll()) {
                if (_lo.getSessionId().equals(lo.getSessionId())) {
                    logger.debug(lo + " has already locked session id is same.");
                    return true;
                }
                logger.debug(lo + " has already locked. session id is different.");
                return false;
            }
            if (!LockManagerImpl.equalsPrimaryKey(_lo.getLockDataKey(), lo.getLockDataKey())) continue;
            if (_lo.getSessionId().equals(lo.getSessionId())) {
                logger.debug(lo + " has already locked in the same session.");
                return true;
            }
            logger.debug(lo + " has locked " + _lo.getUsername() + ". session id is different.");
            return false;
        }
        logger.debug("not contains " + lo);
        return false;
    }

    @Override
    public synchronized boolean contains(LockSingleObject lo) {
        List list = (List)this.lockobjKeyMap.get(lo.getLockName());
        if (list != null && list.size() != 0) {
            if (lo.isLockForAll()) {
                for (LockSingleObject _lo : list) {
                    if (_lo.getSessionId().equals(lo.getSessionId())) continue;
                    logger.debug(lo + " has already locked (1). session id is different.");
                    return false;
                }
                logger.debug("contains " + lo);
                return true;
            }
            for (LockSingleObject _lo : list) {
                if (!_lo.isLockForAll() && !LockManagerImpl.equalsPrimaryKey(_lo.getLockDataKey(), lo.getLockDataKey())) continue;
                if (_lo.getSessionId().equals(lo.getSessionId())) {
                    logger.debug(lo + " has already locked. session id is same.");
                    return false;
                }
                if (_lo.isLockForAll()) {
                    logger.debug(lo + " has already locked all. session id is different.");
                    return true;
                }
                logger.debug(lo + " has locked " + _lo.getUsername() + ". session id is different.");
                return true;
            }
        }
        logger.debug("return false." + lo);
        return false;
    }

    protected static boolean equalsPrimaryKey(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Object[]) {
            if (o2 instanceof Object[]) {
                Object[] oa1 = (Object[])o1;
                Object[] oa2 = (Object[])o2;
                if (oa1.length != oa2.length) {
                    return false;
                }
                for (int i = 0; i < oa1.length; ++i) {
                    if (oa1[i].equals(oa2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o2 instanceof Object[]) {
            return false;
        }
        return o1.equals(o2);
    }

    protected static int hashCodePrimaryKey(Object o1) {
        if (o1 == null) {
            return 0;
        }
        if (o1 instanceof Object[]) {
            Object[] oa1 = (Object[])o1;
            int sum = 0;
            for (int i = 0; i < oa1.length; ++i) {
                sum += oa1[i].hashCode();
            }
            return sum;
        }
        return o1.hashCode();
    }

    @Override
    public synchronized String getLockUser(LockSingleObject lo) {
        LockSingleObject _lo = this.getLockObject(lo);
        if (_lo == null) {
            return null;
        }
        return _lo.getUsername();
    }

    public LockSingleObject getLockObject(LockSingleObject lo) {
        List list = (List)this.lockobjKeyMap.get(lo.getLockName());
        if (list != null && list.size() != 0) {
            if (lo.isLockForAll()) {
                Iterator i = list.iterator();
                return (LockSingleObject)i.next();
            }
            for (LockSingleObject _lo : list) {
                if (_lo.isLockForAll()) {
                    return _lo;
                }
                if (!LockManagerImpl.equalsPrimaryKey(_lo.getLockDataKey(), lo.getLockDataKey())) continue;
                return _lo;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean releaseLockObject(LockSingleObject lo) {
        List list = (List)this.lockobjKeyMap.get(lo.getLockName());
        if (list == null) {
            return false;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            LockSingleObject _lo = (LockSingleObject)i.next();
            if (_lo.isLockForAll() != lo.isLockForAll() || !LockManagerImpl.equalsPrimaryKey(_lo.getLockDataKey(), lo.getLockDataKey()) || !_lo.getSessionId().equals(lo.getSessionId())) continue;
            i.remove();
            logger.debug("release " + lo);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void remove(String sessionid) {
        for (List list : this.lockobjKeyMap.values()) {
            Iterator j = list.iterator();
            while (j.hasNext()) {
                LockSingleObject _lo = (LockSingleObject)j.next();
                if (!_lo.getSessionId().equals(sessionid)) continue;
                j.remove();
                logger.debug("release " + _lo);
            }
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[LockManagerImpl ");
        Iterator i = this.lockobjKeyMap.values().iterator();
        while (i.hasNext()) {
            sb.append((List)i.next());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public LockSingleObject createLockObject(String key, String sessionid, User user) {
        return new LockSingleObjectImpl(key, null, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObject(String modelname, Object pkey, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, pkey, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObjectForAll(String modelname, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, null, sessionid, user, true);
    }

    @Override
    public LockSingleObject createLockObject(String lockname, Object lockdatakey, String sessionid, String username, boolean isLockForAll) {
        return new LockSingleObjectImpl(lockname, lockdatakey, sessionid, username, isLockForAll);
    }

    @Override
    public synchronized void clearThismachine() {
        this.lockobjKeyMap.clear();
    }

    @Override
    public void clear(String machinename) {
        logger.log(LogCodeManager.getPriority(LogCode.JFC00800), LogCodeManager.getMessage(LogCode.JFC00800, machinename));
    }

    @Override
    public void setDisabledModelIds(String[] disabledModelIds) {
        this.disabledModelIds = Arrays.asList(disabledModelIds);
    }
}

