/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DefaultLockObjectCreator;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LockObjectCreator;
import jp.jasminesoft.jfc.LockObjectImpl;
import jp.jasminesoft.jfc.LockObjectItem;
import jp.jasminesoft.jfc.LockObjectItemImpl;
import jp.jasminesoft.jfc.LockSingleManager;
import jp.jasminesoft.jfc.LockSingleObject;
import jp.jasminesoft.jfc.User;

public class LockMultipleManagerImpl
implements Serializable,
LockManager {
    private static final long serialVersionUID = 1L;
    private Map<String, LockObjectCreator> lockobjCreatorMap = new HashMap<String, LockObjectCreator>();
    private LockObjectCreator defaultLockobjCreator = new DefaultLockObjectCreator();
    private LockSingleManager lockSingleManager;

    public LockSingleManager getLockSingleManager() {
        return this.lockSingleManager;
    }

    public void setLockSingleManager(LockSingleManager lockSingleManager) {
        this.lockSingleManager = lockSingleManager;
    }

    public void setLockObjectCreatorMap(Map<String, LockObjectCreator> map) {
        this.lockobjCreatorMap = map;
    }

    public void setDefaultLockObjectCreator(LockObjectCreator lockobjCreator) {
        this.defaultLockobjCreator = lockobjCreator;
    }

    private List<LockSingleObject> convertLockObject(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        ArrayList<LockSingleObject> list = new ArrayList<LockSingleObject>();
        for (LockObjectItem item : lo.getItems()) {
            LockSingleObject lso = singleLockManager.createLockObject(item.getLockName(), item.getLockDataKey(), lo.getSessionId(), lo.getUsername(), item.isLockForAll());
            list.add(lso);
        }
        return list;
    }

    @Override
    public synchronized LockObject addLockObject(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        ArrayList<LockSingleObject> faileditems = new ArrayList<LockSingleObject>();
        ArrayList<LockSingleObject> successitems = new ArrayList<LockSingleObject>();
        List<LockSingleObject> list = this.convertLockObject(lo);
        for (LockSingleObject lso : list) {
            LockSingleObject lsor = singleLockManager.addLockObject(lso);
            if (lsor != null) {
                faileditems.add(lsor);
                continue;
            }
            successitems.add(lso);
        }
        if (faileditems.size() == 0) {
            return null;
        }
        for (LockSingleObject lso : successitems) {
            singleLockManager.releaseLockObject(lso);
        }
        int cnt = 0;
        LockObjectItem[] loia = new LockObjectItem[faileditems.size()];
        for (LockSingleObject lso : faileditems) {
            LockObjectItemImpl loi = new LockObjectItemImpl(lso.getLockName(), lso.getLockDataKey(), lso.isLockForAll());
            loia[cnt++] = loi;
        }
        LockSingleObject lso = (LockSingleObject)faileditems.get(0);
        LockObjectImpl failedlo = new LockObjectImpl(lo.getModelname(), lo.getPrimaryKey(), lso.getSessionId(), lso.getUsername(), lo.isLockForAll(), loia);
        return failedlo;
    }

    @Override
    public synchronized boolean isLocked(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        List<LockSingleObject> list = this.convertLockObject(lo);
        for (LockSingleObject lso : list) {
            if (!singleLockManager.isLocked(lso)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean contains(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        List<LockSingleObject> list = this.convertLockObject(lo);
        for (LockSingleObject lso : list) {
            if (!singleLockManager.contains(lso)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized String getLockUser(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        List<LockSingleObject> list = this.convertLockObject(lo);
        if (list.size() == 0) {
            throw new IllegalStateException();
        }
        return singleLockManager.getLockUser(list.get(0));
    }

    @Override
    public synchronized boolean releaseLockObject(LockObject lo) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        boolean flag = false;
        List<LockSingleObject> list = this.convertLockObject(lo);
        for (LockSingleObject lso : list) {
            if (!singleLockManager.releaseLockObject(lso)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public synchronized void remove(String sessionid) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        singleLockManager.remove(sessionid);
    }

    @Override
    public synchronized String toString() {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        StringBuffer sb = new StringBuffer();
        sb.append("[MultipleLockManagerImpl ");
        sb.append(singleLockManager.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public LockObject createLockObjectForData(String modelname, Object data, String sessionid, ActionParameter p) {
        if (this.lockobjCreatorMap.containsKey(modelname)) {
            return this.lockobjCreatorMap.get(modelname).createLockObjectForData(modelname, data, sessionid, p);
        }
        return this.defaultLockobjCreator.createLockObjectForData(modelname, data, sessionid, p);
    }

    @Override
    public LockObject createLockObject(String modelname, Object pkey, String sessionid, ActionParameter p) {
        if (this.lockobjCreatorMap.containsKey(modelname)) {
            return this.lockobjCreatorMap.get(modelname).createLockObject(modelname, pkey, sessionid, p);
        }
        return this.defaultLockobjCreator.createLockObject(modelname, pkey, sessionid, p);
    }

    @Override
    public LockObject createLockObject(String modelname, Object pkey, String sessionid, User user) {
        if (this.lockobjCreatorMap.containsKey(modelname)) {
            return this.lockobjCreatorMap.get(modelname).createLockObject(modelname, pkey, sessionid, user);
        }
        return this.defaultLockobjCreator.createLockObject(modelname, pkey, sessionid, user);
    }

    @Override
    public LockObject createLockObjectForAll(String modelname, String sessionid, User user) {
        if (this.lockobjCreatorMap.containsKey(modelname)) {
            return this.lockobjCreatorMap.get(modelname).createLockObjectForAll(modelname, sessionid, user);
        }
        return this.defaultLockobjCreator.createLockObjectForAll(modelname, sessionid, user);
    }

    @Override
    public synchronized void clearThismachine() {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        singleLockManager.clearThismachine();
    }

    @Override
    public void clear(String machinename) {
        LockSingleManager singleLockManager = this.getLockSingleManager();
        singleLockManager.clear(machinename);
    }
}

