/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.Releasable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockObjectWrapper
implements Releasable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(LockObjectWrapper.class);
    private LockObject lo;
    private LockManager lockManager;

    public LockObjectWrapper(LockObject lo, ActionParameter p) {
        this.lo = lo;
        this.lockManager = LockManagerFactory.getLockManager(p);
    }

    public LockObject getLockObject() {
        return this.lo;
    }

    @Override
    public void release() {
        if (this.lockManager.releaseLockObject(this.lo)) {
            logger.debug("Success to release lock." + this.lo);
        } else {
            logger.debug("Failed to release lock." + this.lo);
        }
    }

    public boolean isLocked() {
        boolean b = this.lockManager.isLocked(this.lo);
        logger.debug(this.lo + " isLocked:" + b);
        return b;
    }
}

