/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Locale;
import java.util.ResourceBundle;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.User;
import org.apache.logging.log4j.Level;

public class LogCodeManager {
    private static final ResourceBundle rb;

    public static Level getPriority(LogCode code) {
        String msg = JFCUtils.getRValue(code.toString(), rb);
        Level level = null;
        if (msg.startsWith("INFO|")) {
            level = Level.INFO;
        } else if (msg.startsWith("WARN|")) {
            level = Level.WARN;
        } else if (msg.startsWith("ERROR|")) {
            level = Level.ERROR;
        } else if (msg.startsWith("FATAL|")) {
            level = Level.FATAL;
        } else if (msg.startsWith("DEBUG|")) {
            level = Level.DEBUG;
        }
        if (level == null) {
            level = Level.DEBUG;
        }
        return level;
    }

    public static String getMessage(LogCode code, String ... oa) {
        return LogCodeManager.getMessage(code, null, oa);
    }

    public static String getMessage(LogCode code, User user, String ... oa) {
        String code_str = LogCodeManager.createCode(code);
        String msg = null;
        msg = oa != null ? JFCUtils.getRValue(code.toString(), (Object[])oa, rb) : JFCUtils.getRValue(code.toString(), rb);
        if (msg.startsWith("INFO|")) {
            msg = msg.substring("INFO|".length());
        } else if (msg.startsWith("WARN|")) {
            msg = msg.substring("WARN|".length());
        } else if (msg.startsWith("ERROR|")) {
            msg = msg.substring("ERROR|".length());
        } else if (msg.startsWith("FATAL|")) {
            msg = msg.substring("FATAL|".length());
        } else if (msg.startsWith("DEBUG|")) {
            msg = msg.substring("DEBUG|".length());
        }
        Object content = code_str + msg;
        content = user != null ? JFCUtils.logmsg(user, (String)content) : "(admin@localhost) " + (String)content;
        return content;
    }

    public static String createCode(LogCode code) {
        StringBuilder sb = new StringBuilder();
        String s = code.toString();
        sb.append(s.substring(0, 3));
        sb.append("-");
        sb.append(s.substring(3));
        sb.append(":");
        return sb.toString();
    }

    static {
        ResourceBundle r = JFCUtils.getProperResourceBundle("logcode", Locale.getDefault());
        if (r == null) {
            r = JFCUtils.getProperResourceBundle("logcode", new Locale("en"));
        }
        rb = r;
    }
}

