/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.sql.Timestamp;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.ScreenMessageListener;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.error.Jfcerrors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordChangeWarnScreenMessageListener
implements ScreenMessageListener {
    private static final Logger logger = LogManager.getLogger((String)PasswordChangeWarnScreenMessageListener.class.getName());

    @Override
    public Jfcerrors createMessage(ActionParameter p) {
        Jfcerrors errors = new Jfcerrors();
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        Timestamp passwdChangeDate = p.user.getPasswdChangeDate();
        if (p.user.checkPasswdChangeFlag()) {
            if (passwdChangeDate != null && !User.isValidPasswd(passwdChangeDate.getTime())) {
                errors.addJfcerror(errorManager.getJfcerror("error.passwd.expired", p.locale));
            } else {
                errors.addJfcerror(errorManager.getJfcerror("error.init.passwd", p.locale));
            }
            return errors;
        }
        if (p.user.nearPasswdTTL()) {
            try {
                errors.addJfcwarn(errorManager.getJfcwarn("warn.near.passwd.ttl", new Object[]{User.getPasswdTTL(passwdChangeDate.getTime())}, p.locale));
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00030), LogCodeManager.getMessage(LogCode.JFC00030, new String[0]));
                logger.debug((Object)e);
            }
        }
        return errors;
    }
}

