/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.ModelUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PrimaryKeyUtils {
    public static final String DEFAULT_PKEY_SEPARATOR = "$SEP$";
    public static final String DEFAULT_PKEY_SEPARATOR_REGEXP = "\\$SEP\\$";
    public static final String DEFAULT_PKEY_SEPARATOR_OLDFASHION = "$";
    public static final String DEFAULT_PKEY_SEPARATOR_REGEXP_OLDFASHION = "\\$";
    private static String pkeySeparator;
    private static String pkeySeparatorRegexp;

    public static String PKEY_SEPARATOR() {
        return pkeySeparator;
    }

    public static String PKEY_SEPARATOR_REGEXP() {
        return pkeySeparatorRegexp;
    }

    public static String toString(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (String)key;
        }
        if (key instanceof Timestamp) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(key);
        }
        if (key instanceof Byte || key instanceof Short || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Double || key instanceof Date || key instanceof Time) {
            return String.valueOf(key);
        }
        if (key instanceof ContainerBase) {
            return PrimaryKeyUtils.toString((ContainerBase)key);
        }
        throw new IllegalArgumentException();
    }

    public static String toString(ContainerBase<?> key) {
        if (key == null) {
            return null;
        }
        Class<?> clazz = key.getClass();
        String packageName = ClassUtils.getPackageName(clazz);
        EntityMeta entityMeta = null;
        try {
            String metaClassName = packageName + "." + StoreModelUtils.metaName(ModelUtils.getModelId(key.getClass()));
            Class metaClass = ClassUtils.getClass((String)metaClassName);
            entityMeta = (EntityMeta)ConstructorUtils.invokeConstructor((Class)metaClass, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (clazz.equals(entityMeta.entityClass())) {
            throw new IllegalArgumentException("key must not be model class. Please use XXXHelper.getPrimaryKeyAsString().");
        }
        PropertyMeta<?>[] pkeymetas = entityMeta.primarykeyMeta();
        ArrayList list = new ArrayList();
        for (PropertyMeta<?> meta : pkeymetas) {
            Object obj = ReflectionUtils.getPrivateField(key, meta.name());
            list.add(obj);
        }
        return PrimaryKeyUtils.toString(list);
    }

    public static String toString(Collection<?> keys) {
        return PrimaryKeyUtils.toString(keys.toArray(new Object[keys.size()]));
    }

    public static String toString(Object ... keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object key : keys) {
            if (key == null) {
                sb.append("null");
            }
            sb.append(PrimaryKeyUtils.toString(key));
            sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
        }
        return StringUtils.removeEnd((String)sb.toString(), (String)PrimaryKeyUtils.PKEY_SEPARATOR());
    }

    public static boolean isEmpty(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        String[] tokens = code.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
        if (tokens.length > 0) {
            for (String token : tokens) {
                if (!StringUtils.isEmpty((CharSequence)token) && (!NumberUtils.isDigits((String)token) || NumberUtils.toInt((String)token) > 0)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            ResourceBundle res = ResourceBundle.getBundle("jfcbase");
            String oldfashioned = res.getString("jp.jasminesoft.jfc.PrimaryKeyUtils.oldfashioned");
            if (oldfashioned != null && Boolean.parseBoolean(oldfashioned)) {
                pkeySeparator = DEFAULT_PKEY_SEPARATOR_OLDFASHION;
                pkeySeparatorRegexp = DEFAULT_PKEY_SEPARATOR_REGEXP_OLDFASHION;
                System.out.println("Use old-fashioned primary key separator.");
            } else {
                pkeySeparator = DEFAULT_PKEY_SEPARATOR;
                pkeySeparatorRegexp = DEFAULT_PKEY_SEPARATOR_REGEXP;
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        finally {
            if (StringUtils.isBlank((CharSequence)pkeySeparator)) {
                pkeySeparator = DEFAULT_PKEY_SEPARATOR;
            }
            if (StringUtils.isBlank((CharSequence)pkeySeparatorRegexp)) {
                pkeySeparatorRegexp = DEFAULT_PKEY_SEPARATOR_REGEXP;
            }
        }
    }
}

