/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.jasminesoft.jfc.model.jcategory.Jcategory;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.jfc.model.juser.Juser;
import jp.jasminesoft.jfc.model.lastaccesstime.Lastaccesstime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyManager {
    private static final Logger logger = LogManager.getLogger((String)PropertyManager.class.getName());
    public static final String BundleBaseName = "jfcbase";
    private static final String juserClassName = Juser.class.getName();
    private static final String lastaccesstimeClassName = Lastaccesstime.class.getName();
    private static final String jprincipalClassName = Jprincipal.class.getName();
    private static final String jcategoryClassName = Jcategory.class.getName();
    private static final String[][] default_value = new String[][]{{"jp.jasminesoft.jfc.HibernateUserInfo.getJuser.query", "select c from " + juserClassName + " as c where c.userid_ = :userid"}, {"jp.jasminesoft.jfc.HibernateUserInfo.getJuserForPreference.query", "select c from " + juserClassName + " as c where c.userid_ = :userid"}, {"jp.jasminesoft.jfc.HibernateUserInfo.getAllUsername.query", "select c.userid_ from " + juserClassName + " as c"}, {"jp.jasminesoft.jfc.HibernateUserInfo.getLastAccessTime.query", "select c.time_ from " + lastaccesstimeClassName + " as c where c.juserid_ in (select d.id_ from " + juserClassName + " as d where d.userid_ = :userid)"}, {"jp.jasminesoft.jfc.HibernateUserInfo.setLastAccessTime.query", "update " + lastaccesstimeClassName + " as c set c.time_ = :lastaccesstime where c.time_ < :lastaccesstime and c.juserid_ in (select d.id_ from " + juserClassName + " as d where d.userid_ = :userid)"}, {"jp.jasminesoft.jfc.HibernateUserInfo.toString.query", "select c from " + juserClassName + " as c"}, {"jp.jasminesoft.jfc.app.HibernateMasterJprincipal.init.query", "select c from " + jprincipalClassName + " as c"}, {"jp.jasminesoft.jfc.app.PrincipalCategoryManager.init.query", "select c from " + jcategoryClassName + " as c"}};
    private static HashMap default_value_map = new HashMap();

    public static String getProperty(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        try {
            ResourceBundle res = ResourceBundle.getBundle(BundleBaseName);
            value = res.getString(name);
        }
        catch (MissingResourceException e) {
            String s = "No resource jfcbase is found.";
            logger.debug(s, (Throwable)e);
        }
        if (value == null) {
            value = PropertyManager.getDefaultProperty(name);
        }
        return value;
    }

    public static String getBundleName() {
        return BundleBaseName;
    }

    private static String getDefaultProperty(String name) {
        return (String)default_value_map.get(name);
    }

    static {
        for (int i = 0; i < default_value.length; ++i) {
            String[] value = default_value[i];
            default_value_map.put(value[0], value[1]);
        }
    }
}

