/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.JFCBaseTablename;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;

public class TableConfigManager
implements ServletContextAware,
ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger((String)TableConfigManager.class.getName());
    private static TableConfigManager _instance = new TableConfigManager();
    private static ApplicationContext applicationContext;
    private String quote_id = null;
    private String quote_where = null;
    private String quote_id_in_where = null;
    private boolean jdbc2 = true;
    private boolean autojdbc2 = false;
    private HashMap tableclassMap = new HashMap();
    private HashMap objclassMap = new HashMap();
    private boolean usejdbc2 = false;
    private String dbtype;
    private String sequenceDML;

    public static TableConfigManager getInstance() {
        if (applicationContext != null) {
            return (TableConfigManager)applicationContext.getBean(TableConfigManager.class);
        }
        return _instance;
    }

    public void setServletContext(ServletContext sc) {
        String sequenceDML;
        String dbtype;
        String quote_id = sc.getInitParameter("jdbc.quote_id");
        logger.info("quote_id=" + quote_id);
        this.setQuoteId(quote_id);
        String quote_where = sc.getInitParameter("jdbc.quote_where");
        this.setQuoteWhere(quote_where);
        String quote_id_in_where = sc.getInitParameter("jdbc.quote_id_in_where");
        this.setQuoteIdInWhere(quote_id_in_where);
        String jdbc2 = sc.getInitParameter("jdbc.jdbc2");
        if (jdbc2 != null) {
            this.setJdbc2(Boolean.valueOf(jdbc2));
        }
        if ((dbtype = sc.getInitParameter("dbtype")) != null) {
            this.setDbtype(dbtype);
        }
        if ((sequenceDML = sc.getInitParameter("sequenceDML")) != null) {
            this.sequenceDML = sequenceDML;
        }
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
    }

    protected TableConfigManager() {
        for (String[] tableclassname : JFCBaseTablename.TableClassnames) {
            this.tableclassMap.put(tableclassname[0], tableclassname[1]);
        }
        for (String[] objclassname : JFCBaseTablename.ObjectClassnames) {
            this.objclassMap.put(objclassname[0], objclassname[1]);
        }
        this.dbtype = "hsqldb";
    }

    public String getQuoteId() {
        return this.quote_id;
    }

    public void setQuoteId(String quote_id) {
        this.quote_id = quote_id;
    }

    public String getQuoteWhere() {
        return this.quote_where;
    }

    public void setQuoteWhere(String quote_where) {
        this.quote_where = quote_where;
    }

    public String getQuoteIdInWhere() {
        return this.quote_id_in_where;
    }

    public void setQuoteIdInWhere(String quote_id_in_where) {
        this.quote_id_in_where = quote_id_in_where;
    }

    public boolean getJdbc2() {
        return this.jdbc2;
    }

    public void setJdbc2(boolean jdbc2) {
        this.usejdbc2 = true;
        this.jdbc2 = jdbc2;
    }

    private boolean getAutoJdbc2() {
        return this.autojdbc2;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getTableclassname(String tablename) {
        return (String)this.tableclassMap.get(tablename);
    }

    public String getObjectclassname(String tablename) {
        return (String)this.objclassMap.get(tablename);
    }

    public String getSequenceDML() {
        return this.sequenceDML;
    }

    public void setSequenceDML(String dml) {
        this.sequenceDML = dml;
    }

    public Object createTableObject(Class srcclass, Connection con, String tablename) {
        Object obj = this.createTableObject(con, tablename);
        if (obj != null) {
            return obj;
        }
        try {
            Class[] classa = new Class[]{Connection.class, String.class};
            Constructor constructor = srcclass.getConstructor(classa);
            Object[] arg = new Object[]{con, tablename};
            obj = constructor.newInstance(arg);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00068), LogCodeManager.getMessage(LogCode.JFC00068, "table object"));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        this.configTableObject(obj);
        return obj;
    }

    public Object createTableObject(Connection con, String tablename) {
        Object obj;
        String classname = this.getTableclassname(tablename);
        if (classname == null) {
            logger.debug("No table is found, " + tablename + ".");
            return null;
        }
        try {
            Class<?> createclass = Class.forName(classname);
            Class[] classa = new Class[]{Connection.class, String.class};
            Constructor<?> constructor = createclass.getConstructor(classa);
            Object[] arg = new Object[]{con, tablename};
            obj = constructor.newInstance(arg);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00068), LogCodeManager.getMessage(LogCode.JFC00068, "table object"));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        this.configTableObject(obj);
        return obj;
    }

    public void configTableObject(Object obj) {
        if (this.getQuoteId() != null) {
            this.callStringSetterMethod(obj, "setQuoteId", this.getQuoteId());
        }
        if (this.getQuoteWhere() != null) {
            this.callStringSetterMethod(obj, "setQuoteWhere", this.getQuoteWhere());
        }
        if (this.getQuoteIdInWhere() != null) {
            this.callStringSetterMethod(obj, "setQuoteIdInWhere", this.getQuoteIdInWhere());
        }
        if (this.usejdbc2) {
            boolean b = this.getAutoJdbc2() ? TableConfigManager.analyzeJdbc2(obj) : this.getJdbc2();
            this.callBooleanSetterMethod(obj, "setJdbc2", b);
        }
    }

    private void callStringSetterMethod(Object obj, String methodname, String value) {
        block2: {
            Class[] parameterTypes = new Class[]{"".getClass()};
            Class<?> objclass = obj.getClass();
            try {
                Method setmethod = objclass.getMethod(methodname, parameterTypes);
                setmethod.invoke(obj, value);
            }
            catch (Exception e) {
                logger.debug("Failed to call setter string type method " + methodname + " in class " + objclass.getName() + ".", (Throwable)e);
                if (!logger.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    private void callBooleanSetterMethod(Object obj, String methodname, boolean value) {
        block2: {
            Class[] parameterTypes = new Class[]{Boolean.TYPE};
            Class<?> objclass = obj.getClass();
            try {
                Method setmethod = objclass.getMethod(methodname, parameterTypes);
                setmethod.invoke(obj, value);
            }
            catch (Exception e) {
                logger.debug("Failed to call setter boolean type method " + methodname + " in class " + objclass.getName() + ".", (Throwable)e);
                if (!logger.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    public static boolean analyzeJdbc2(Object obj) {
        Connection con;
        Class[] parameterTypes = new Class[]{};
        String methodname = "getConnection";
        Class<?> objclass = obj.getClass();
        try {
            Method setmethod = objclass.getMethod(methodname, parameterTypes);
            Object retobj = setmethod.invoke(obj, new Object[0]);
            if (retobj == null) {
                logger.debug("The method " + methodname + " returns null object. class is " + objclass.getName() + ".");
                return false;
            }
            if (!(retobj instanceof Connection)) {
                logger.debug("Type mismatch, the object " + methodname + " is not the Connection. class is " + objclass.getName() + ".");
                logger.debug("Return object is " + retobj.getClass().getName() + ".");
                return false;
            }
            con = (Connection)retobj;
        }
        catch (Exception e) {
            logger.debug("Failed to call method " + methodname + " in class " + objclass.getName(), (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
        return TableConfigManager.analyzeJdbc2(con);
    }

    public static boolean analyzeJdbc2(Connection con) {
        block3: {
            try {
                DatabaseMetaData metadata = con.getMetaData();
                if (metadata == null) {
                    logger.debug("DatabaseMetaData is null.");
                    return false;
                }
            }
            catch (SQLException e) {
                logger.debug("catch exception", (Throwable)e);
                if (!logger.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return true;
    }
}

