/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.textsearch.Indexer;
import jp.jasminesoft.jfc.textsearch.IndexerException;
import jp.jasminesoft.jfc.textsearch.IndexerUser;
import jp.jasminesoft.jfc.textsearch.IndexerUtil;
import jp.jasminesoft.jfc.textsearch.app.DummyResultListWrapper;
import jp.jasminesoft.jfc.textsearch.servlet.TextsearchUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public abstract class TextSearchableProcessBean
extends DbProcessBean {
    protected int resultMaxSize = 1000;
    private static final Logger logger = LogManager.getLogger(TextSearchableProcessBean.class);

    public TextSearchableProcessBean() {
    }

    public TextSearchableProcessBean(ActionParameter p) {
        super(p);
    }

    public abstract String[] getIndexTargetItems();

    public abstract String[] getTextsearchTitle();

    public abstract Indexer getIndexer();

    public abstract String getIndexModelId();

    public String getAppMapKeyHeaderName() {
        return TextsearchUtil.getHttpSessionKey4TextSearch(this.getIndexModelId(), this.p);
    }

    public int getResultMaxSize() {
        return this.resultMaxSize;
    }

    public void setResultMaxSize(int resultMaxSize) {
        this.resultMaxSize = resultMaxSize;
    }

    boolean isSuggest() {
        boolean isSuggest = false;
        Object o = this.getParameter("PBEAN_SUGGEST");
        if (o != null && o instanceof Boolean) {
            isSuggest = (Boolean)o;
        }
        return isSuggest;
    }

    protected void replaceSortKeyForIndex(Map paramMap) {
        String[] sort_key;
        if (paramMap.get("sort_key") == null) {
            return;
        }
        ArrayList<String> sk4idx = new ArrayList<String>();
        for (String s : sort_key = (String[])paramMap.get("sort_key")) {
            if (this.isPrimaryKey(s)) {
                sk4idx.add(s);
                continue;
            }
            for (String ii : this.getIndexTargetItems()) {
                if (!this.isMatchSortKey(s, ii)) continue;
                sk4idx.add(s);
            }
        }
        paramMap.put("sort_key", sk4idx.toArray(new String[0]));
    }

    protected void resetTextsearchResult() {
        if (this.p.request != null) {
            this.p.request.removeAttribute(this.getAppMapKeyHeaderName());
        }
        if (this.p.appMap != null) {
            this.p.appMap.remove(this.getAppMapKeyHeaderName());
        }
    }

    protected Map removeIndexTargetParameter(Map paramMap) {
        HashSet<String> targetItems = new HashSet<String>(Arrays.asList(this.getIndexTargetItems()));
        TreeMap ret = new TreeMap();
        for (Map.Entry o : paramMap.entrySet()) {
            Map.Entry entry = o;
            if (targetItems.contains((String)entry.getKey())) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    protected void prepareNoTextsearch() {
        if (this.p.request != null) {
            this.p.request.setAttribute("TEXTSEARCH_NO_TEXTSEARCH", (Object)"TEXTSEARCH_NO_TEXTSEARCH");
        }
    }

    public boolean checkUseIndex(Map paramMap) {
        boolean ret = false;
        if (this.p.request != null) {
            for (String s : new String[]{"TEXTSEARCH_NO_TEXTSEARCH", "TEXTSEARCH_QMODE"}) {
                logger.debug(s + "(attr):" + this.p.request.getAttribute(s));
            }
            for (String s : new String[]{"TEXTSEARCH_QMODE"}) {
                logger.debug(s + "(param):" + this.p.request.getParameter(s));
            }
            for (String s : new String[]{"TEXTSEARCH_QMODE"}) {
                logger.debug(s + "(appMap):" + this.p.appMap.get(s));
            }
            if (this.p.request.getAttribute("TEXTSEARCH_NO_TEXTSEARCH") != null) {
                ret = false;
            } else if (this.p.request.getParameter("TEXTSEARCH_QMODE") != null) {
                if ("index".equals(this.p.request.getParameter("TEXTSEARCH_QMODE"))) {
                    this.prepareNoTextsearch();
                    ret = true;
                } else {
                    ret = false;
                }
            } else if (this.p.request.getAttribute("TEXTSEARCH_QMODE") != null) {
                if ("index".equals(this.p.request.getAttribute("TEXTSEARCH_QMODE"))) {
                    this.prepareNoTextsearch();
                    ret = true;
                } else {
                    ret = false;
                }
            } else if (this.p.appMap.containsKey("TEXTSEARCH_QMODE")) {
                if ("index".equals(this.p.appMap.get("TEXTSEARCH_QMODE"))) {
                    this.prepareNoTextsearch();
                    ret = true;
                } else {
                    ret = false;
                }
            }
        }
        return ret;
    }

    public Object queryViaIndex(Map paramMap) {
        logger.debug("using index");
        Indexer idxer = null;
        String[] sort_key = (String[])paramMap.get("sort_key");
        if (sort_key == null || sort_key.length == 0) {
            sort_key = new String[]{"__jfc_uniqueKey"};
        }
        Map[] results = new Map[]{};
        String[] hilightwords = new String[]{};
        Integer resultSize = 0;
        try {
            idxer = this.getIndexer();
            if (idxer == null) {
                String string = "no index dir";
                return string;
            }
            logger.debug("isSuggest:" + this.isSuggest());
            if (!this.isSuggest()) {
                hilightwords = this.getHighlightWords(paramMap);
                if (hilightwords != null && hilightwords.length > 0) {
                    results = this.queryViaIndex4Page(paramMap, idxer, sort_key);
                }
            } else {
                results = this.queryViaIndex4Suggest(paramMap, idxer, sort_key);
            }
            resultSize = idxer.getResultSize();
            logger.debug("textsearch found:" + resultSize + " results");
            logger.debug("textsearch return:" + (results == null ? 0 : results.length) + " results");
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00223), LogCodeManager.getMessage(LogCode.JFC00223, this.p.user, String.valueOf(this.isSuggest()), e.getMessage()));
            logger.debug((Object)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("TEXTSEARCH_RESULT", results);
            rmap.put("TEXTSEARCH_RESULT_SIZE", resultSize);
            rmap.put("TEXTSEARCH_HIGHLIGHT_WORDS", hilightwords);
            rmap.put("TEXTSEARCH_TITLE_ITEMS", this.getTextsearchTitle());
            this.p.appMap.put(this.getAppMapKeyHeaderName(), rmap);
        }
        return new DummyResultListWrapper();
    }

    protected String[] getHighlightWords(Map paramMap) {
        String value = null;
        if (paramMap != null && paramMap.containsKey("textsearchjshparam") && paramMap.get("textsearchjshparam") instanceof String) {
            value = (String)paramMap.get("textsearchjshparam");
        }
        if (value == null) {
            value = "";
        }
        if (!IndexerUtil.isEnableSplitToken(value)) {
            value = "";
        }
        return IndexerUtil.getHighlightWords(value);
    }

    Map[] queryViaIndex4Page(Map paramMap, Indexer idxer, String[] sort_key) throws IndexerException {
        String value = null;
        if (paramMap.containsKey("textsearchjshparam") && paramMap.get("textsearchjshparam") instanceof String) {
            value = (String)paramMap.get("textsearchjshparam");
        }
        if (value == null) {
            value = "";
        }
        Map[] results = null;
        Query qObj = null;
        qObj = this.getQuery4Index(idxer, IndexerUtil.getQueryString4CrossBR5273(IndexerUtil.escapeLuceneSpecialChar(value), this.getIndexTargetItems()));
        if (qObj != null) {
            logger.debug("qObj:" + qObj);
            results = idxer.queryReturnMap(sort_key, qObj, this.getIndexerUsers(this.p.user));
            logger.debug("indexer return:" + (results == null ? 0 : results.length) + " results");
        }
        return results;
    }

    Map[] queryViaIndex4Suggest(Map paramMap, Indexer idxer, String[] sort_key) throws IndexerException {
        logger.debug("suggest method:" + TextsearchUtil.getSuggestMode(this.p.request));
        boolean isPrefixMatch = "prefix".equals(TextsearchUtil.getSuggestMode(this.p.request));
        Map[] results = isPrefixMatch ? idxer.queryReturnMap(sort_key, IndexerUtil.getWildcardQuery(paramMap, this.getIndexTargetItems()), this.getIndexerUsers(this.p.user)) : idxer.queryReturnMap("", sort_key, IndexerUtil.getQueryString(paramMap, this.getIndexTargetItems(), isPrefixMatch), this.getIndexerUsers(this.p.user));
        if (IndexerUtil.isPerfectMatchQuery(paramMap, this.getIndexTargetItems())) {
            results = IndexerUtil.findPerfectMatch(paramMap, this.getIndexTargetItems(), results);
        }
        return results;
    }

    protected Query getQuery4Index(Indexer idxer, String value) {
        Query qObj = null;
        if (StringUtils.isBlank((CharSequence)value)) {
            this.p.errors.addJfcwarn(((JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class)).getJfcwarn("warn.textsearch.query.blank", this.p.locale));
        } else {
            qObj = this.getQuery4IndexInternal(idxer, value);
        }
        return qObj;
    }

    protected Query getQuery4IndexInternal(Indexer idxer, String value) {
        Query qObj = null;
        String defaultField = "";
        try {
            qObj = idxer.getQuery(defaultField, value);
        }
        catch (ParseException pe) {
            if (pe.getCause() instanceof BooleanQuery.TooManyClauses) {
                this.p.errors.addJfcwarn(((JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class)).getJfcwarn("warn.textsearch.query.toomanyclause", this.p.locale));
            } else {
                this.p.errors.addJfcwarn(((JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class)).getJfcwarn("warn.textsearch.query.parseerror", this.p.locale));
            }
            logger.warn(JFCUtils.logmsg(this.p, pe.getMessage()), (Throwable)pe);
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            this.p.errors.addJfcwarn(((JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class)).getJfcwarn("warn.textsearch.query.toomanyclause", this.p.locale));
            logger.warn(JFCUtils.logmsg(this.p, tmc.getMessage()), (Throwable)tmc);
        }
        return qObj;
    }

    public abstract List<IndexerUser> getIndexerUsers(User var1);

    public Object queryViaIndexNoCrossSearch(Map paramMap) {
        logger.debug("using index");
        Indexer idxer = null;
        String[] sort_key = (String[])paramMap.get("sort_key");
        try {
            idxer = this.getIndexer();
            if (idxer == null) {
                return "no index dir";
            }
            Map[] results = null;
            logger.debug("isSuggest:" + this.isSuggest());
            results = idxer.queryReturnMap("", sort_key, IndexerUtil.getQueryString(paramMap, this.getIndexTargetItems(), this.isSuggest()));
            logger.debug("indexer found:" + idxer.getResultSize() + " results");
            logger.debug("indexer return:" + (results == null ? 0 : results.length) + " results");
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("TEXTSEARCH_RESULT", results);
            rmap.put("TEXTSEARCH_RESULT_SIZE", idxer.getResultSize());
            this.p.appMap.put(this.getAppMapKeyHeaderName(), rmap);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00224), LogCodeManager.getMessage(LogCode.JFC00224, this.p.user, e.getMessage()));
            throw new IllegalStateException(e.getMessage(), e);
        }
        return new DummyResultListWrapper();
    }

    protected boolean isAccessible2TextsearchItem(String permName, String permAction) {
        CheckPermission checkp = CheckPermissionFactory.getCheckPermission();
        if (checkp == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)permName)) {
            permName = null;
        }
        if (StringUtils.isBlank((CharSequence)permAction)) {
            permAction = null;
        }
        boolean result = checkp.process(this.p.user, new JFCAppPermission(permName, permAction));
        logger.debug(String.format("permName:%s permAction:%s result:%b", permName, permAction, result));
        return result;
    }
}

