/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AvatarImageManager {
    private static final Logger logger = LogManager.getLogger(AvatarImageManager.class);
    @Value(value="${wagby.AvatarImageManager.defaultFilename:/img/defaultAvatar.png}")
    private String defaultFilename = "/img/defaultAvatar.png";
    @Value(value="${wagby.AvatarImageManager.noResize:false}")
    private boolean noResize = false;
    @Value(value="${wagby.AvatarImageManager.noCache:false}")
    private boolean noCache = false;
    @Value(value="${wagby.AvatarImageManager.disableRemoveCache:false}")
    private boolean disableRemoveCache = false;
    @Value(value="${wagby.AvatarImageManager.removeAllCache:false}")
    private boolean removeAllCache = false;
    @Value(value="${wagby.AvatarImageManager.cachefileExt:.AvatarImageCache.png}")
    private String cachefileExt = ".AvatarImageCache.png";
    @Value(value="${wagby.AvatarImageManager.imageWidth:25}")
    private int imageWidth = 25;
    @Value(value="${wagby.AvatarImageManager.imageHeight:25}")
    private int imageHeight = 25;
    @Value(value="${wagby.AvatarImageManager.imageType:png}")
    private String imageType = "png";

    public byte[] getDefaultAvatarImage(HttpServletRequest request) throws IOException {
        InputStream istream = request.getServletContext().getResourceAsStream(this.defaultFilename);
        byte[] img = IOUtils.toByteArray((InputStream)istream);
        return img;
    }

    public byte[] loadImage(File file) throws IOException {
        byte[] s = this.noResize ? this.loadImageNoResize(file) : this.loadImageResize(file);
        return s;
    }

    public byte[] loadImageNoResize(File file) throws IOException {
        byte[] img = FileUtils.readFileToByteArray((File)file);
        return img;
    }

    public byte[] loadImageResize(File file) throws IOException {
        File cacheFile = null;
        if (!this.noCache) {
            String cachefilename = file.getName() + this.cachefileExt;
            cacheFile = new File(file.getParentFile(), cachefilename);
            if (cacheFile.canRead()) {
                byte[] img = FileUtils.readFileToByteArray((File)cacheFile);
                return img;
            }
        }
        byte[] img = FileUtils.readFileToByteArray((File)file);
        ByteArrayInputStream is = new ByteArrayInputStream(img);
        BufferedImage src = ImageIO.read(is);
        is = null;
        int width = src.getWidth();
        int height = src.getHeight();
        if (width == this.imageWidth && height == this.imageHeight) {
            return img;
        }
        img = null;
        int new_height = this.imageWidth;
        int new_width = this.imageHeight;
        AffineTransformOp xform = new AffineTransformOp(AffineTransform.getScaleInstance((double)new_width / (double)width, (double)new_height / (double)height), 2);
        BufferedImage dst = new BufferedImage(new_width, new_height, src.getType());
        xform.filter(src, dst);
        src = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)dst, this.imageType, baos);
        dst = null;
        img = baos.toByteArray();
        baos = null;
        if (!this.noCache) {
            logger.debug("write cachefile " + cacheFile);
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])img);
            if (!this.disableRemoveCache) {
                logger.debug("remove cachefile in " + file.getParentFile());
                this.removeAvatarImageCache(file.getParentFile());
            }
        }
        return img;
    }

    private void removeAvatarImageCache(File cachedir) {
        File[] removefiles;
        for (File removefile : removefiles = cachedir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parentfile, String name) {
                if (!name.endsWith(AvatarImageManager.this.cachefileExt)) {
                    return false;
                }
                if (AvatarImageManager.this.removeAllCache) {
                    return true;
                }
                String filename = name.substring(0, name.length() - AvatarImageManager.this.cachefileExt.length());
                return !new File(parentfile, filename).exists();
            }
        })) {
            logger.debug("remove cachefile " + removefile);
            removefile.delete();
        }
    }
}

