/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.util.List;
import jp.jasminesoft.jfc.app.CacheManagerBase;
import jp.jasminesoft.jfc.app.CacheManagerBaseMethod;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheManagerBaseMethodImpl_ehcache
implements CacheManagerBaseMethod {
    private static final Logger logger = LogManager.getLogger((String)CacheManagerBaseMethodImpl_ehcache.class.getName());
    public static final String UPDATE_CHOICE_OBJ_CACHEKEY = "__jfc_updateChoiceObjCache";

    public void printCache(Cache cache) {
        if (cache == null) {
            logger.debug("cache is null");
            return;
        }
        logger.debug("Name " + cache.getName());
        logger.debug("Guid " + cache.getGuid());
        logger.debug("Status " + cache.getStatus());
        if (cache.getStatus() == Status.STATUS_ALIVE) {
            logger.debug("Size " + cache.getSize());
            logger.debug("DiskStoreSize " + cache.getDiskStoreSize());
            logger.debug("MemoryStoreSize " + cache.getMemoryStoreSize());
            logger.debug("Statistics " + cache.getStatistics());
        }
        CacheConfiguration config = cache.getCacheConfiguration();
        this.printCacheConfiguration(config);
    }

    public void printCacheConfiguration(CacheConfiguration config) {
        if (config == null) {
            logger.debug("cache configuration is null");
            return;
        }
        logger.debug("cache configuration " + config.toString());
        logger.debug("C Name " + config.getName());
        logger.debug("C DiskExpiryThreadIntervalSeconds " + config.getDiskExpiryThreadIntervalSeconds());
        logger.debug("C DiskPersistent " + config.isDiskPersistent());
        logger.debug("C DiskSpoolBufferSizeMB " + config.getDiskSpoolBufferSizeMB());
        logger.debug("C Eternal " + config.isEternal());
        logger.debug("C MaxElementsInMemory " + config.getMaxElementsInMemory());
        logger.debug("C MaxElementsOnDisk " + config.getMaxElementsOnDisk());
        logger.debug("C OverflowToDisk " + config.isOverflowToDisk());
        logger.debug("C TimeToIdleSeconds " + config.getTimeToIdleSeconds());
        logger.debug("C TimeToLiveSeconds " + config.getTimeToLiveSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCacheThrowRuntimeException(String cachekey) {
        CacheManager ehcman = CacheManager.getInstance();
        Cache cache = ehcman.getCache(cachekey);
        if (cache == null) {
            CacheManager cacheManager = ehcman;
            synchronized (cacheManager) {
                cache = ehcman.getCache(cachekey);
                if (cache == null) {
                    logger.debug("use defaultCache, key " + cachekey);
                    ehcman.addCache(cachekey);
                    cache = ehcman.getCache(cachekey);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            this.printCache(cache);
        }
        return cache;
    }

    private Cache getCache(String cachekey) {
        try {
            return this.getCacheThrowRuntimeException(cachekey);
        }
        catch (CacheException e) {
            logger.warn("catch exception", (Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.warn("catch exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public <T> T get(String key, Class<T> clazz, String cachekey) {
        T src = this.getElementValue(key, clazz, cachekey);
        if (src == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("miss:key=" + key + " ,cachekey=" + cachekey);
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("hit :key=" + key + " ,cachekey=" + cachekey);
        }
        return CacheManagerBaseMethodImpl_ehcache.newInstance(clazz, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getElementValue(String key, Class<T> clazz, String cachekey) {
        Serializable ret;
        block6: {
            ret = null;
            try {
                Cache cache = this.getCache(cachekey);
                if (cache == null) break block6;
                Cache cache2 = cache;
                synchronized (cache2) {
                    Element element = cache.get((Serializable)((Object)key));
                    ret = element != null ? element.getValue() : null;
                }
            }
            catch (CacheException e) {
                logger.warn("catch exception", (Throwable)e);
            }
            catch (IllegalStateException e) {
                logger.warn("catch exception", (Throwable)e);
            }
        }
        return (T)ret;
    }

    @Override
    public <T> void put(T src, Class<T> clazz, String cachekey, String pkey) {
        this.putElementValue(CacheManagerBaseMethodImpl_ehcache.newInstance(clazz, src), clazz, cachekey, pkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putElementValue(T src, Class<T> clazz, String cachekey, String pkey) {
        block5: {
            try {
                Cache cache = this.getCache(cachekey);
                if (cache == null) break block5;
                Cache cache2 = cache;
                synchronized (cache2) {
                    cache.put(new Element((Object)pkey, src));
                }
            }
            catch (CacheException e) {
                logger.warn("catch exception", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key, String cachekey) {
        block5: {
            try {
                Cache cache = this.getCacheThrowRuntimeException(cachekey);
                if (cache == null) break block5;
                Cache cache2 = cache;
                synchronized (cache2) {
                    cache.remove((Serializable)((Object)key));
                }
            }
            catch (CacheException e) {
                logger.warn("catch exception", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String cachekey) {
        block5: {
            try {
                Cache cache = this.getCacheThrowRuntimeException(cachekey);
                if (cache == null) break block5;
                Cache cache2 = cache;
                synchronized (cache2) {
                    cache.removeAll();
                }
            }
            catch (CacheException e) {
                logger.warn("catch exception", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    static <T> T newInstance(Class<T> clazz, T src) {
        return CacheManagerBase.newInstance(clazz, src);
    }

    @Override
    public void putUpdateChoiceObj(String key, List<?> list, String classname) {
        this.putElementValue(new CacheManagerBase.UpdateChoiceObj(classname, list), CacheManagerBase.UpdateChoiceObj.class, UPDATE_CHOICE_OBJ_CACHEKEY, key);
    }

    @Override
    public List<?> getUpdateChoiceObj(String key) {
        CacheManagerBase.UpdateChoiceObj co = this.getElementValue(key, CacheManagerBase.UpdateChoiceObj.class, UPDATE_CHOICE_OBJ_CACHEKEY);
        if (co != null) {
            return co.list;
        }
        return null;
    }

    @Override
    public void removeUpdateChoiceObj(String key) {
        this.remove(key, UPDATE_CHOICE_OBJ_CACHEKEY);
    }

    @Override
    public void clearAllUpdateChoiceObj() {
        this.clear(UPDATE_CHOICE_OBJ_CACHEKEY);
    }
}

