/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.ChangelogType;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class Changelog {
    private ChangelogType type_;
    private String locale_str_;
    private String id_;
    private String item_;
    private String jitem_;
    private String originalValue_;
    private String updatedValue_;

    public Changelog(ChangelogType type, String locale_str, String id, String item) {
        this(type, locale_str, id, item, null, null);
    }

    public Changelog(ChangelogType type, String locale_str, String id, String item, String updatedValue) {
        this(type, locale_str, id, item, null, updatedValue);
    }

    public Changelog(ChangelogType type, String locale_str, String id, String item, String originalValue, String updatedValue) {
        this.type_ = type;
        this.locale_str_ = locale_str;
        this.id_ = id;
        this.item_ = item;
        this.originalValue_ = originalValue;
        this.updatedValue_ = updatedValue;
    }

    public ChangelogType getType() {
        return this.type_;
    }

    public String getId() {
        return this.id_;
    }

    public void setItem(String item) {
        this.item_ = item;
    }

    public String getItem() {
        return this.item_;
    }

    public String getItem_i18n() {
        if (this.jitem_ == null) {
            int ptr = this.item_.indexOf("[");
            if (ptr > 0) {
                String p1 = this.item_.substring(0, ptr);
                int ptr2 = this.item_.indexOf("].");
                String p2 = this.item_.substring(ptr2 + 2);
                String tp = p1 + "." + p2;
                this.jitem_ = JFCUtils.getRValue(this.id_ + "." + tp, this.locale_str_);
                this.jitem_ = this.jitem_ + "[" + this.item_.substring(ptr + 1, ptr2) + "]";
            } else {
                this.jitem_ = JFCUtils.getRValue(this.id_ + "." + this.item_, this.locale_str_);
            }
        }
        return this.jitem_;
    }

    public String getOriginalValue() {
        return this.originalValue_;
    }

    public String getUpdatedValue() {
        return this.updatedValue_;
    }

    public String getLocaleStr() {
        return this.locale_str_;
    }

    public boolean isValid() {
        return !(StringUtils.isBlank((CharSequence)this.originalValue_) & StringUtils.isBlank((CharSequence)this.updatedValue_));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type_);
        sb.append("|");
        sb.append(this.id_);
        sb.append(".");
        sb.append(this.item_);
        sb.append("|");
        if (StringUtils.isNotEmpty((CharSequence)this.jitem_)) {
            sb.append(this.jitem_);
            sb.append("|");
        }
        if (this.originalValue_ != null) {
            sb.append("'");
            sb.append(StringUtil.removeCRLF((String)this.originalValue_));
            sb.append("'");
            sb.append(" to ");
        }
        if (this.updatedValue_ != null) {
            sb.append("'");
            sb.append(StringUtil.removeCRLF((String)this.updatedValue_));
            sb.append("'");
        }
        return sb.toString();
    }
}

