/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.Changelog;
import jp.jasminesoft.jfc.app.ChangelogFormatter;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.core.util.PresentationModelUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangelogService<E extends ContainerBase<E>, PK extends Serializable, D> {
    private static final Logger logger = LogManager.getLogger(ChangelogService.class);
    protected String modelId;
    protected EntityHelper<E, PK> entityHelper;
    protected JFCEntityService<E, PK> entityService;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setEntityHelper(EntityHelper<E, PK> entityHelper) {
        this.entityHelper = entityHelper;
    }

    public void setEntityService(JFCEntityService<E, PK> entityService) {
        this.entityService = entityService;
    }

    public int changelog(E entity, String status, ActionParameter p) {
        PresentationPHelper pHelper = PresentationModelUtils.presentationHelper(this.modelId, p);
        Object previous = null;
        E pre = this.entityService.newTransactionEntityService().findById(this.entityHelper.getPrimarykey(entity));
        previous = pHelper.s2p(pre, p, 1);
        Object current = pHelper.s2p(entity, p, 1);
        Changelog[] changelogs = pHelper.diff(this.modelId, previous, current, (String[][])ReflectionUtils.getPrivateField(this.entityHelper, "itemNameArrayInRelaxerObject_"), p.locale);
        return this.changelog(this.entityHelper.getPrimarykeyAsString(entity, p), changelogs, status, p);
    }

    protected int changelog(String pkeyAsString, Changelog[] changelogs, String status, ActionParameter p) {
        if (changelogs == null || changelogs.length == 0) {
            return 0;
        }
        int count = 0;
        ChangelogFormatter fmt = ChangelogFormatter.getInstance();
        for (Changelog changelog : changelogs) {
            if (!changelog.isValid()) continue;
            StringBuilder msg = new StringBuilder();
            msg.append(pkeyAsString);
            msg.append("|");
            msg.append(fmt.format(changelog));
            logger.info(JFCUtils.getLogHeader(p, status, msg.toString()));
            ++count;
        }
        p.request.setAttribute("__jfc_changelog_" + this.modelId + "_" + pkeyAsString, (Object)changelogs);
        p.request.setAttribute("__pkeyAsString", (Object)(this.modelId + "_" + pkeyAsString));
        return count;
    }
}

