/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DbDownloadBaseProcessBean<E extends ContainerBase<E>, PK extends Serializable>
extends DbProcessBean {
    public static final String ADD_PRIMARY_KEY_IN_DOWNLOAD_KEY = "__jfc_ADD_PRIMARYKEY_IN_DOWNLOAD";
    private static final Logger logger = LogManager.getLogger(DbDownloadBaseProcessBean.class);
    private boolean disableCsvDataHeader = false;

    public DbDownloadBaseProcessBean() {
    }

    public DbDownloadBaseProcessBean(ActionParameter p) {
        super(p);
    }

    public boolean isDisableCsvDataHeader() {
        return this.disableCsvDataHeader;
    }

    public void setDisableCsvDataHeader(boolean disableCsvDataHeader) {
        this.disableCsvDataHeader = disableCsvDataHeader;
    }

    protected abstract String getDefaultCsvEncoding();

    protected abstract EntityHelper<E, PK> getEntityHelper(ActionParameter var1);

    protected abstract String getModelId();

    protected ResourceBundle getResourceBundle() {
        String BundleBaseName = "DownloadProcessBean";
        ResourceBundle res = null;
        try {
            res = ResourceBundle.getBundle("DownloadProcessBean");
        }
        catch (MissingResourceException e) {
            String s = "nothing resource DownloadProcessBean";
            logger.debug(s, (Throwable)e);
        }
        return res;
    }

    public OutputStream createOutputStream(String outfilename, ActionParameter p) throws IOException {
        if (this.getParameter("output_local") != null) {
            p.request.setAttribute("outfilename", (Object)outfilename);
            File outputfile = (File)this.getParameter("outputfilename");
            return new FileOutputStream(outputfile);
        }
        p.response.setContentType("application/octet-stream");
        p.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
        p.response.setHeader("Pragma", "no-cache");
        p.response.setHeader("Expires", JFCUtils.getHTTPDate());
        p.response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)outfilename, (HttpServletRequest)p.request));
        return p.response.getOutputStream();
    }

    protected String getCsvEncoding(ResourceBundle res) {
        String enc = this._getCsvEncoding(res);
        if (enc == null || enc.length() == 0 || enc.equals("default")) {
            return ((JfcConfig)this.p.appctx.getBean(JfcConfig.class)).getCsvEncoding();
        }
        return enc;
    }

    protected String _getCsvEncoding(ResourceBundle res) {
        String DefaultCsvEncoding = this.getDefaultCsvEncoding();
        String enc = (String)this.getParameter("csv_encoding");
        if (enc != null && enc.length() > 0) {
            return enc;
        }
        if (res != null && (enc = this.getResourceKey(res, "csv_encoding")) != null) {
            return enc;
        }
        return DefaultCsvEncoding;
    }

    protected String getResourceKey(ResourceBundle res, String reskey_footer) {
        String[] reskeys;
        for (String reskey : reskeys = new String[]{this.getClass().getSimpleName() + reskey_footer, reskey_footer}) {
            try {
                String s = res.getString(reskey);
                if (s == null || s.length() <= 0) continue;
                return s;
            }
            catch (MissingResourceException e) {
                logger.debug("nothing resource key " + reskey, (Throwable)e);
            }
        }
        return null;
    }

    protected boolean isGetAllModelitem(ResourceBundle res) {
        if (res == null) {
            return false;
        }
        boolean use_getallmodelitem = false;
        String s = this.getResourceKey(res, "use_getallmodelitem");
        if (s != null) {
            use_getallmodelitem = Boolean.parseBoolean(s);
        }
        String sgetallmodelitem = (String)this.getParameter("getallmodelitem");
        boolean getallmodelitem = use_getallmodelitem && sgetallmodelitem != null;
        return getallmodelitem;
    }

    public ActionParameter createActionParameter() {
        ActionParameter runnablep = ActionParameter.createActionParameter(this.p.logger, this.getUsername(), this.p.appctx);
        runnablep.user = this.p.user;
        runnablep.request = JFCUtils.createEmptyHttpServletRequest(this.p);
        runnablep.appMap = new HashMap<String, Object>();
        runnablep.pageMap = new HashMap<String, Object>();
        runnablep.locale = this.p.locale;
        return runnablep;
    }

    protected Map<String, Object> createScriptParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ResourceBundle res = this.getResourceBundle();
        boolean getallmodelitem = this.isGetAllModelitem(res);
        params.put("getallmodelitem", getallmodelitem);
        params.put("outputmode", this.getOutputModeAsString(getallmodelitem));
        params.put("csv_encoding", this.getCsvEncoding(res));
        params.put("condition", this.getParameter("condition"));
        params.put("sort_key", this.getParameter("sort_key"));
        params.put("targetitems", this.getParameter("targetitems"));
        return params;
    }

    protected String processStart() {
        Map<String, Object> params = this.createScriptParam();
        return new ScriptCodeRunner(this.getModelId()).process("Download" + StringUtil.capFirst((String)this.getModelId()), "processStart", params, this.p);
    }

    protected void processEnd() {
        Map<String, Object> params = this.createScriptParam();
        String status = new ScriptCodeRunner(this.getModelId()).process("Download" + StringUtil.capFirst((String)this.getModelId()), "processEnd", params, this.p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            logger.warn(status);
        }
    }

    protected void processFailed() {
        Map<String, Object> params = this.createScriptParam();
        String status = new ScriptCodeRunner(this.getModelId()).process("Download" + StringUtil.capFirst((String)this.getModelId()), "processFailed", params, this.p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            logger.warn(status);
        }
    }

    public void updateProgress(ActionParameter p, IJfcjobstatus jobstatus, long cnt) {
        this.updateProgress(p, jobstatus, cnt, null);
    }

    public void updateProgress(ActionParameter p, IJfcjobstatus jobstatus, long cnt, E entity) {
        List pkeylist;
        if (entity != null && (pkeylist = (List)p.request.getAttribute(ADD_PRIMARY_KEY_IN_DOWNLOAD_KEY)) != null) {
            pkeylist.add(this.getEntityHelper(p).getPrimarykey(entity));
        }
        if (jobstatus == null) {
            return;
        }
        jobstatus.setProgress(cnt);
        JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)p.appctx.getBean(JfcjobstatusRegistryService.class);
        service.updateJfcjobstatusInterval(p, jobstatus);
    }

    protected String getOutputModeAsString(boolean getallmodelitem) {
        return "All";
    }

    public static interface ExecuteQueryResultsListener<E extends ContainerBase<E>> {
        public void execute(ActionParameter var1, E var2) throws Exception;
    }
}

