/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.HashMap;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.FilterManager;
import jp.jasminesoft.jfc.IPresentationHelper;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.service.JfcConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FilterHelper<T>
implements IPresentationHelper {
    private JfcConfig jfcConfig;

    @Autowired
    public void setJfcConfig(JfcConfig jfcConfig1) {
        this.jfcConfig = jfcConfig1;
    }

    public JfcConfig getJfcConfig() {
        return this.jfcConfig;
    }

    public void filter(T t, ActionParameter p) {
        this.filter(t, null, null, p);
    }

    public void filter(T t, FilterManager filterman0, ActionParameter p) {
        this.filter(t, filterman0, null, p);
    }

    public void filter(T t, Set<String> itemSet, ActionParameter p) {
        this.filter(t, null, itemSet, p);
    }

    public void filter(T t, FilterManager filterman0, Set<String> itemSet, ActionParameter p) {
        if (t == null) {
            return;
        }
        FilterManager filterman = null;
        filterman = filterman0 != null ? filterman0 : this.getDefaultFilterManager(p);
        this.filter0(t, filterman, itemSet);
        this.callScript(t, p);
    }

    public FilterManager getDefaultFilterManager(ActionParameter p) {
        return (FilterManager)p.appctx.getBean("filterManager");
    }

    protected abstract void filter0(T var1, FilterManager var2, Set<String> var3);

    public void callScript(T t, ActionParameter p) {
        String status;
        if (p == null) {
            return;
        }
        String pid = this.getPresentationId(t);
        String modelId = this.getModelId(pid);
        String screenType = this.getScreenType(p);
        if (screenType != null && screenType.equals("updateList")) {
            HashMap<String, T> params = new HashMap<String, T>();
            params.put(pid, t);
            status = new ScriptCodeRunner(modelId).process(this.getClass().getName(), "filter", params, p);
        } else {
            p.request.setAttribute(pid, t);
            status = new ScriptCodeRunner(modelId).process(this.getClass().getName(), "filter", p);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            Jfcerror jfcerror = new Jfcerror();
            jfcerror.setContent(status);
            p.errors.addJfcerror(jfcerror);
        }
    }

    private String getPresentationId(T t) {
        String efullclass = t.getClass().getName();
        String tmp = efullclass.substring(0, efullclass.lastIndexOf("."));
        return tmp.substring(tmp.lastIndexOf(".model.") + ".model.".length());
    }

    private String getModelId(String pid) {
        String[] pidfooter;
        for (String f : pidfooter = new String[]{"_cp", "_p", "_ulp"}) {
            if (!pid.endsWith(f)) continue;
            return pid.substring(0, pid.length() - f.length());
        }
        return pid;
    }

    private String getScreenType(ActionParameter p) {
        Object o = p.request.getAttribute("__jfc_screen_type");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }
}

