/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.IInputCheckHelper;
import jp.jasminesoft.jfc.error.Jfcerror;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InputCheckHelper<S, P>
implements IInputCheckHelper<S, P> {
    private static final Logger logger = LogManager.getLogger(InputCheckHelper.class);
    private static final Pattern ModelIdItemnameRKeyPat = Pattern.compile("([^.]+)\\.([^.]+)");

    @Override
    public abstract void input_check(S var1, P var2, ActionParameter var3, JFCErrorManager var4, Set var5);

    @Override
    public abstract void input_check(S var1, P var2, ActionParameter var3, JFCErrorManager var4, Set var5, String var6);

    public void callScript(S store, P presen, String modelId, String pmodelId, ActionParameter p) {
        this.callScript0(store, presen, modelId, pmodelId, "process", p);
    }

    public void callScript(S store, P presen, String modelId, String pmodelId, String functionName, ActionParameter p) {
        this.callScript0(store, presen, modelId, pmodelId, functionName, p);
    }

    public void callScript0(S store, P presen, String modelId, String pmodelId, String functionName, ActionParameter p) {
        String screenType = this.getScreenType(p);
        if (screenType != null && screenType.equals("updateList")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(modelId, store);
            params.put(pmodelId, presen);
            String status = new ScriptCodeRunner(modelId).process(this.getClass().getName(), "input_check", functionName, params, p);
            if (StringUtils.isNotBlank((CharSequence)status)) {
                Jfcerror jfcerror = new Jfcerror();
                jfcerror.setContent(status);
                p.errors.addJfcerror(jfcerror);
            }
        } else {
            Object _os = p.request.getAttribute(modelId);
            Object _op = p.request.getAttribute(pmodelId);
            p.request.setAttribute("__jsobj_" + modelId, store);
            p.request.setAttribute(pmodelId, presen);
            String status = new ScriptCodeRunner(modelId, pmodelId).process(this.getClass().getName(), "input_check", functionName, p);
            if (StringUtils.isNotBlank((CharSequence)status)) {
                Jfcerror jfcerror = new Jfcerror();
                jfcerror.setContent(status);
                p.errors.addJfcerror(jfcerror);
            }
            if (_os != null) {
                p.request.setAttribute(modelId, _os);
            }
            p.request.removeAttribute("__jsobj_" + modelId);
            if (_op != null) {
                p.request.setAttribute(pmodelId, _op);
            } else {
                p.request.removeAttribute(pmodelId);
            }
        }
    }

    private String getScreenType(ActionParameter p) {
        Object o = p.request.getAttribute("__jfc_screen_type");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getRValue(String rkey, ActionParameter p) {
        String value = this.getRValueUploadUpdate(rkey, p);
        if (value != null) {
            return value;
        }
        return JFCUtils.getRValue(rkey, p.locale);
    }

    public String getRValueUploadUpdate(String rkey, ActionParameter p) {
        String screentype = this.getScreenType(p);
        logger.debug("screentype " + screentype);
        logger.debug("rkey " + rkey);
        if (screentype == null || !screentype.equals("uploadUpdate")) {
            return null;
        }
        Matcher matcher = ModelIdItemnameRKeyPat.matcher(rkey);
        if (!matcher.matches()) {
            return null;
        }
        String modelid = matcher.group(1);
        String itemname = matcher.group(2);
        logger.debug("modelid " + modelid);
        logger.debug("itemname " + itemname);
        String csvheaderrkey = "__jfc_helper.csvHeader_errormsg." + rkey;
        String value = JFCUtils.getRValue(csvheaderrkey, p.locale);
        if (value != null && !value.equals("")) {
            logger.debug("1 value " + value);
            return value;
        }
        csvheaderrkey = "__jfc_helper.csvHeader." + rkey;
        value = JFCUtils.getRValue(csvheaderrkey, p.locale);
        if (value != null && !value.equals("")) {
            logger.debug("2 value " + value);
            return value;
        }
        logger.debug("3 value null");
        return null;
    }

    public String getRValue(String rkey, ActionParameter p, boolean isConvert) {
        return JFCUtils.getRValue(rkey, p.locale, isConvert);
    }

    public String getRValue(String rkey, String value1, ActionParameter p) {
        return JFCUtils.getRValue(rkey, value1, p.locale);
    }

    public String getRValue(String rkey, String value1, String value2, ActionParameter p) {
        return JFCUtils.getRValue(rkey, value1, value2, p.locale);
    }

    public String getRValue(String rkey, String value1, String value2, String value3, ActionParameter p) {
        return JFCUtils.getRValue(rkey, value1, value2, value3, p.locale);
    }

    public String getRValue(String rkey, Object[] args, ActionParameter p) {
        return JFCUtils.getRValue(rkey, args, p.locale);
    }
}

