/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.IPresentationHelper;
import jp.jasminesoft.jfc.JFCControlUtil;
import jp.jasminesoft.jfc.User;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PresentationHelper
implements IPresentationHelper {
    private static final Logger logger = LogManager.getLogger(PresentationHelper.class);
    private static Map<ComparatorPattern, Comparator> comparatorMap = new HashMap<ComparatorPattern, Comparator>();
    private HashMap<String, Method> methodCache = new HashMap();
    private HashMap<String, Method> method2Cache = new HashMap();

    protected static Comparator getComparator(ComparatorPattern pattern) {
        return comparatorMap.get((Object)pattern);
    }

    public JFCControlUtil.ControlType getControlType(User user, String modelitemname, ActionParameter p) {
        return this.getControlType(user, null, modelitemname, p);
    }

    private synchronized <S> Method getMethod(S obj, String modelitemname) throws SecurityException, NoSuchMethodException {
        Method method;
        if (this.methodCache.containsKey(modelitemname)) {
            Method method2 = this.methodCache.get(modelitemname);
            if (method2 == null) {
                throw new NoSuchMethodException();
            }
            return method2;
        }
        try {
            method = this.getClass().getMethod("getControlType_" + modelitemname, User.class, obj.getClass(), ActionParameter.class);
            this.methodCache.put(modelitemname, method);
        }
        catch (NoSuchMethodException e) {
            this.methodCache.put(modelitemname, null);
            throw e;
        }
        return method;
    }

    private synchronized Method getMethod2(String modelitemname) throws SecurityException, NoSuchMethodException {
        Method method;
        if (this.method2Cache.containsKey(modelitemname)) {
            Method method2 = this.method2Cache.get(modelitemname);
            if (method2 == null) {
                throw new NoSuchMethodException();
            }
            return method2;
        }
        try {
            method = this.getClass().getMethod("getControlType_" + modelitemname, User.class, ActionParameter.class);
            this.method2Cache.put(modelitemname, method);
        }
        catch (NoSuchMethodException e) {
            this.method2Cache.put(modelitemname, null);
            throw e;
        }
        return method;
    }

    public <S> JFCControlUtil.ControlType getControlType(User user, S obj, String modelitemname, ActionParameter p) {
        modelitemname = modelitemname.replace('/', '$');
        Method method = null;
        try {
            Object result = null;
            if (obj != null) {
                method = this.getMethod(obj, modelitemname);
                result = method.invoke((Object)this, user, obj, p);
            } else {
                method = this.getMethod2(modelitemname);
                result = method.invoke((Object)this, user, p);
            }
            if (result != null && result instanceof JFCControlUtil.ControlType) {
                return (JFCControlUtil.ControlType)((Object)result);
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return JFCControlUtil.ControlType.All;
    }

    public Map<String, JFCControlUtil.ControlType> getControlTypeMap(User user, ActionParameter p) {
        String[] mitems;
        HashMap<String, JFCControlUtil.ControlType> map = (HashMap<String, JFCControlUtil.ControlType>)p.request.getAttribute("__jfc_control_type_map");
        if (map != null) {
            return map;
        }
        map = new HashMap<String, JFCControlUtil.ControlType>();
        for (String mitem : mitems = this.getModelitemsArray()) {
            map.put(mitem, this.getControlType(user, mitem, p));
        }
        p.request.setAttribute("__jfc_control_type_map", map);
        return map;
    }

    public abstract String[] getModelitemsArray();

    public List<Map<String, Object>> getGridColumns(HttpServletRequest request, Map<String, Object> map) {
        return null;
    }

    static {
        ComparatorChain cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("priority"), true);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.PriorityDecendId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("category"));
        cc.addComparator((Comparator)new BeanComparator("priority"), true);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.CategoryPriorityDecendId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("category"));
        cc.addComparator((Comparator)new BeanComparator("priority"), false);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.CategoryPriorityId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("priority"), false);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.PriorityId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("content"), true);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.ContentDecendId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("content"), false);
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.ContentId, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("id"));
        comparatorMap.put(ComparatorPattern.Id, (Comparator)new NullComparator((Comparator)cc));
        cc = new ComparatorChain();
        cc.addComparator((Comparator)new BeanComparator("id"), true);
        comparatorMap.put(ComparatorPattern.IdDecend, (Comparator)new NullComparator((Comparator)cc));
    }

    public static enum ComparatorPattern {
        PriorityDecendId,
        PriorityId,
        ContentDecendId,
        ContentId,
        Id,
        IdDecend,
        CategoryPriorityDecendId,
        CategoryPriorityId;

    }
}

