/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class RESTAPIVersionManager {
    private static final String RequestHeader = "X-Wagby-RESTAPIVersion";
    private static final String RequestAttrName = "__jfc_RESTAPIVersion";
    @Autowired
    protected ApplicationContext applicationContext;
    private static final Logger logger = LogManager.getLogger(RESTAPIVersionManager.class);
    private Map<String, Version> versionModels = new HashMap<String, Version>();
    private Version defaultVersion = Version.defaultVersion();

    public void setVersionModels(Map<String, Set<String>> map) {
        this.versionModels = new HashMap<String, Version>();
        for (String key : map.keySet()) {
            Version ver = Version.valueOf(key);
            for (String model : map.get(key)) {
                this.versionModels.put(model, ver);
            }
        }
    }

    public Map<String, Set<String>> getVersionModels() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String model : this.versionModels.keySet()) {
            Version ver = this.versionModels.get(model);
            String key = ver.name();
            HashSet<String> set = (HashSet<String>)map.get(key);
            if (set == null) {
                set = new HashSet<String>();
                map.put(key, set);
            }
            set.add(model);
        }
        return map;
    }

    public void setDefaultVersion(String s) {
        this.defaultVersion = Version.valueOf(s);
    }

    public String getDefaultVersion() {
        return this.defaultVersion.name();
    }

    public Version getVersion() {
        ActionParameterContainer pcont = (ActionParameterContainer)this.applicationContext.getBean("ActionParameterContainer");
        ActionParameter p = pcont.get();
        if (p == null) {
            logger.debug("failed to get ActionParameter");
            return this.defaultVersion;
        }
        return this.getVersion(p.request);
    }

    public Version getVersion(HttpServletRequest request) {
        Version ver = this.getVersionForRequestAttribute(request);
        if (ver != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("http attr " + ver);
            }
            return ver;
        }
        ver = this.getVersionForRequestHeader(request);
        if (ver != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("http header " + ver);
            }
            this.setVersionForRequestAttribute(request, ver);
            return ver;
        }
        String modelname = this.getModelname(request);
        ver = this.getVersionForModelname(modelname);
        if (logger.isDebugEnabled()) {
            logger.debug("modelname " + ver);
        }
        this.setVersionForRequestAttribute(request, ver);
        return ver;
    }

    public Version getVersionForRequestAttribute(HttpServletRequest request) {
        return (Version)((Object)request.getAttribute(RequestAttrName));
    }

    protected void setVersionForRequestAttribute(HttpServletRequest request, Version ver) {
        request.setAttribute(RequestAttrName, (Object)ver);
    }

    public Version getVersionForModelname(String modelname) {
        logger.debug("1 modelname=" + modelname);
        if (modelname == null) {
            logger.debug("2 return defaultVersion " + this.defaultVersion);
            return this.defaultVersion;
        }
        Version ver = this.versionModels.get(modelname);
        if (ver == null) {
            logger.debug("4 return defaultVersion " + this.defaultVersion);
            return this.defaultVersion;
        }
        logger.debug("5 return version " + ver);
        return ver;
    }

    public Version getVersionForRequestHeader(HttpServletRequest request) {
        String key = request.getHeader(RequestHeader);
        if (key == null) {
            return null;
        }
        try {
            return Version.valueOf(key);
        }
        catch (IllegalArgumentException e) {
            logger.error("REST API X-Wagby-RESTAPIVersion http header value is ignored. use default setting. value:" + key);
            return null;
        }
    }

    public String getModelname(HttpServletRequest request) {
        String spath = request.getServletPath();
        if (logger.isDebugEnabled()) {
            logger.debug("spath=" + spath);
            String cpath = request.getContextPath();
            logger.debug("cpath=" + cpath);
            String ipath = request.getPathInfo();
            logger.debug("ipath=" + ipath);
        }
        String REST_HEADER = "/rest/";
        if (!spath.startsWith("/rest/")) {
            return null;
        }
        int cnt = spath.indexOf(47, "/rest/".length());
        if (cnt <= 0) {
            return null;
        }
        String modelname = spath.substring("/rest/".length(), cnt);
        return modelname;
    }

    public static enum Version {
        v1,
        v2;


        public static Version defaultVersion() {
            return v2;
        }
    }
}

