/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.app.ReportListService;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.repgen.JfcreporttemplateUtil;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ReportListServiceImpl<E extends ContainerBase<E>, C>
implements ReportListService<C> {
    public static final String OutputTypeAttributeName = ReportListServiceImpl.class.getName() + "_OutputType";
    public static final String ValueMapAttributeName = ReportListServiceImpl.class.getName() + "_ValueMap";
    private JFCEntityService<E, ?> service;
    private JFCErrorManager errorManager;
    private ConditionHelper<C> conditionHelper;

    public void setEntityService(JFCEntityService<E, ?> service) {
        this.service = service;
    }

    public JFCEntityService<E, ?> getEntityService() {
        return this.service;
    }

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    public void setConditionHelper(ConditionHelper<C> conditionHelper) {
        this.conditionHelper = conditionHelper;
    }

    public abstract C createCondition();

    protected DataBindingContext getDataBindingContext(ActionParameter p) {
        return null;
    }

    public List<E> find(FinderContext<?> finderContext, ActionParameter p) {
        finderContext.absorb(this.getDataBindingContext(p));
        return this.getEntityService().find(finderContext);
    }

    @Override
    public FinderContext<C> createFinderContext(ActionParameter p, String screentype, C cond) {
        FinderContext<C> finderContext = new FinderContext<C>();
        CriteriaConverter<C> criteriaConverter = this.getCriteriaConverter(p, screentype);
        finderContext.setCriteriaConverter(criteriaConverter);
        if (cond == null) {
            cond = this.createCondition();
            this.conditionHelper.initialize(cond, p);
        }
        finderContext.setCondition(cond);
        return finderContext;
    }

    @Override
    public FinderContext<C> createFinderContext(ActionParameter p, String screentype) {
        return this.createFinderContext(p, screentype, null);
    }

    protected CriteriaConverter<C> getCriteriaConverter(ActionParameter p, String screentype) {
        String criteriaConverterBeanId = this.getCriteriaConverterBeanId(screentype);
        CriteriaConverter criteriaConverter = (CriteriaConverter)p.appctx.getBean(criteriaConverterBeanId, CriteriaConverter.class);
        return criteriaConverter;
    }

    protected String getCriteriaConverterBeanId(String screentype) {
        String StatusShowListHeader = "showList";
        String criteriaConverterBeanId = screentype.startsWith("showList") ? StringUtil.capFirst((String)this.getModelId()) + "CriteriaConverter" : StringUtil.capFirst((String)screentype) + StringUtil.capFirst((String)this.getModelId()) + "CriteriaConverter";
        return criteriaConverterBeanId;
    }

    public void remakeParameterMap(Map _map, Map _typemap, ActionParameter p) {
        p.request.setAttribute("REPLACEMAP", (Object)_map);
        p.request.setAttribute("REPLACETYPEMAP", (Object)_typemap);
        String status = new ScriptCodeRunner(this.getModelId()).process("ReplaceMapHelper", "remake", p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            throw new BusinessLogicException(status);
        }
    }

    protected static Map convertParameterMapKeyName(Map _map) {
        if (_map == null) {
            return null;
        }
        HashMap convertedMap = new HashMap();
        Iterator iterator = _map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            String convertedKey = key;
            String prefix = "${";
            String suffix = "}";
            if (key != null && key.startsWith(prefix) && key.endsWith(suffix)) {
                convertedKey = key.substring(prefix.length());
                convertedKey = convertedKey.substring(0, convertedKey.length() - suffix.length());
            }
            if (value != null && value instanceof String && ((String)value).length() == 0) {
                value = null;
            }
            convertedMap.put(convertedKey, value);
        }
        return convertedMap;
    }

    public JfcreporttemplateUtil.OutputType readReportTemplateValues(String templateid, Map<String, String> valueMap, ActionParameter p) {
        Map valueMap1;
        JfcreporttemplateUtil.OutputType outputType = JfcreporttemplateUtil.readTemplateValues(templateid, valueMap, p);
        JfcreporttemplateUtil.OutputType outputType1 = (JfcreporttemplateUtil.OutputType)((Object)p.request.getAttribute(OutputTypeAttributeName));
        if (outputType1 != null) {
            outputType = outputType1;
        }
        if ((valueMap1 = (Map)p.request.getAttribute(ValueMapAttributeName)) != null) {
            valueMap.putAll(valueMap1);
        }
        return outputType;
    }

    protected boolean isSelectId(String id, ActionParameter p) {
        return true;
    }

    protected boolean isContainsId(String id, ActionParameter p) {
        return true;
    }
}

