/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public abstract class ThreadLocalFactoryBean<T> {
    private static final Logger logger = LogManager.getLogger(ThreadLocalFactoryBean.class);
    private ThreadLocal<Boolean> thUseThreadLocal = new ThreadLocal();
    private ThreadLocal<T> thinstance = new ThreadLocal();

    public abstract T getInstance();

    public abstract T createInstance();

    public void clearThreadLocal() {
        this.thUseThreadLocal.remove();
        this.thinstance.remove();
    }

    public boolean isUseThreadLocal() {
        Boolean b = this.thUseThreadLocal.get();
        if (logger.isDebugEnabled()) {
            logger.debug("usethreadlocal.get = " + b);
        }
        if (b == null) {
            return false;
        }
        return b;
    }

    public void useThreadLocal() {
        this.thUseThreadLocal.set(Boolean.TRUE);
        if (logger.isDebugEnabled()) {
            logger.debug("set usethreadlocal = " + this.thUseThreadLocal.get());
        }
    }

    public static void useThreadLocal(ApplicationContext appctx) {
        List list = (List)appctx.getBean("ThreadLocalFactoryBeanList");
        for (ThreadLocalFactoryBean bean : list) {
            bean.useThreadLocal();
        }
    }

    public static void clearThreadLocal(ApplicationContext appctx) {
        List list = (List)appctx.getBean("ThreadLocalFactoryBeanList");
        for (ThreadLocalFactoryBean bean : list) {
            bean.clearThreadLocal();
        }
    }

    public T getObject() throws Exception {
        if (!this.isUseThreadLocal()) {
            T list = this.getInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("NOT use ThreadLocal " + list.getClass());
            }
            return list;
        }
        T list = this.thinstance.get();
        if (list == null) {
            list = this.createInstance();
            this.thinstance.set(list);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Use ThreadLocal " + list.getClass());
        }
        return list;
    }
}

