/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.ITotalProcessor;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.commons.lang3.ArrayUtils;

public abstract class TotalProcessorBase
implements ITotalProcessor {
    public TotalProcessorBase() {
        this.init();
    }

    @Override
    public void init() {
    }

    @Override
    public Object getResult(ActionParameter p) {
        return null;
    }

    @Override
    public void process(Object __target, ActionParameter p) {
    }

    public void sum(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_long += value;
    }

    public void sum(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_double += value;
    }

    public void count(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        ++obj.count;
    }

    public void count(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        ++obj.count;
    }

    public void avg(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        ++obj.count;
        obj.value_long += value;
    }

    public void avg(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        ++obj.count;
        obj.value_double += value;
    }

    public void max(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_long = Math.max(obj.value_long, value);
    }

    public void max(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_double = Math.max(obj.value_double, value);
    }

    public void min(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_long = Math.min(obj.value_long, value);
    }

    public void min(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_double = Math.min(obj.value_double, value);
    }

    public void multi(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_long *= value;
    }

    public void multi(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        obj.value_double *= value;
    }

    public void median(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void median(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    public void mode(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void mode(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    public void stdev(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void stdev(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    public void stdevp(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void stdevp(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    public void var(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void var(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    public void varp(Map<String, MajorObject> valueMap, String key, long value) {
        this.addLongToList(valueMap, key, value);
    }

    public void varp(Map<String, MajorObject> valueMap, String key, double value) {
        this.addDoubleToList(valueMap, key, value);
    }

    private void addLongToList(Map<String, MajorObject> valueMap, String key, long value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        if (obj.longs == null) {
            obj.longs = new ArrayList<Long>();
        }
        obj.longs.add(value);
    }

    private void addDoubleToList(Map<String, MajorObject> valueMap, String key, double value) {
        MajorObject obj = valueMap.get(key);
        if (obj == null) {
            obj = this.init(valueMap, key);
        }
        if (obj.doubles == null) {
            obj.doubles = new ArrayList<Double>();
        }
        obj.doubles.add(value);
    }

    public MajorObject init(Map<String, MajorObject> valueMap, String key) {
        MajorObject mo = new MajorObject();
        valueMap.put(key, mo);
        return mo;
    }

    public MajorObject init(Map<String, MajorObject> valueMap, String key, long initValue) {
        MajorObject mo = this.init(valueMap, key);
        mo.value_long = initValue;
        return mo;
    }

    public MajorObject init(Map<String, MajorObject> valueMap, String key, double initValue) {
        MajorObject mo = this.init(valueMap, key);
        mo.value_double = initValue;
        return mo;
    }

    public long getSumAsLong(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsLong(valueMap, key);
    }

    public long getMultiAsLong(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsLong(valueMap, key);
    }

    public long getMaxAsLong(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsLong(valueMap, key);
    }

    public long getMinAsLong(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsLong(valueMap, key);
    }

    private long getValueAsLong(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null) {
            return obj.value_long;
        }
        return 0L;
    }

    public double getSumAsDouble(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsDouble(valueMap, key);
    }

    public double getMultiAsDouble(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsDouble(valueMap, key);
    }

    public double getMaxAsDouble(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsDouble(valueMap, key);
    }

    public double getMinAsDouble(Map<String, MajorObject> valueMap, String key) {
        return this.getValueAsDouble(valueMap, key);
    }

    private double getValueAsDouble(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null) {
            return obj.value_double;
        }
        return 0.0;
    }

    public long getCount(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null) {
            return obj.count;
        }
        return 0L;
    }

    public double getAvg(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.count > 0L) {
            long l = obj.value_long;
            if (l > 0L) {
                return (double)obj.value_long / (double)obj.count;
            }
            double d = obj.value_double;
            if (d > 0.0) {
                return obj.value_double / (double)obj.count;
            }
            return 0.0;
        }
        return Double.NaN;
    }

    public double getMedian(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.MEDIAN((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.MEDIAN((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public long getModeAsLong(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.MODE((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        return Long.MIN_VALUE;
    }

    public double getModeAsDouble(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.MEDIAN((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public double getStdev(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.STDEV((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.STDEV((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public double getStdevp(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.STDEVP((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.STDEVP((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public double getVar(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.VAR((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.VAR((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public double getVarp(Map<String, MajorObject> valueMap, String key) {
        MajorObject obj = valueMap.get(key);
        if (obj != null && obj.longs != null) {
            return ExcelFunction.VARP((long[])ArrayUtils.toPrimitive((Long[])obj.longs.toArray(new Long[obj.longs.size()])));
        }
        if (obj != null && obj.doubles != null) {
            return ExcelFunction.VARP((double[])ArrayUtils.toPrimitive((Double[])obj.doubles.toArray(new Double[obj.doubles.size()])));
        }
        return Double.NaN;
    }

    public void count(Map<String, Map<String, Long>> valueMap, String key, String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        Map<String, Long> _objectMap = valueMap.get(key);
        Long _count = _objectMap.get(str);
        if (_count == null) {
            _count = 0L;
        }
        _objectMap.put(str, _count + 1L);
    }

    public void count(Map<String, Map<String, Long>> valueMap, String key, String[] ids) {
        if (ids == null) {
            return;
        }
        Map<String, Long> _masterMap = valueMap.get(key);
        for (int i = 0; i < ids.length; ++i) {
            Long _count = _masterMap.get(ids[i]);
            if (_count == null) {
                _count = 0L;
            }
            _masterMap.put(ids[i], _count + 1L);
        }
    }

    private class MajorObject {
        long count;
        long value_long;
        double value_double;
        List<Long> longs;
        List<Double> doubles;

        private MajorObject() {
        }
    }
}

