/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.AADOAuth2UserService;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import jp.jasminesoft.jfc.core.support.spring.security.oidc.DefaultOidcUserDetails;
import jp.jasminesoft.jfc.core.support.spring.security.oidc.OidcUsernameResolver;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(prefix="azure.activedirectory", value={"tenant-id"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class, ServiceEndpointsProperties.class})
public class AADOAuth2AutoConfiguration
extends com.microsoft.azure.spring.autoconfigure.aad.AADOAuth2AutoConfiguration {
    public AADOAuth2AutoConfiguration(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps) {
        super(aadAuthProps, serviceEndpointsProps);
    }

    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        try {
            return new AADOAuth2UserDetailsService((AADAuthenticationProperties)FieldUtils.readField((Object)((Object)this), (String)"aadAuthProps", (boolean)true), (ServiceEndpointsProperties)FieldUtils.readField((Object)((Object)this), (String)"serviceEndpointsProps", (boolean)true));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public class AADOAuth2UserDetailsService
    extends AADOAuth2UserService {
        @Autowired(required=false)
        private OidcUsernameResolver resolver;

        public AADOAuth2UserDetailsService(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps) {
            super(aadAuthProps, serviceEndpointsProps);
        }

        public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
            OidcUser oidcUser = super.loadUser(userRequest);
            return new DefaultOidcUserDetails((DefaultOidcUser)oidcUser, this.resolver);
        }
    }
}

