/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;

public class CheckReferrerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LogManager.getLogger(CheckReferrerInterceptor.class);
    @Value(value="${wagby.checkreferrer.url:}")
    private List<String> url;
    @Value(value="${wagby.checkreferrer.acceptempty:false}")
    private boolean acceptempty;
    @Value(value="${wagby.checkreferrer.excludepath:}")
    private List<String> excludepath;
    @Value(value="${wagby.checkreferrer.defaultexcludepath:/logonPage.do,/logon.do,/rest/**,/v3/**}")
    private List<String> defaultexcludepath;
    @Value(value="${wagby.checkreferrer.errorpage:/error_referrer.jsp}")
    private String errorpage;

    @PostConstruct
    public void init() {
        if (!this.isEnabled()) {
            logger.debug("checkReferrer nothing");
            return;
        }
        logger.info("checkReferrer url " + this.url);
        logger.info("checkReferrer acceptempty " + this.acceptempty);
        logger.info("checkReferrer excludepath " + this.excludepath);
        logger.info("checkReferrer defaultexcludepath " + this.defaultexcludepath);
    }

    public boolean isEnabled() {
        return this.url.size() > 0;
    }

    public List<String> getExcludepath() {
        ArrayList<String> excludepath1 = new ArrayList<String>(this.excludepath);
        excludepath1.addAll(this.defaultexcludepath);
        return excludepath1;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String referrer = request.getHeader("Referer");
        if (!this.check(referrer)) {
            logger.info("Caught in referrer check. referrer:" + referrer + " request_uri:" + request.getRequestURI());
            if (StringUtils.isNotBlank((CharSequence)this.errorpage)) {
                String redirectpage = request.getContextPath() + this.errorpage;
                if (logger.isDebugEnabled()) {
                    logger.debug("2 redirectpage " + redirectpage);
                }
                response.sendRedirect(redirectpage);
            } else {
                response.sendError(400);
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("3 " + referrer + " " + request.getRequestURI());
        }
        return true;
    }

    private boolean check(String referrer) {
        if (StringUtils.isBlank((CharSequence)referrer)) {
            return this.acceptempty;
        }
        for (String ch : this.url) {
            if (!referrer.startsWith(ch)) continue;
            return true;
        }
        return false;
    }
}

