/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import jp.jasminesoft.jfc.ActionParameterContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.SimpleThreadScope;

public class ClearThreadLocalScopeServletRequestListener
implements ServletRequestListener {
    private static final Logger logger = LogManager.getLogger(ClearThreadLocalScopeServletRequestListener.class);
    @Value(value="${wagby.ClearThreadLocalScopeServletRequestListener.noReflection:false}")
    private boolean noReflection = false;
    @Autowired
    private ApplicationContext appctx;
    private ThreadLocal<?> threadLocal;
    private final Field threadScopeField;

    public ClearThreadLocalScopeServletRequestListener() {
        Field field;
        try {
            Class<SimpleThreadScope> simpleThreadScopeClass = SimpleThreadScope.class;
            field = simpleThreadScopeClass.getDeclaredField("threadScope");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            logger.error("SimpleThreadScope class is nothing threadScope field.", (Throwable)e);
            field = null;
        }
        catch (SecurityException e) {
            logger.error("SimpleThreadScope class getting field is security error.", (Throwable)e);
            field = null;
        }
        this.threadScopeField = field;
    }

    public void requestInitialized(ServletRequestEvent sre) {
        logger.debug("requestInitialized");
        this.clear();
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        logger.debug("requestDestroyed");
        this.clear();
    }

    private void clearNoReflection() {
        logger.debug("use noReflection");
        ((ActionParameterContainer)this.appctx.getBean("ActionParameterContainer", ActionParameterContainer.class)).set(null);
        ((List)this.appctx.getBean("RequestScopedInterceptors", List.class)).clear();
    }

    private void clear() {
        if (this.noReflection) {
            this.clearNoReflection();
            return;
        }
        ThreadLocal<?> threadLocal = this.getThreadLocal();
        if (threadLocal == null) {
            this.clearNoReflection();
            this.noReflection = true;
            return;
        }
        threadLocal.remove();
        logger.debug("clear threadLocalScope");
    }

    public static void clear(ApplicationContext appctx) {
        ((ClearThreadLocalScopeServletRequestListener)appctx.getBean(ClearThreadLocalScopeServletRequestListener.class)).clear();
    }

    private ThreadLocal<?> getThreadLocal() {
        if (this.threadLocal != null) {
            return this.threadLocal;
        }
        String SimpleThreadScopeBeanName = "simpleThreadScope";
        if (!this.appctx.containsBean("simpleThreadScope")) {
            logger.error("nothing simpleThreadScope bean.");
            return null;
        }
        Object obj = this.appctx.getBean("simpleThreadScope");
        if (obj == null) {
            logger.error("simpleThreadScope bean is null.");
            return null;
        }
        if (!(obj instanceof SimpleThreadScope)) {
            logger.error("simpleThreadScope bean is not SimpleThreadScope class.");
            return null;
        }
        SimpleThreadScope simpleThreadScope = (SimpleThreadScope)obj;
        Field field = this.getThreadScopeField();
        if (field == null) {
            logger.debug("threadscopefield is null");
            return null;
        }
        try {
            ThreadLocal threadLocal;
            Object threadLocalO = field.get(simpleThreadScope);
            if (threadLocalO == null) {
                logger.error("threadScope Field instance is null");
                return null;
            }
            if (!(threadLocalO instanceof ThreadLocal)) {
                logger.error("threadScope field instance type is not ThreadLocal class. " + threadLocalO.getClass());
                return null;
            }
            this.threadLocal = threadLocal = (ThreadLocal)threadLocalO;
            return threadLocal;
        }
        catch (SecurityException e) {
            logger.error("threadScope Field security error", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("threadScope Field illegal argument", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("threadScope Field illegal access", (Throwable)e);
        }
        return null;
    }

    private Field getThreadScopeField() {
        return this.threadScopeField;
    }
}

