/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.autoconfiguration.DownloadFileObjectProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DownloadFileObjectProperties.class})
public class DownloadFileObjectConfiguration {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectConfiguration.class);
    @Autowired
    private DownloadFileObjectProperties prop;

    public KeySetting getKeySetting(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("key=" + key);
        }
        for (DownloadFileObjectProperties.KeySettingImpl setting : this.prop.getKeySettings()) {
            Matcher matcher;
            Pattern pat = setting.getPattern2();
            if (pat == null || !(matcher = pat.matcher(key)).find()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("find keysetting=" + setting);
            }
            return new KeySetting(setting);
        }
        DownloadFileObjectProperties.KeySettingImpl defaultsetting = this.prop.getDefaultKeySetting();
        if (logger.isDebugEnabled()) {
            logger.debug("not find. use default keysetting=" + defaultsetting);
        }
        return new KeySetting(defaultsetting);
    }

    public KeySetting createKeySetting(KeySetting setting, boolean redirectUrl) {
        return new KeySetting(setting, redirectUrl);
    }

    public static class KeySetting {
        private String raCacheControl;
        private String restCacheControl;
        private boolean redirectUrl;

        private KeySetting(String raCacheControl, String restCacheControl, boolean redirectUrl) {
            this.raCacheControl = raCacheControl;
            this.restCacheControl = restCacheControl;
            this.redirectUrl = redirectUrl;
        }

        private KeySetting(KeySetting setting, boolean redirectUrl) {
            this(setting.raCacheControl, setting.restCacheControl, redirectUrl);
        }

        private KeySetting(DownloadFileObjectProperties.KeySettingImpl setting) {
            this(setting.getRaCacheControl(), setting.getRestCacheControl(), setting.isRedirectUrl());
        }

        public String getRaCacheControl() {
            return this.raCacheControl;
        }

        public String getRestCacheControl() {
            return this.restCacheControl;
        }

        public boolean isRedirectUrl() {
            return this.redirectUrl;
        }

        public String toString() {
            return "raCacheControl=" + this.raCacheControl + ",restCacheControl=" + this.restCacheControl + ",redirectUrl=" + this.redirectUrl;
        }
    }
}

