/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FilestoreS3Properties.class})
public class FilestoreS3Configuration {
    private static final Logger logger = LogManager.getLogger(FilestoreS3Configuration.class);
    @Autowired
    private FilestoreS3Properties prop;

    public FilestoreS3Properties.KeySettingImpl getKeySetting(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("key=" + key);
        }
        for (FilestoreS3Properties.KeySettingImpl setting : this.prop.getKeySettings()) {
            Matcher matcher;
            Pattern pat = setting.getPattern2();
            if (pat == null || !(matcher = pat.matcher(key)).find()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("find keysetting=" + setting);
            }
            return setting;
        }
        FilestoreS3Properties.KeySettingImpl defaultsetting = this.prop.getDefaultKeySetting();
        if (logger.isDebugEnabled()) {
            logger.debug("not find. use default keysetting=" + defaultsetting);
        }
        return defaultsetting;
    }
}

