/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.annotation.web.http.EnableSpringHttpSession;

@Configuration
@EnableSpringHttpSession
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnProperty(prefix="wagby.security", value={"map-session-repository"}, havingValue="true")
public class HashMapSessionConfiguration {
    @Bean
    public MapSessionRepository sessionRepository(SessionProperties properties) {
        if (StoreType.NONE != properties.getStoreType()) {
            throw new IllegalStateException("'spring.session.store-type' must be NONE in case of 'wagby.security.map-session-repository=true'.");
        }
        MapSessionRepository repository = new MapSessionRepository(new ConcurrentHashMap());
        if (properties.getTimeout() != null) {
            repository.setDefaultMaxInactiveInterval((int)properties.getTimeout().getSeconds());
        }
        return repository;
    }
}

