/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.PreDestroy;
import jp.jasminesoft.jfc.JFCUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class HsqldbShutdownInitializer {
    private static final Logger logger = LogManager.getLogger((String)HsqldbShutdownInitializer.class.getName());
    @Value(value="${wagby.autoconfiguration.hsqldbShutdownInitializer:false}")
    private Boolean hsqldbListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void preDestroy() {
        logger.info("predestroy");
        if (!this.hsqldbListener.booleanValue()) {
            logger.debug("return 1");
            return;
        }
        if (this.isReload()) {
            logger.debug("return 2");
            return;
        }
        Connection con = null;
        Statement st = null;
        try {
            con = JFCUtils.getConnection();
            st = con.createStatement();
            st.execute("SHUTDOWN;");
            logger.debug("shutdown");
        }
        catch (Exception se) {
            logger.warn("Failed to get database connection.", (Throwable)se);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException se) {
                    logger.warn("Failed to close statement.", (Throwable)se);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException se) {
                    logger.warn("Failed to close database connection.", (Throwable)se);
                }
            }
        }
    }

    protected boolean isReload() {
        StackTraceElement[] elements;
        for (StackTraceElement element : elements = new Throwable().getStackTrace()) {
            if (!element.getClassName().equals("org.apache.catalina.core.StandardContext") || !element.getMethodName().equals("reload")) continue;
            return true;
        }
        return false;
    }
}

