/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
public class JFCErrorViewResolver
implements ErrorViewResolver,
Ordered {
    @Value(value="${wagby.JFCErrorViewResolver.disabled:false}")
    private boolean disabled = false;
    private int order = 10000;

    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> model) {
        if (this.disabled) {
            return null;
        }
        if (status.is4xxClientError()) {
            return new ModelAndView("clienterror");
        }
        if (status.is5xxServerError()) {
            return new ModelAndView("servererror");
        }
        return new ModelAndView("globalerror");
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

