/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.support.spring.security.oidc.DefaultOidcUserDetails;
import jp.jasminesoft.jfc.core.support.spring.security.oidc.OidcUsernameResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

@Configuration
@Conditional(value={ClientsConfiguredCondition.class})
public class OidcConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    protected SecurityProperties securityProperties;

    @Bean
    @ConditionalOnMissingBean
    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        return new OidcUserDetailsService();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/img/**", "/**/*.css", "/**/*.js", "/error"})).antMatchers(new String[]{"/**/favicon.ico"})).antMatchers(new String[]{"/dojo-release-*/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).headers().frameOptions().sameOrigin().and()).oauth2Login(Customizer.withDefaults()).oauth2Client().and()).logout().logoutSuccessUrl(this.securityProperties.getRemoteUserLogoffSuccessUrl()).invalidateHttpSession(true).permitAll().and()).csrf().disable();
    }

    public class OidcUserDetailsService
    extends OidcUserService {
        @Autowired(required=false)
        private OidcUsernameResolver resolver;

        public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
            OidcUser oidcUser = super.loadUser(userRequest);
            return new DefaultOidcUserDetails((DefaultOidcUser)oidcUser, this.resolver);
        }
    }
}

