/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration.session1;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
public class ServletSessionConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CookieSerializer.class})
    DefaultCookieSerializer cookieSerializer(ServerProperties serverProperties) {
        Session.Cookie cookie = serverProperties.getServlet().getSession().getCookie();
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> ((Session.Cookie)cookie).getName()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieName(arg_0));
        map.from(() -> ((Session.Cookie)cookie).getDomain()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setDomainName(arg_0));
        map.from(() -> ((Session.Cookie)cookie).getPath()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookiePath(arg_0));
        map.from(() -> ((Session.Cookie)cookie).getHttpOnly()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseHttpOnlyCookie(arg_0));
        map.from(() -> ((Session.Cookie)cookie).getSecure()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseSecureCookie(arg_0));
        map.from(() -> ((Session.Cookie)cookie).getMaxAge()).to(maxAge -> cookieSerializer.setCookieMaxAge((int)maxAge.getSeconds()));
        return cookieSerializer;
    }
}

