/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration.util;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SecurityConfigurationUtils {
    public static final String[] DEFAULT_PERMIT_ALL_URLS = new String[]{"/", "/index.jsp", "/remindPassword.do", "/setNewPassword.do"};

    protected SecurityConfigurationUtils() {
    }

    public static String[] permitAllUrls(SecurityProperties securityProperties) {
        ArrayList<String> urls = new ArrayList<String>();
        if (CollectionUtils.isEmpty(securityProperties.getPermitAllUrls())) {
            CollectionUtils.add(urls, DEFAULT_PERMIT_ALL_URLS);
        } else {
            urls.addAll(securityProperties.getPermitAllUrls());
        }
        urls.add(securityProperties.getLogonPage());
        return urls.toArray(new String[urls.size()]);
    }

    public static RequestMatcher defaultLogonAuthenticationRequestMatcher(SecurityProperties securityProperties) {
        ArrayList urls = new ArrayList();
        CollectionUtils.add(urls, SecurityConfigurationUtils.permitAllUrls(securityProperties));
        CollectionUtils.add(urls, securityProperties.getLoginProcessingUrl());
        return new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(urls.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList())));
    }

    public static RequestMatcher autoLogonAuthenticationRequestMatcher(SecurityProperties securityProperties) {
        return new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(Stream.of(SecurityConfigurationUtils.permitAllUrls(securityProperties)).map(AntPathRequestMatcher::new).collect(Collectors.toList())));
    }
}

