/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.model.jcalendar_lp.Calendaritem;
import jp.jasminesoft.jfc.model.jcalendar_lp.Endhour;
import jp.jasminesoft.jfc.model.jcalendar_lp.Endminute;
import jp.jasminesoft.jfc.model.jcalendar_lp.Item;
import jp.jasminesoft.jfc.model.jcalendar_lp.JcalendarLp;
import jp.jasminesoft.jfc.model.jcalendar_lp.Starthour;
import jp.jasminesoft.jfc.model.jcalendar_lp.Startminute;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class CalendarViewUtils {
    private static final Calendar createCalendar(String date) {
        String[] formats = new String[]{"yyyy-MM-dd", "yyyy-MM"};
        Date _date = DateTimeUtil.getDateWithFormat((String)date, (String[])formats);
        if (_date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(_date);
        return cal;
    }

    private static final int getProperYoubi(String date) {
        Calendar cal = CalendarViewUtils.createCalendar(date);
        if (cal != null) {
            return cal.get(7);
        }
        return -1;
    }

    private static final boolean isSunday(String date) {
        int youbi = CalendarViewUtils.getProperYoubi(date);
        return youbi == 1;
    }

    private static final boolean isSaturday(String date) {
        int youbi = CalendarViewUtils.getProperYoubi(date);
        return youbi == 7;
    }

    private static final boolean isHoliday(String holiday) {
        return holiday != null && holiday.trim().length() > 0;
    }

    private static final String getCaption(JcalendarLp jcalendar_lp, int type, String locale) {
        String rkey;
        Item[] items = jcalendar_lp.getItem();
        String caption = "";
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        if (type == 2 || type == 4) {
            rkey = JFCUtils.getRValue("__jfc_common.displaycalendar.format.yyyyM", locale);
            df.applyPattern(rkey);
        } else {
            rkey = JFCUtils.getRValue("__jfc_common.displaycalendar.format.yyyyMd", locale);
            df.applyPattern(rkey);
        }
        for (int i = 0; i < items.length; ++i) {
            if (type == 2 && !"7".equals(items[i].getPosition())) continue;
            Date _date = CalendarViewUtils.createCalendar(items[i].getDate()).getTime();
            caption = df.format(_date);
            break;
        }
        return caption;
    }

    private static final String createEscapeString(String s) {
        s = StringEscapeUtils.escapeHtml4((String)s);
        s = StringUtil.replaceAll((String)s, (String)"\n", (String)"<br/>");
        return s;
    }

    private static final String createCalInfoBox(Calendaritem citem, String locale) {
        String __note;
        String __staff;
        String __place;
        String __title;
        String rkey;
        StringBuilder sb = new StringBuilder();
        sb.append("<table class=\"schedule_header\">");
        String modelname = citem.getModelname();
        if (modelname != null && modelname.length() > 0) {
            String rkey2 = JFCUtils.getRValue("__jfc_common.displaycalendar.label.modelname", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey2);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(modelname);
            sb.append("</td>");
            sb.append("</tr>");
        }
        Starthour __starthour = citem.getStarthour();
        Startminute __startminute = citem.getStartminute();
        if (__starthour != null && __starthour.getContent() != null) {
            String cnt1 = CalendarViewUtils.createEscapeString(__starthour.getContent());
            String cnt2 = null;
            cnt2 = __startminute == null || __startminute.getId() == 0 ? "00" : CalendarViewUtils.createEscapeString(__startminute.getContent());
            String rkey3 = JFCUtils.getRValue("__jfc_common.displaycalendar.label.startdate", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey3);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt1 + ":" + cnt2);
            sb.append("</td>");
            sb.append("</tr>");
        }
        Endhour __endhour = citem.getEndhour();
        Endminute __endminute = citem.getEndminute();
        if (__endhour != null && __endhour.getContent() != null) {
            String cnt1 = CalendarViewUtils.createEscapeString(__endhour.getContent());
            String cnt2 = null;
            cnt2 = __endminute == null || __endminute.getId() == 0 ? "00" : CalendarViewUtils.createEscapeString(__endminute.getContent());
            rkey = JFCUtils.getRValue("__jfc_common.displaycalendar.label.enddate", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt1 + ":" + cnt2);
            sb.append("</td>");
            sb.append("</tr>");
        }
        if ((__title = citem.getTitle()) != null && __title.length() > 0) {
            String cnt = CalendarViewUtils.createEscapeString(__title);
            rkey = JFCUtils.getRValue("__jfc_common.displaycalendar.label.title", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt);
            sb.append("</td>");
            sb.append("</tr>");
        }
        if ((__place = citem.getPlace()) != null && __place.length() > 0) {
            String cnt = CalendarViewUtils.createEscapeString(__place);
            String rkey4 = JFCUtils.getRValue("__jfc_common.displaycalendar.label.place", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey4);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt);
            sb.append("</td>");
            sb.append("</tr>");
        }
        if ((__staff = citem.getStaff()) != null && __staff.length() > 0) {
            String cnt = CalendarViewUtils.createEscapeString(__staff);
            String rkey5 = JFCUtils.getRValue("__jfc_common.displaycalendar.label.staff", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey5);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt);
            sb.append("</td>");
            sb.append("</tr>");
        }
        if ((__note = citem.getNote()) != null && __note.length() > 0) {
            String cnt = CalendarViewUtils.createEscapeString(__note);
            String rkey6 = JFCUtils.getRValue("__jfc_common.displaycalendar.label.note", locale);
            sb.append("<tr>");
            sb.append("<th class=\"schedule_hide\">");
            sb.append(rkey6);
            sb.append("</th>");
            sb.append("<td class=\"schedule_normal1\">");
            sb.append(cnt);
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private static final boolean isInclude(String staff, String input) {
        if (staff == null || input == null) {
            return false;
        }
        boolean ret = false;
        String[] stokens = input.split(",");
        if (stokens != null && stokens.length > 0) {
            for (int i = 0; i < stokens.length; ++i) {
                if (!staff.equals(stokens[i])) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static final String[] getStaffArray(Item[] items) {
        TreeSet<String> staffSet = new TreeSet<String>();
        for (int i = 0; i < items.length; ++i) {
            Calendaritem[] citems = items[i].getCalendaritem();
            if (citems == null) continue;
            for (int j = 0; j < citems.length; ++j) {
                String[] stokens;
                String staff = citems[j].getStaff();
                if (staff == null || (stokens = staff.split(",")) == null || stokens.length <= 0) continue;
                for (int k = 0; k < stokens.length; ++k) {
                    if (stokens[k].length() <= 0 || stokens[k].endsWith("(-)")) continue;
                    staffSet.add(stokens[k]);
                }
            }
        }
        return staffSet.toArray(new String[0]);
    }

    private static final String getYoubiInnerMessageKeyName(int pattern) {
        String youbi = null;
        switch (pattern) {
            case 1: {
                youbi = "__jfc_common.displaycalendar.label.inner.sunday";
                break;
            }
            case 2: {
                youbi = "__jfc_common.displaycalendar.label.inner.monday";
                break;
            }
            case 3: {
                youbi = "__jfc_common.displaycalendar.label.inner.tuesday";
                break;
            }
            case 4: {
                youbi = "__jfc_common.displaycalendar.label.inner.wednesday";
                break;
            }
            case 5: {
                youbi = "__jfc_common.displaycalendar.label.inner.thursday";
                break;
            }
            case 6: {
                youbi = "__jfc_common.displaycalendar.label.inner.friday";
                break;
            }
            case 7: {
                youbi = "__jfc_common.displaycalendar.label.inner.saturday";
                break;
            }
            default: {
                youbi = "";
            }
        }
        return youbi;
    }

    private static final String getCssFieldByDate(Item item, int num_of_field, int targetmonth) {
        String __css_field = null;
        String __holiday = item.getHoliday();
        int nowmonth = Integer.parseInt(item.getDate().substring(5, 7));
        __css_field = DateTimeUtil.isToday((String)item.getDate()) ? "schedule_today" : (nowmonth != targetmonth ? "schedule_hide" : (CalendarViewUtils.isSunday(item.getDate()) || CalendarViewUtils.isHoliday(__holiday) ? "schedule_sunday" : (CalendarViewUtils.isSaturday(item.getDate()) ? "schedule_saturday" : (num_of_field % 2 == 0 ? "schedule_normal1" : "schedule_normal2"))));
        return __css_field;
    }

    private static final String getYearAsString(Item item) {
        String year_str = item.getDate().substring(0, 4);
        return year_str;
    }

    private static final String getMonthAsString(Item item) {
        String month_str = item.getDate().substring(5, 7);
        month_str = Integer.toString(Integer.valueOf(month_str));
        return month_str;
    }

    private static final int getMonthAsInt(Item item) {
        String month_str = item.getDate().substring(5, 7);
        return Integer.parseInt(month_str);
    }

    private static final String getDateAsString(Item item) {
        String date_str = item.getDate().substring(8, 10);
        date_str = Integer.toString(Integer.valueOf(date_str));
        return date_str;
    }

    private static final String simpleFormat(Item item, String locale) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        String rkey = JFCUtils.getRValue("__jfc_common.displaycalendar.format.simple_ymd", locale);
        df.applyPattern(rkey);
        Date _date = CalendarViewUtils.createCalendar(item.getDate()).getTime();
        return df.format(_date);
    }

    public static final String getMonthScheduleHTMLContent(ActionParameter p) {
        JcalendarLp jcalendar_lp = (JcalendarLp)p.request.getAttribute("jcalendar_lp");
        HttpSession session = p.request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        int __targetmonth = Integer.parseInt(jcalendar_lp.getTargetmonth());
        String __showListUrl = jcalendar_lp.getShowlisturl();
        String __insertUrl = jcalendar_lp.getInserturl();
        String __caption = CalendarViewUtils.getCaption(jcalendar_lp, 2, locale);
        Boolean isRokuyoFlag = (Boolean)p.request.getAttribute("__jfc_calendarview_rokuyo");
        Item[] items = jcalendar_lp.getItem();
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=\"100%\" class=\"display_table\" cellspacing=\"1\">").append(StringUtil.CR);
        sb.append("<caption class=\"schedule\">").append(StringEscapeUtils.escapeHtml4((String)__caption)).append("</caption>").append(StringUtil.CR);
        sb.append("<tr height=\"5%\">").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:red;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.sunday", locale)).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:white;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.monday", locale)).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:white;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.tuesday", locale)).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:white;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.wednesday", locale)).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:white;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.thursday", locale)).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:white;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.friday", locale)).append(StringUtil.CR).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"14%\">").append(StringUtil.CR);
        sb.append("<span style=\"color:blue;\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.saturday", locale)).append(StringUtil.CR).append("</span>").append(StringUtil.CR);
        sb.append("</th>").append(StringUtil.CR);
        sb.append("</tr>").append(StringUtil.CR);
        for (int i = 0; i < items.length; ++i) {
            String __holiday = items[i].getHoliday();
            if (CalendarViewUtils.isSunday(items[i].getDate())) {
                sb.append("<tr height=\"15%\">").append(StringUtil.CR);
            }
            String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
            String url = __showListUrl + "?action_Search_Day=&targetdate=" + items[i].getDate();
            sb.append("<td class=\"").append(__css_field).append("\" height=\"100\" valign=\"top\">").append(StringUtil.CR);
            sb.append("<a href=\"").append(url).append("\">").append(Integer.parseInt(CalendarViewUtils.getDateAsString(items[i])));
            if (CalendarViewUtils.isHoliday(__holiday)) {
                sb.append("[ ").append(StringEscapeUtils.escapeHtml4((String)__holiday)).append(" ]");
            }
            sb.append("</a>").append(StringUtil.CR);
            if (isRokuyoFlag != null) {
                sb.append(CalendarViewUtils.getRokuyoNode(items[i]));
            }
            if (StringUtils.isNotBlank((CharSequence)__insertUrl)) {
                sb.append("<a href=\"").append(__insertUrl).append("?action_New=&amp;targetdate=");
                sb.append(items[i].getDate()).append("\"><img src=\"img/pencil.gif\" width=\"16\" border=\"0\"/>");
                sb.append("</a>").append(StringUtil.CR);
            }
            sb.append("<br/>").append(StringUtil.CR);
            Calendaritem[] citems = items[i].getCalendaritem();
            if (citems != null) {
                ComparatorChain comp_hmt = new ComparatorChain();
                comp_hmt.addComparator((Comparator)new BeanComparator("starthour.id"));
                comp_hmt.addComparator((Comparator)new BeanComparator("startminute.id"));
                comp_hmt.addComparator((Comparator)new BeanComparator("title"));
                try {
                    Arrays.sort(citems, comp_hmt);
                }
                catch (Exception e) {
                    ArrayList<Calendaritem> citemlist_tmp = new ArrayList<Calendaritem>();
                    ArrayList<Calendaritem> citemlist_notime = new ArrayList<Calendaritem>();
                    for (Calendaritem citem : citems) {
                        if (citem.getStarthour() == null || citem.getStartminute() == null) {
                            citemlist_notime.add(citem);
                            continue;
                        }
                        citemlist_tmp.add(citem);
                    }
                    ComparatorChain comp_t = new ComparatorChain();
                    comp_t.addComparator((Comparator)new BeanComparator("title"));
                    try {
                        Collections.sort(citemlist_notime, comp_t);
                        Collections.sort(citemlist_tmp, comp_hmt);
                        citemlist_notime.addAll(citemlist_tmp);
                        citems = citemlist_notime.toArray(new Calendaritem[0]);
                    }
                    catch (Exception e1) {
                        try {
                            Arrays.sort(citems, comp_t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                for (int j = 0; j < citems.length; ++j) {
                    Object __title;
                    String __primarykeyname = citems[j].getPrimarykeyname();
                    Starthour _starthour = citems[j].getStarthour();
                    Startminute _startminute = citems[j].getStartminute();
                    String __cnt = CalendarViewUtils.createCalInfoBox(citems[j], locale);
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getUpdateurl())) {
                        String __url = citems[j].getUpdateurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Update=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\"><img src=\"img/pencil_update.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
                    }
                    String __id = JFCUtils.encodePrimaryKey(citems[j].getCalendarid()) + "_" + i;
                    sb.append("<span data-dojo-type=\"dijit/Tooltip\" connectId=\"calInfoBox").append(__id).append("\" style=\"display: none;\">");
                    sb.append(__cnt).append("</span>").append(StringUtil.CR);
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getShowurl())) {
                        String __url = citems[j].getShowurl() + "?" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a id=\"calInfoBox").append(__id).append("\" href=\"").append(__url).append("\">").append(StringUtil.CR);
                    } else {
                        sb.append("<span id=\"calInfoBox").append(__id).append("\">").append(StringUtil.CR);
                    }
                    if (_starthour != null && _starthour.getId() >= 0) {
                        sb.append(_starthour.getContent()).append(":");
                        if (_startminute == null || _startminute.getId() == 0) {
                            sb.append("00");
                        } else {
                            sb.append(_startminute.getContent());
                        }
                    }
                    if ((__title = citems[j].getTitle()) != null && !((String)__title).equals(__holiday)) {
                        if (((String)__title).length() > 6) {
                            __title = ((String)__title).substring(0, 6) + "...";
                        }
                        sb.append(" ").append(StringEscapeUtils.escapeHtml4((String)__title));
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getShowurl())) {
                        sb.append("</a>");
                    } else {
                        sb.append("</span>");
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getDeleteurl())) {
                        String __url = citems[j].getDeleteurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Send=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("[ <a href=\"").append(__url).append("\" onClick=\"var ret = doConfirm(this, '");
                        sb.append(JFCUtils.getRValue("__jfc_common.link.button.Delete.confirm", locale)).append("');return ret;\">x</a> ]").append(StringUtil.CR);
                    }
                    sb.append("<br/>").append(StringUtil.CR);
                }
            }
            sb.append("</td>").append(StringUtil.CR);
            if (!CalendarViewUtils.isSaturday(items[i].getPosition())) continue;
            sb.append("</tr>").append(StringUtil.CR);
        }
        sb.append("</table>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getMonthScheduleByStaffHTMLContent(ActionParameter p) {
        JcalendarLp jcalendar_lp = (JcalendarLp)p.request.getAttribute("jcalendar_lp");
        HttpSession session = p.request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        int __targetmonth = Integer.parseInt(jcalendar_lp.getTargetmonth());
        String __insertUrl = jcalendar_lp.getInserturl();
        String __caption = CalendarViewUtils.getCaption(jcalendar_lp, 2, locale);
        Boolean isRokuyoFlag = (Boolean)p.request.getAttribute("__jfc_calendarview_rokuyo");
        Item[] items = jcalendar_lp.getItem();
        String[] staff_ary = CalendarViewUtils.getStaffArray(items);
        String width_str = (int)(90.0 / (double)staff_ary.length) + "%";
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=\"100%\" class=\"display_table\" cellspacing=\"1\">").append(StringUtil.CR);
        sb.append("<caption class=\"schedule\">").append(StringEscapeUtils.escapeHtml4((String)__caption)).append("</caption>").append(StringUtil.CR);
        for (int i = 0; i < items.length; ++i) {
            int __nowmonth;
            if (i == 0) {
                sb.append("<tr>").append(StringUtil.CR);
                sb.append("  <th class=\"display_label\" width=\"100\"></th>").append(StringUtil.CR);
                for (int j = 0; j < staff_ary.length; ++j) {
                    sb.append("  <th class=\"display_label\" width=\"").append(width_str).append("\">");
                    sb.append(StringEscapeUtils.escapeHtml4((String)staff_ary[j]));
                    sb.append("</th>").append(StringUtil.CR);
                }
                sb.append("</tr>").append(StringUtil.CR);
            }
            if ((__nowmonth = CalendarViewUtils.getMonthAsInt(items[i])) != __targetmonth) continue;
            String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
            sb.append("<tr>").append(StringUtil.CR);
            sb.append("  <td class=\"").append(__css_field).append("\" style=\"text-align:center;padding-top:10px;padding-bottom:10px;\">");
            sb.append(CalendarViewUtils.simpleFormat(items[i], locale));
            if (isRokuyoFlag != null) {
                sb.append(CalendarViewUtils.getRokuyoNode(items[i]));
            }
            if (StringUtils.isNotBlank((CharSequence)__insertUrl)) {
                sb.append("<a href=\"").append(__insertUrl).append("?action_New=&amp;targetdate=");
                sb.append(items[i].getDate());
                sb.append("\"><img src=\"img/pencil.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
            }
            sb.append("</td>").append(StringUtil.CR);
            Calendaritem[] citems = items[i].getCalendaritem();
            String __holiday = items[i].getHoliday();
            for (int j = 0; j < staff_ary.length; ++j) {
                sb.append("<td class=\"").append(__css_field).append("\" width=\"").append(width_str).append("\" valign=\"top\">").append(StringUtil.CR);
                if (citems == null) continue;
                ComparatorChain comp_hm = new ComparatorChain();
                comp_hm.addComparator((Comparator)new BeanComparator("starthour.id"));
                comp_hm.addComparator((Comparator)new BeanComparator("startminute.id"));
                try {
                    Arrays.sort(citems, comp_hm);
                }
                catch (Exception e) {
                    ArrayList<Calendaritem> citemlist_tmp = new ArrayList<Calendaritem>();
                    ArrayList<Calendaritem> citemlist_notime = new ArrayList<Calendaritem>();
                    for (Calendaritem citem : citems) {
                        if (citem.getStarthour() == null || citem.getStartminute() == null) {
                            citemlist_notime.add(citem);
                            continue;
                        }
                        citemlist_tmp.add(citem);
                    }
                    ComparatorChain comp_t = new ComparatorChain();
                    comp_t.addComparator((Comparator)new BeanComparator("title"));
                    try {
                        Collections.sort(citemlist_notime, comp_t);
                        Collections.sort(citemlist_tmp, comp_hm);
                        citemlist_notime.addAll(citemlist_tmp);
                        citems = citemlist_notime.toArray(new Calendaritem[0]);
                    }
                    catch (Exception e1) {
                        try {
                            Arrays.sort(citems, comp_t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                for (int k = 0; k < citems.length; ++k) {
                    String __title;
                    String __url;
                    String staff = citems[k].getStaff();
                    if (!CalendarViewUtils.isInclude(staff_ary[j], staff)) continue;
                    String __primarykeyname = citems[k].getPrimarykeyname();
                    Starthour _starthour = citems[k].getStarthour();
                    Startminute _startminute = citems[k].getStartminute();
                    String __cnt = CalendarViewUtils.createCalInfoBox(citems[k], locale);
                    if (StringUtils.isNotBlank((CharSequence)citems[k].getUpdateurl())) {
                        __url = citems[k].getUpdateurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Update=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\"><img src=\"img/pencil_update.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[k].getShowurl())) {
                        __url = citems[k].getShowurl() + "?" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                        String __id = JFCUtils.encodePrimaryKey(citems[k].getCalendarid()) + "_" + i;
                        sb.append("<span data-dojo-type=\"dijit/Tooltip\" connectId=\"calInfoBox").append(__id).append("\" ");
                        sb.append("style=\"display: none;\">").append(__cnt).append("</span>").append(StringUtil.CR);
                        sb.append("<a id=\"calInfoBox").append(__id).append("\" href=\"").append(__url).append("\">");
                    }
                    if (_starthour != null && _starthour.getId() >= 0) {
                        sb.append(_starthour.getContent()).append(":");
                        if (_startminute == null || _startminute.getId() == 0) {
                            sb.append("00");
                        } else {
                            sb.append(_startminute.getContent());
                        }
                    }
                    if ((__title = citems[k].getTitle()) == null || __title.equals(__holiday)) continue;
                    sb.append(" ").append(StringEscapeUtils.escapeHtml4((String)__title));
                    if (StringUtils.isNotBlank((CharSequence)citems[k].getShowurl())) {
                        sb.append("</a>").append(StringUtil.CR);
                    } else {
                        sb.append("</span>").append(StringUtil.CR);
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[k].getDeleteurl())) {
                        String __url2 = citems[k].getDeleteurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Send=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                        sb.append("[ <a href=\"").append(__url2).append("\" onClick=\"var ret = doConfirm(this, '");
                        sb.append(JFCUtils.getRValue("__jfc_common.link.button.Delete.confirm", locale));
                        sb.append("');return ret;\">x</a> ]").append(StringUtil.CR);
                    }
                    sb.append("<br/>").append(StringUtil.CR);
                }
                sb.append("</td>").append(StringUtil.CR);
            }
            sb.append("</tr>").append(StringUtil.CR);
        }
        sb.append("</table>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getWeekScheduleHTMLContent(ActionParameter p) {
        JcalendarLp jcalendar_lp = (JcalendarLp)p.request.getAttribute("jcalendar_lp");
        HttpSession session = p.request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        int __targetmonth = Integer.parseInt(jcalendar_lp.getTargetmonth());
        String __insertUrl = jcalendar_lp.getInserturl();
        String __caption = CalendarViewUtils.getCaption(jcalendar_lp, 4, locale);
        Boolean isRokuyoFlag = (Boolean)p.request.getAttribute("__jfc_calendarview_rokuyo");
        Item[] items = jcalendar_lp.getItem();
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=\"100%\" class=\"display_table\" cellspacing=\"1\">").append(StringUtil.CR);
        sb.append("<caption class=\"schedule\">").append(StringEscapeUtils.escapeHtml4((String)__caption)).append("</caption>").append(StringUtil.CR);
        sb.append("<tr>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"10%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.date", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"30%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.title", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"15%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.place", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"30%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.staff", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"15%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.note", locale)).append("</th>").append(StringUtil.CR);
        sb.append("</tr>").append(StringUtil.CR);
        for (int i = 0; i < items.length; ++i) {
            String __holiday = items[i].getHoliday();
            String __pos = items[i].getPosition();
            int __youbi = CalendarViewUtils.getProperYoubi(items[i].getDate());
            String __youbi_key = CalendarViewUtils.getYoubiInnerMessageKeyName(__youbi);
            String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
            sb.append("<tr>").append(StringUtil.CR);
            sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-top:10px;padding-bottom:10px;\" ");
            sb.append("colspan=\"5\">").append(CalendarViewUtils.simpleFormat(items[i], locale));
            if (__youbi == 1) {
                sb.append("<span style=\"color:red\">");
            } else if (__youbi == 7) {
                sb.append("<span style=\"color:blue\">");
            } else {
                sb.append("<span>");
            }
            sb.append(JFCUtils.getRValue(__youbi_key, locale));
            sb.append("</span>").append(StringUtil.CR);
            if (isRokuyoFlag != null) {
                sb.append("<br/>").append(StringUtil.CR);
                sb.append(CalendarViewUtils.getRokuyoNode(items[i]));
            }
            if (StringUtils.isNotBlank((CharSequence)__insertUrl)) {
                sb.append("<a href=\"").append(__insertUrl).append("?action_New=&amp;targetdate=");
                sb.append(items[i].getDate());
                sb.append("\"><img src=\"img/pencil.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
            }
            sb.append("</td>").append(StringUtil.CR);
            sb.append("</tr>").append(StringUtil.CR);
            Calendaritem[] citems = items[i].getCalendaritem();
            if (citems == null) continue;
            ComparatorChain comp_hmt = new ComparatorChain();
            comp_hmt.addComparator((Comparator)new BeanComparator("starthour.id"));
            comp_hmt.addComparator((Comparator)new BeanComparator("startminute.id"));
            comp_hmt.addComparator((Comparator)new BeanComparator("title"));
            try {
                Arrays.sort(citems, comp_hmt);
            }
            catch (Exception e) {
                ArrayList<Calendaritem> citemlist_tmp = new ArrayList<Calendaritem>();
                ArrayList<Calendaritem> citemlist_notime = new ArrayList<Calendaritem>();
                for (Calendaritem citem : citems) {
                    if (citem.getStarthour() == null || citem.getStartminute() == null) {
                        citemlist_notime.add(citem);
                        continue;
                    }
                    citemlist_tmp.add(citem);
                }
                ComparatorChain comp_t = new ComparatorChain();
                comp_t.addComparator((Comparator)new BeanComparator("title"));
                try {
                    Collections.sort(citemlist_notime, comp_t);
                    Collections.sort(citemlist_tmp, comp_hmt);
                    citemlist_notime.addAll(citemlist_tmp);
                    citems = citemlist_notime.toArray(new Calendaritem[0]);
                }
                catch (Exception e1) {
                    try {
                        Arrays.sort(citems, comp_t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            for (int j = 0; j < citems.length; ++j) {
                String __url;
                String __primarykeyname = citems[j].getPrimarykeyname();
                Starthour _starthour = citems[j].getStarthour();
                Startminute _startminute = citems[j].getStartminute();
                Endhour _endhour = citems[j].getEndhour();
                Endminute _endminute = citems[j].getEndminute();
                sb.append("<tr>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" ");
                sb.append("style=\"text-align:right;padding-right:10px;padding-top:10px;padding-bottom:10px;\">");
                if (_starthour != null && _starthour.getId() >= 0) {
                    sb.append(_starthour.getContent()).append(":");
                    if (_startminute == null || _startminute.getId() == 0) {
                        sb.append("00");
                    } else {
                        sb.append(_startminute.getContent());
                    }
                }
                if (_endhour != null && _endhour.getId() >= 0) {
                    sb.append("..").append(_endhour.getContent());
                    if (_endminute == null || _endminute.getId() == 0) {
                        sb.append("00");
                    } else {
                        sb.append(_endminute.getContent());
                    }
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" ");
                sb.append("style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __title = citems[j].getTitle();
                if (__title != null && !__title.equals(__holiday)) {
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getUpdateurl())) {
                        __url = citems[j].getUpdateurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Update=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\"><img src=\"img/pencil_update.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getShowurl())) {
                        __url = citems[j].getShowurl() + "?" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\">").append(StringEscapeUtils.escapeHtml4((String)__title)).append("</a>");
                    } else {
                        sb.append("<span>").append(StringEscapeUtils.escapeHtml4((String)__title)).append("</span>").append(StringUtil.CR);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)citems[j].getDeleteurl())) {
                    __url = citems[j].getDeleteurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Send=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                    sb.append("[ <a href=\"").append(__url).append("\" ");
                    sb.append("onClick=\"var ret = doConfirm(this, '");
                    sb.append(JFCUtils.getRValue("__jfc_common.link.button.Delete.confirm", locale));
                    sb.append("');return ret;\">x</a> ]").append(StringUtil.CR);
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __place = citems[j].getPlace();
                if (__place != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__place));
                }
                sb.append("</td>");
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __staff = citems[j].getStaff();
                if (__staff != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__staff));
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __note = citems[j].getNote();
                if (__note != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__note));
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("</tr>").append(StringUtil.CR);
            }
        }
        sb.append("</table>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getWeekScheduleByStaffHTMLContent(ActionParameter p) {
        JcalendarLp jcalendar_lp = (JcalendarLp)p.request.getAttribute("jcalendar_lp");
        HttpSession session = p.request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        int __targetmonth = Integer.parseInt(jcalendar_lp.getTargetmonth());
        String __showListUrl = jcalendar_lp.getShowlisturl();
        String __insertUrl = jcalendar_lp.getInserturl();
        String __caption = CalendarViewUtils.getCaption(jcalendar_lp, 2, locale);
        Boolean isRokuyoFlag = (Boolean)p.request.getAttribute("__jfc_calendarview_rokuyo");
        Item[] items = jcalendar_lp.getItem();
        StringBuilder sb = new StringBuilder();
        String[] staff_ary = CalendarViewUtils.getStaffArray(items);
        sb.append("<table width=\"100%\" class=\"display_table\" cellspacing=\"1\">").append(StringUtil.CR);
        sb.append("<caption class=\"schedule\">").append(StringEscapeUtils.escapeHtml4((String)__caption)).append("</caption>").append(StringUtil.CR);
        sb.append("<tr>").append(StringUtil.CR);
        sb.append(" <th></th>").append(StringUtil.CR);
        for (int i = 0; i < items.length; ++i) {
            String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
            int __youbi = CalendarViewUtils.getProperYoubi(items[i].getDate());
            String youbi = CalendarViewUtils.getYoubiInnerMessageKeyName(__youbi);
            String day = CalendarViewUtils.getDateAsString(items[i]);
            sb.append("  <td class=\"").append(__css_field).append("\" ");
            sb.append("width=\"14%\" style=\"text-align:center;padding-top:10px;padding-bottom:10px;\">");
            sb.append(day).append(" ").append(JFCUtils.getRValue(youbi, locale)).append(StringUtil.CR);
            if (isRokuyoFlag != null) {
                sb.append(CalendarViewUtils.getRokuyoNode(items[i]));
            }
            if (StringUtils.isNotBlank((CharSequence)__insertUrl)) {
                sb.append("<a href=\"").append(__insertUrl).append("?action_New=&amp;targetdate=");
                sb.append(items[i].getDate());
                sb.append("\"><img src=\"img/pencil.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
            }
            sb.append("</td>").append(StringUtil.CR);
        }
        sb.append("</tr>").append(StringUtil.CR);
        for (int a = 0; a < staff_ary.length; ++a) {
            sb.append("<tr>").append(StringUtil.CR);
            sb.append("<th class=\"display_label_nowrap\">");
            sb.append(StringEscapeUtils.escapeHtml4((String)staff_ary[a]));
            sb.append("</th>").append(StringUtil.CR);
            for (int i = 0; i < items.length; ++i) {
                String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
                sb.append("<td class=\"").append(__css_field).append("\" valign=\"top\">").append(StringUtil.CR);
                Calendaritem[] citems = items[i].getCalendaritem();
                String __holiday = items[i].getHoliday();
                if (citems != null) {
                    ComparatorChain comp_hm = new ComparatorChain();
                    comp_hm.addComparator((Comparator)new BeanComparator("starthour.id"));
                    comp_hm.addComparator((Comparator)new BeanComparator("startminute.id"));
                    try {
                        Arrays.sort(citems, comp_hm);
                    }
                    catch (Exception e) {
                        ArrayList<Calendaritem> citemlist_tmp = new ArrayList<Calendaritem>();
                        ArrayList<Calendaritem> citemlist_notime = new ArrayList<Calendaritem>();
                        for (Calendaritem citem : citems) {
                            if (citem.getStarthour() == null || citem.getStartminute() == null) {
                                citemlist_notime.add(citem);
                                continue;
                            }
                            citemlist_tmp.add(citem);
                        }
                        ComparatorChain comp_t = new ComparatorChain();
                        comp_t.addComparator((Comparator)new BeanComparator("title"));
                        try {
                            Collections.sort(citemlist_notime, comp_t);
                            Collections.sort(citemlist_tmp, comp_hm);
                            citemlist_notime.addAll(citemlist_tmp);
                            citems = citemlist_notime.toArray(new Calendaritem[0]);
                        }
                        catch (Exception e1) {
                            try {
                                Arrays.sort(citems, comp_t);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    for (int k = 0; k < citems.length; ++k) {
                        String __title;
                        String __url;
                        String staff = citems[k].getStaff();
                        if (!CalendarViewUtils.isInclude(staff_ary[a], staff)) continue;
                        String __primarykeyname = citems[k].getPrimarykeyname();
                        Starthour _starthour = citems[k].getStarthour();
                        Startminute _startminute = citems[k].getStartminute();
                        String __cnt = CalendarViewUtils.createCalInfoBox(citems[k], locale);
                        if (StringUtils.isNotBlank((CharSequence)citems[k].getUpdateurl())) {
                            __url = citems[k].getUpdateurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Update=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                            sb.append("<a href=\"").append(__url).append("\"><img src=\"img/pencil_update.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
                        }
                        if (StringUtils.isNotBlank((CharSequence)citems[k].getShowurl())) {
                            __url = citems[k].getShowurl() + "?" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                            String __id = JFCUtils.encodePrimaryKey(citems[k].getCalendarid()) + "_" + i;
                            sb.append("<span data-dojo-type=\"dijit/Tooltip\" connectId=\"calInfoBox").append(__id).append("\" style=\"display: none;\">");
                            sb.append(__cnt).append("</span>").append(StringUtil.CR);
                            sb.append("<a id=\"calInfoBox").append(__id).append("\" href=\"").append(__url).append("\">");
                        }
                        if (_starthour != null && _starthour.getId() >= 0) {
                            sb.append(_starthour.getContent()).append(":");
                            if (_startminute == null || _startminute.getId() == 0) {
                                sb.append("00");
                            } else {
                                sb.append(_startminute.getContent());
                            }
                        }
                        if ((__title = citems[k].getTitle()) == null || __title.equals(__holiday)) continue;
                        sb.append(" ").append(StringEscapeUtils.escapeHtml4((String)__title));
                        if (StringUtils.isNotBlank((CharSequence)citems[k].getShowurl())) {
                            sb.append("</a>").append(StringUtil.CR);
                        } else {
                            sb.append("</span>").append(StringUtil.CR);
                        }
                        if (StringUtils.isNotBlank((CharSequence)citems[k].getDeleteurl())) {
                            String __url2 = citems[k].getDeleteurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Send=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[k].getCalendarid());
                            sb.append("[ <a href=\"").append(__url2).append("\" onClick=\"var ret = doConfirm(this, '");
                            sb.append(JFCUtils.getRValue("__jfc_common.link.button.Delete.confirm", locale)).append("');return ret;\">x</a> ]").append(StringUtil.CR);
                        }
                        sb.append("<br/>").append(StringUtil.CR);
                    }
                }
                sb.append("</td>").append(StringUtil.CR);
            }
            sb.append("</tr>").append(StringUtil.CR);
        }
        sb.append("</table>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getDayScheduleHTMLContent(ActionParameter p) {
        JcalendarLp jcalendar_lp = (JcalendarLp)p.request.getAttribute("jcalendar_lp");
        HttpSession session = p.request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        int __targetmonth = 0;
        String __insertUrl = jcalendar_lp.getInserturl();
        String __caption = CalendarViewUtils.getCaption(jcalendar_lp, 5, locale);
        Boolean isRokuyoFlag = (Boolean)p.request.getAttribute("__jfc_calendarview_rokuyo");
        Item[] items = jcalendar_lp.getItem();
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=\"100%\" class=\"display_table\" cellspacing=\"1\">").append(StringUtil.CR);
        sb.append("<caption class=\"schedule\">").append(StringEscapeUtils.escapeHtml4((String)__caption)).append("</caption>").append(StringUtil.CR);
        sb.append("<tr>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"10%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.date", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"30%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.title", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"15%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.place", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"30%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.staff", locale)).append("</th>").append(StringUtil.CR);
        sb.append("<th class=\"schedule_header\" width=\"15%\">").append(JFCUtils.getRValue("__jfc_common.displaycalendar.label.note", locale)).append("</th>").append(StringUtil.CR);
        sb.append("</tr>").append(StringUtil.CR);
        for (int i = 0; i < items.length; ++i) {
            String __holiday = items[i].getHoliday();
            int __youbi = CalendarViewUtils.getProperYoubi(items[i].getDate());
            String __youbi_key = CalendarViewUtils.getYoubiInnerMessageKeyName(__youbi);
            String __css_field = CalendarViewUtils.getCssFieldByDate(items[i], i, __targetmonth);
            sb.append("<tr>").append(StringUtil.CR);
            sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-top:10px;padding-bottom:10px;\" ");
            sb.append("colspan=\"5\">").append(CalendarViewUtils.simpleFormat(items[i], locale));
            if (__youbi == 1) {
                sb.append("<span style=\"color:red\">");
            } else if (__youbi == 7) {
                sb.append("<span style=\"color:blue\">");
            } else {
                sb.append("<span>");
            }
            sb.append(JFCUtils.getRValue(__youbi_key, locale));
            sb.append("</span>").append(StringUtil.CR);
            if (isRokuyoFlag != null) {
                sb.append("<br/>").append(StringUtil.CR);
                sb.append(CalendarViewUtils.getRokuyoNode(items[i]));
            }
            if (StringUtils.isNotBlank((CharSequence)__insertUrl)) {
                sb.append("<a href=\"").append(__insertUrl).append("?action_New=&amp;targetdate=");
                sb.append(items[i].getDate());
                sb.append("\"><img src=\"img/pencil.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
            }
            sb.append("</td>").append(StringUtil.CR);
            sb.append("</tr>").append(StringUtil.CR);
            Calendaritem[] citems = items[i].getCalendaritem();
            if (citems == null) continue;
            ComparatorChain comp_hmt = new ComparatorChain();
            comp_hmt.addComparator((Comparator)new BeanComparator("starthour.id"));
            comp_hmt.addComparator((Comparator)new BeanComparator("startminute.id"));
            comp_hmt.addComparator((Comparator)new BeanComparator("title"));
            try {
                Arrays.sort(citems, comp_hmt);
            }
            catch (Exception e) {
                ArrayList<Calendaritem> citemlist_tmp = new ArrayList<Calendaritem>();
                ArrayList<Calendaritem> citemlist_notime = new ArrayList<Calendaritem>();
                for (Calendaritem citem : citems) {
                    if (citem.getStarthour() == null || citem.getStartminute() == null) {
                        citemlist_notime.add(citem);
                        continue;
                    }
                    citemlist_tmp.add(citem);
                }
                ComparatorChain comp_t = new ComparatorChain();
                comp_t.addComparator((Comparator)new BeanComparator("title"));
                try {
                    Collections.sort(citemlist_notime, comp_t);
                    Collections.sort(citemlist_tmp, comp_hmt);
                    citemlist_notime.addAll(citemlist_tmp);
                    citems = citemlist_notime.toArray(new Calendaritem[0]);
                }
                catch (Exception e1) {
                    try {
                        Arrays.sort(citems, comp_t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            for (int j = 0; j < citems.length; ++j) {
                String __url;
                String __primarykeyname = citems[j].getPrimarykeyname();
                Starthour _starthour = citems[j].getStarthour();
                Startminute _startminute = citems[j].getStartminute();
                Endhour _endhour = citems[j].getEndhour();
                Endminute _endminute = citems[j].getEndminute();
                sb.append("<tr>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" ");
                sb.append("style=\"text-align:right;padding-right:10px;padding-top:10px;padding-bottom:10px;\">");
                if (_starthour != null && _starthour.getId() >= 0) {
                    sb.append(_starthour.getContent()).append(":");
                    if (_startminute == null || _startminute.getId() == 0) {
                        sb.append("00");
                    } else {
                        sb.append(_startminute.getContent());
                    }
                }
                if (_endhour != null && _endhour.getId() >= 0) {
                    sb.append("..").append(_endhour.getContent());
                    if (_endminute == null || _endminute.getId() == 0) {
                        sb.append("00");
                    } else {
                        sb.append(_endminute.getContent());
                    }
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" ");
                sb.append("style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __title = citems[j].getTitle();
                if (__title != null && !__title.equals(__holiday)) {
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getUpdateurl())) {
                        __url = citems[j].getUpdateurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Update=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\"><img src=\"img/pencil_update.gif\" width=\"16\" border=\"0\"/></a>").append(StringUtil.CR);
                    }
                    if (StringUtils.isNotBlank((CharSequence)citems[j].getShowurl())) {
                        __url = citems[j].getShowurl() + "?" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                        sb.append("<a href=\"").append(__url).append("\">").append(StringEscapeUtils.escapeHtml4((String)__title)).append("</a>");
                    } else {
                        sb.append("<span>").append(StringEscapeUtils.escapeHtml4((String)__title)).append("</span>").append(StringUtil.CR);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)citems[j].getDeleteurl())) {
                    __url = citems[j].getDeleteurl() + "?sessionId=" + JFCUtils.getMD5Hash(session) + "&action_Send=&" + JFCUtils.createHTTPGetParameterForPrimaryKey(__primarykeyname, citems[j].getCalendarid());
                    sb.append("[ <a href=\"").append(__url).append("\" ");
                    sb.append("onClick=\"var ret = doConfirm(this, '");
                    sb.append(JFCUtils.getRValue("__jfc_common.link.button.Delete.confirm", locale));
                    sb.append("');return ret;\">x</a> ]").append(StringUtil.CR);
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __place = citems[j].getPlace();
                if (__place != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__place));
                }
                sb.append("</td>");
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __staff = citems[j].getStaff();
                if (__staff != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__staff));
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(__css_field).append("\" style=\"padding-left:8px;padding-top:10px;padding-bottom:10px;\">").append(StringUtil.CR);
                String __note = citems[j].getNote();
                if (__note != null) {
                    sb.append(StringEscapeUtils.escapeHtml4((String)__note));
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("</tr>").append(StringUtil.CR);
            }
        }
        sb.append("</table>").append(StringUtil.CR);
        return sb.toString();
    }

    private static String getRokuyoNode(Item item) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span class=\"jfcRokuyo\"").append(" data-date=\"").append(CalendarViewUtils.getISOFormattedDate(item)).append("\">").append("</span>").append(StringUtil.CR);
        return sb.toString();
    }

    private static String getISOFormattedDate(Item item) {
        StringBuilder sb = new StringBuilder();
        sb.append(CalendarViewUtils.getYearAsString(item)).append("-").append(CalendarViewUtils.getMonthAsString(item)).append("-").append(CalendarViewUtils.getDateAsString(item));
        return sb.toString();
    }
}

