/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbDeleteBaseController<E>
extends DbBaseController<E> {
    private static final Logger logger = LogManager.getLogger((String)DbDeleteBaseController.class.getName());

    @Override
    public String getScreenType() {
        return "delete";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), this.getStatus());
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null) {
            return CommandType.None;
        }
        if (p.action != null && p.action.startsWith("Send")) {
            return CommandType.DoDelete;
        }
        if (p.action != null && p.action.startsWith("Cancel")) {
            return CommandType.Cancel;
        }
        return CommandType.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String endLogMsg;
        String err_forward;
        String forward = null;
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        }
        this.setCommandToActionParameter(p);
        if (p.cmd == CommandType.UserDefined) {
            logger.info(this.getLogHeader(p));
            p.o = this.retrieveData(p);
            forward = this.do_original(p);
        } else if (p.cmd == CommandType.DoDelete) {
            Object[] ep;
            LockObject _lo;
            p.o = this.retrieveData(p);
            logger.info(this.getLogHeader(p, p.o.toString()));
            if (!super.isClientSessionIdValid(p)) {
                if (this.isNewLogon(p.request)) {
                    p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("error.session.expired.delete", p.locale));
                    return "logon.afterLogon";
                }
                logger.log(LogCodeManager.getPriority(LogCode.JFC00102), LogCodeManager.getMessage(LogCode.JFC00102, p.user, new String[0]));
                throw new SecurityException();
            }
            LockManager lman = LockManagerFactory.getLockManager(p);
            LockObject lo = this.createLockObject(p, lman);
            if (lo != null && (_lo = lman.addLockObject(lo)) != null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00069), LogCodeManager.getMessage(LogCode.JFC00069, p.user, lo.toString()));
                logger.debug("_lo (locked object) is " + _lo);
                lo = null;
                ep = new Object[]{_lo.getUsername()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.lock", ep, p.locale));
                forward = this.do_lockerror(p);
            }
            if (lo != null) {
                try {
                    forward = this.do_delete(p);
                }
                catch (SecurityException e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                    ep = new Object[]{e.getMessage()};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                }
                finally {
                    if (lo != null) {
                        lman.releaseLockObject(lo);
                        logger.debug(this.getLogHeader(p) + lo + " release lock.");
                    }
                }
            }
            logger.debug(this.getLogHeader(p) + "lman is " + lman);
        } else if (p.cmd == CommandType.Cancel || p.cmd == CommandType.ChangeSidebar) {
            logger.info(this.getLogHeader(p, p.action));
            p.o = this.retrieveData(p);
            forward = this.do_cancel(p);
        } else {
            String url;
            logger.info(this.getLogHeader(p, p.action));
            String forward1 = this.execExecuteMethod(p, null);
            forward = forward1 != null && forward1.equals("None") ? (url = p.request.getParameter("forward")) : forward1;
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if ((endLogMsg = this.endLog(p)) != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    public LockObject createLockObject(ActionParameter p, LockManager lman) {
        String modelname = this.registLockModel(p);
        Object primarykey = this.registLockPrimaryKey(p);
        if (modelname != null && primarykey != null) {
            String sessionid = p.request.getSession().getId();
            LockObject lo = lman.createLockObject(modelname, primarykey, sessionid, p);
            logger.debug(this.getLogHeader(p) + "lo is " + lo);
            return lo;
        }
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        }
        Object[] ep = new Object[]{username};
        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
        return null;
    }

    public String registLockModel(ActionParameter p) {
        return null;
    }

    public Object registLockPrimaryKey(ActionParameter p) {
        return null;
    }

    public String do_delete(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_cancel(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_lockerror(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    protected void getCommand_first_hook(ActionParameter p) {
    }

    protected void getCommand_finish_hook(ActionParameter p) {
    }

    protected void retrieveData_first_hook(ActionParameter p) {
    }

    protected void retrieveData_finish_hook(ActionParameter p) {
    }

    protected void registLockModel_first_hook(ActionParameter p) {
    }

    protected void registLockModel_finish_hook(StringBuilder sb, ActionParameter p) {
    }

    protected void registLockPrimaryKey_first_hook(ActionParameter p) {
    }

    protected void registLockPrimaryKey_finish_hook(Object ret, ActionParameter p) {
    }

    protected void do_nodata_first_hook(ActionParameter p) {
    }

    protected void do_nodata_finish_hook(ActionParameter p) {
    }

    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_delete_first_hook(ActionParameter p) {
    }

    protected void do_delete_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_delete_after_primarykey_hook(ActionParameter p) {
    }

    protected void do_delete_ready_pbean_hook(ActionParameter p) {
    }

    protected void do_delete_after_pbean_hook(ActionParameter p) {
    }

    protected void do_delete_finish_pbean_hook(ActionParameter p) {
    }

    protected void do_delete_before_pbean_error_hook(ActionParameter p) {
    }

    protected void do_delete_after_pbean_error_hook(ActionParameter p) {
    }

    protected void do_delete_finish_hook(ActionParameter p) {
    }

    protected void do_lockerror_first_hook(ActionParameter p) {
    }

    protected void do_lockerror_finish_hook(ActionParameter p) {
    }
}

