/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCHelperUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.core.util.PageLockUtils;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DbInsertBaseController<E>
extends DbBaseController<E> {
    private static final Logger logger = LogManager.getLogger((String)DbInsertBaseController.class.getName());

    @Override
    public String getScreenType() {
        String clazzName = StringUtil.lastToken((String)this.getClassname(), (String)".");
        if (clazzName != null && (clazzName.startsWith("Copy") || clazzName.startsWith("MyCopy"))) {
            return "copy";
        }
        return "insert";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public boolean isReleasePageLock(ActionParameter p) {
        return false;
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), this.getStatus());
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null) {
            return CommandType.None;
        }
        if (p.action != null && p.action.startsWith("New")) {
            return CommandType.BeginInsert;
        }
        if (p.action != null && p.action.startsWith("WizNext")) {
            return CommandType.Wizard_Next;
        }
        if (p.action != null && p.action.startsWith("WizPrev")) {
            return CommandType.Wizard_Prev;
        }
        if (p.action != null && p.action.startsWith("WizChange")) {
            return CommandType.Wizard_Change;
        }
        if (p.action != null && p.action.startsWith("WizInput")) {
            return CommandType.Wizard_Input;
        }
        if (p.action != null && p.action.startsWith("Send")) {
            return CommandType.DoInsert;
        }
        if (p.action != null && p.action.startsWith("BackInsert")) {
            return CommandType.BackInsert;
        }
        if (p.action != null && p.action.startsWith("Confirm")) {
            return CommandType.Confirm;
        }
        if (p.action != null && p.action.startsWith("Cancel")) {
            return CommandType.Cancel;
        }
        if (p.action != null && p.action.startsWith("Add")) {
            return CommandType.AddItem;
        }
        if (p.action != null && p.action.startsWith("Remove")) {
            return CommandType.RemoveItem;
        }
        if (p.action != null && p.action.startsWith("MoveUp")) {
            return CommandType.MoveUpItem;
        }
        if (p.action != null && p.action.startsWith("MoveDown")) {
            return CommandType.MoveDownItem;
        }
        if (p.action != null && p.action.startsWith("Sort")) {
            return CommandType.DoSort;
        }
        if (p.action != null && p.action.startsWith("Zipcode")) {
            return CommandType.Zipcode;
        }
        if (p.action != null && p.action.startsWith("GetXml")) {
            return CommandType.GetXml;
        }
        if (p.action != null && p.action.startsWith("FileUpload")) {
            return CommandType.FileUpload;
        }
        if (p.action != null && p.action.startsWith("Print")) {
            return CommandType.DoPrint;
        }
        if (p.action != null && p.action.startsWith("Next")) {
            return CommandType.Next;
        }
        if (p.action != null && p.action.startsWith("Prev")) {
            return CommandType.Prev;
        }
        if (p.action != null && p.action.startsWith("First")) {
            return CommandType.First;
        }
        if (p.action != null && p.action.startsWith("Last")) {
            return CommandType.Last;
        }
        if (p.action != null && p.action.startsWith("Jump")) {
            return CommandType.Jump;
        }
        if (p.action != null && p.action.startsWith("SizePerPage")) {
            return CommandType.ChangeSizePerPage;
        }
        if (p.action != null && (p.action.equals("") || p.action.startsWith("Clear") || p.action.equals("AllClear"))) {
            return CommandType.AsIs;
        }
        return CommandType.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String endLogMsg;
        String err_forward;
        String forward;
        block69: {
            forward = null;
            LogonStatusManager lsman = (LogonStatusManager)this.getApplicationContext().getBean("LogonStatusManager", LogonStatusManager.class);
            this.setCommandToActionParameter(p);
            JFCErrorManager errorManager = this.getJFCErrorManager();
            if ("juser".equals(this.getModelId()) && !lsman.isAccountAddable(p.user)) {
                p.errors.addJfcerror(errorManager.getJfcerror("error.limitover.max_account", p.locale));
                return "mainMenu";
            }
            boolean defaultIsReleaseLock = false;
            try {
                String url;
                String forward1;
                if (!lsman.checkInsertAvailable(p)) {
                    p.errors.addJfcerror(errorManager.getJfcerror("error.limitover_count_all_data", p.locale));
                    String string = "error_license";
                    return string;
                }
                if (p.cmd == CommandType.UserDefined) {
                    logger.info(this.getLogHeader(p, p.action));
                    p.o = this.retrieveData(p);
                    try {
                        forward1 = this.do_checkClientSessionId(p);
                        if (forward1 != null) {
                            String string = forward1;
                            return string;
                        }
                    }
                    catch (SecurityException e) {
                        defaultIsReleaseLock = true;
                        throw e;
                    }
                    forward = this.do_original(p);
                    if (forward == null && (forward = this.do_default(p)) == null) {
                        forward = url = p.request.getParameter("forward");
                    }
                    break block69;
                }
                if (p.cmd == CommandType.Masterref) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_masterref(p);
                    break block69;
                }
                if (p.cmd == CommandType.AddItem) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_addItem(p);
                    break block69;
                }
                if (p.cmd == CommandType.RemoveItem) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_removeItem(p);
                    break block69;
                }
                if (p.cmd == CommandType.MoveUpItem) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_moveUpItem(p);
                    break block69;
                }
                if (p.cmd == CommandType.MoveDownItem) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_moveDownItem(p);
                    break block69;
                }
                if (p.cmd == CommandType.DoSort) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_sortItem(p);
                    break block69;
                }
                if (p.cmd == CommandType.Zipcode) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_zipCode(p);
                    break block69;
                }
                if (p.cmd == CommandType.DoPrint) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    try {
                        forward = this.do_print(p);
                        break block69;
                    }
                    catch (BusinessLogicException e) {
                        if (this.isDeniedNullForward(p)) {
                            forward = this.getEmptyForward();
                        }
                        this.do_recover(p);
                        break block69;
                    }
                    catch (SecurityException e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                        this.do_recover(p);
                        throw e;
                    }
                    catch (Exception e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                        Object[] ep = new Object[]{e.getMessage()};
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                        this.do_recover(p);
                        break block69;
                    }
                }
                if (p.cmd == CommandType.Wizard_Input) {
                    logger.info(this.getLogHeader(p));
                    forward = this.do_wizread(p);
                    break block69;
                }
                if (p.cmd == CommandType.Wizard_Next) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_wizmove(p);
                    p.request.setAttribute("action", (Object)"WizInput");
                    break block69;
                }
                if (p.cmd == CommandType.Wizard_Prev) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_wizmove(p);
                    p.request.setAttribute("action", (Object)"WizInput");
                    break block69;
                }
                if (p.cmd == CommandType.Wizard_Change) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_wizmove(p);
                    p.request.setAttribute("action", (Object)"WizInput");
                    break block69;
                }
                if (p.cmd == CommandType.BeginInsert) {
                    logger.info(this.getLogHeader(p));
                    this.setWizardStatus(p, 1);
                    p.o = this.retrieveKey(p);
                    JFCHelperUtils.clearWarnedError(p);
                    this.deleteCookieHavingPrefix("__jfc_cookie_TabContainer_selectedTab_", p);
                    this.clearPreserveInitValue(p);
                    forward = this.do_read(p);
                    break block69;
                }
                if (p.cmd == CommandType.DoInsert || p.cmd == CommandType.Confirm || p.cmd == CommandType.BackInsert) {
                    String _forward;
                    Boolean isCallInsertJsonRest;
                    logger.info(this.getLogHeader(p));
                    Boolean isCallInsertRest = (Boolean)p.request.getAttribute("callInsertRest");
                    if (isCallInsertRest == null) {
                        isCallInsertRest = Boolean.FALSE;
                    }
                    if ((isCallInsertJsonRest = (Boolean)p.request.getAttribute("callInsertJsonRest")) == null) {
                        isCallInsertJsonRest = Boolean.FALSE;
                    }
                    if ((isCallInsertRest.booleanValue() || isCallInsertJsonRest.booleanValue()) && (_forward = this.setAppMapEntity(p)) != null) {
                        String string = _forward;
                        return string;
                    }
                    if (p.cmd == CommandType.BackInsert) {
                        JFCHelperUtils.clearWarnedError(p);
                    }
                    if (p.cmd == CommandType.DoInsert || p.cmd == CommandType.Confirm) {
                        p.o = this.retrieveData(p);
                    }
                    try {
                        String forward12 = this.do_checkClientSessionId(p);
                        if (forward12 != null) {
                            String string = forward12;
                            return string;
                        }
                    }
                    catch (SecurityException e) {
                        defaultIsReleaseLock = true;
                        throw e;
                    }
                    try {
                        forward = this.do_insert(p);
                        break block69;
                    }
                    catch (SecurityException e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                        defaultIsReleaseLock = true;
                        throw e;
                    }
                    catch (Exception e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                        Object[] ep = new Object[]{e.getMessage()};
                        p.errors.addJfcerror(errorManager.getJfcerror("error.parameter.invalid", ep, p.locale));
                        defaultIsReleaseLock = true;
                        break block69;
                    }
                    finally {
                        if (p.errors.sizeJfcerror() == 0) {
                            defaultIsReleaseLock = true;
                        } else if (forward != null && forward.startsWith("redirect:")) {
                            defaultIsReleaseLock = true;
                        }
                    }
                }
                if (p.cmd == CommandType.Cancel) {
                    logger.info(this.getLogHeader(p));
                    p.o = this.retrieveData(p);
                    forward = this.do_cancel(p);
                    defaultIsReleaseLock = true;
                } else if (p.cmd == CommandType.GetXml) {
                    logger.info(this.getLogHeader(p));
                    forward = this.do_getxml(p);
                } else if (p.cmd == CommandType.AsIs || p.cmd == CommandType.ChangeSidebar) {
                    logger.info(this.getLogHeader(p, p.action));
                    p.o = this.retrieveData(p);
                    forward = this.do_default(p);
                    if (forward == null) {
                        forward = url = p.request.getParameter("forward");
                    }
                } else if (p.cmd == CommandType.FileUpload) {
                    logger.info(this.getLogHeader(p, p.action));
                    forward = this.do_fileUpload(p);
                } else if (this.isPagingCommand(p)) {
                    p.o = this.retrieveData(p);
                    String data = p.o == null ? "null" : p.o.toString();
                    logger.info(this.getLogHeader(p, data));
                    this.perform_db_paging(p);
                    forward = this.do_default(p);
                } else {
                    logger.info(this.getLogHeader(p, p.action));
                    forward1 = this.execExecuteMethod(p, null);
                    if (forward1 != null && forward1.equals("None")) {
                        p.o = this.retrieveData(p);
                        forward = this.do_default(p);
                        if (forward == null) {
                            String url2;
                            forward = url2 = p.request.getParameter("forward");
                        }
                    } else {
                        forward = forward1;
                    }
                }
            }
            finally {
                this.perform_db_releaseLock(p, defaultIsReleaseLock);
            }
        }
        this.setFkeyFinderContextResultBeanWrapper(p);
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if ((endLogMsg = this.endLog(p)) != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    @Override
    protected String do_checkClientSessionId(ActionParameter p) {
        String ERRORMSG_NEW_LOGON = "error.session.expired.insert";
        return this.do_checkClientSessionId(p, "error.session.expired.insert");
    }

    protected boolean isPagingCommand(ActionParameter p) {
        return p.cmd == CommandType.Next || p.cmd == CommandType.Prev || p.cmd == CommandType.First || p.cmd == CommandType.Last || p.cmd == CommandType.Jump || p.cmd == CommandType.ChangeSizePerPage;
    }

    protected void perform_db_paging(ActionParameter p) {
        String _size_str;
        int size_per_page;
        String[] actionsp = p.action.split("_");
        if (actionsp.length < 3 || StringUtils.isBlank((CharSequence)actionsp[1]) || !actionsp[1].equals("fkey") || StringUtils.isBlank((CharSequence)actionsp[2])) {
            logger.warn("nothing modelid. p.action=" + p.action);
            return;
        }
        String childmodelid = actionsp[2];
        FinderContext<?> finderContext = this.getFkeyFinderContext(p, childmodelid);
        if (finderContext == null) {
            logger.warn("no exists model. p.action=" + p.action);
            return;
        }
        if (p.cmd == CommandType.Next) {
            if (finderContext.isNextPage()) {
                finderContext.next();
            }
        } else if (p.cmd == CommandType.Prev) {
            if (finderContext.isPrevPage()) {
                finderContext.prev();
            }
        } else if (p.cmd == CommandType.First) {
            finderContext.first();
        } else if (p.cmd == CommandType.Last) {
            finderContext.last();
        } else if (p.cmd == CommandType.Jump) {
            if (actionsp.length < 4 || StringUtils.isBlank((CharSequence)actionsp[3])) {
                logger.warn("nothing Jump page number. p.action=" + p.action);
                return;
            }
            int step = StringUtil.intValue((String)actionsp[3]);
            int denominator = finderContext.getPageSize() + 1;
            if (denominator > 0) {
                finderContext.setPageNumberWithCheck(step / finderContext.getPageSize() + 1);
            }
        } else if (p.cmd == CommandType.ChangeSizePerPage && (size_per_page = StringUtil.intValue((String)(_size_str = p.request.getParameter("__jfc_size_per_page")))) > 0) {
            finderContext.setPageSize(size_per_page);
            if (finderContext.getRowCount() > 0) {
                finderContext.first();
            }
        }
    }

    protected void setFkeyFinderContextResultBeanWrapper(ActionParameter p) {
        for (String fkeymodelid : this.getFkeyModelids(p)) {
            logger.debug("fkeymodelid " + fkeymodelid);
            FinderContext<?> finderContext = this.getFkeyFinderContext(p, fkeymodelid);
            p.request.setAttribute("jfc_result_fkey_" + fkeymodelid, (Object)new FinderContextResultBeanWrapper(finderContext));
        }
    }

    protected FinderContext<?> getFkeyFinderContext(ActionParameter p, String fkeymodelid) {
        return null;
    }

    protected String[] getFkeyModelids(ActionParameter p) {
        String[] modelids = new String[]{};
        return modelids;
    }

    protected String setAppMapEntity(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    public String do_fileUpload(ActionParameter p) throws IOException {
        FilenameList filenamelist;
        MultiPartForm multi = (MultiPartForm)p.request.getAttribute("__jfc_multi");
        if (multi != null && multi.isMultipartContent(p.request)) {
            filenamelist = (FilenameList)p.pageMap.get("__jfc_filenamelist");
            if (filenamelist == null) {
                filenamelist = FilenameList.create(this.getModelId());
                p.pageMap.put("__jfc_filenamelist", filenamelist);
            }
        } else {
            return null;
        }
        Map<String, Object[]> srcfilenamemap = filenamelist.addSendFilename(p, multi);
        p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
        if (p.errors.sizeJfcerror() > 0) {
            String msg = p.errors.getJfcerror(0).getContent();
            if (this.isRest(p.request)) {
                p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("message", msg);
                p.request.setAttribute(this.getClass() + "_jsonret", map);
            } else {
                p.response.sendError(500, msg);
            }
            return null;
        }
        if (this.isRest(p.request)) {
            p.request.setAttribute(this.getClass() + "_jsonret", filenamelist.getSrcFilenameJsonObj(srcfilenamemap.keySet()));
            return null;
        }
        p.response.setContentType("application/json");
        p.response.setCharacterEncoding("UTF-8");
        String jsonstr = filenamelist.getSrcFilenameJson(srcfilenamemap.keySet());
        p.response.getOutputStream().write(jsonstr.getBytes("UTF-8"));
        return null;
    }

    private void perform_db_releaseLock(ActionParameter p, boolean defaultIsReleaseLock) throws IOException, ServletException {
        Boolean isReleaseLock = (Boolean)p.request.getAttribute("isReleaseLock");
        if (isReleaseLock != null) {
            if (isReleaseLock.booleanValue()) {
                this.releaseLock(p);
            }
        } else if (defaultIsReleaseLock) {
            this.releaseLock(p);
        } else {
            String isReleaseLockParam = p.request.getParameter("JFCReleaseLock");
            if (isReleaseLockParam != null && Boolean.parseBoolean(isReleaseLockParam)) {
                this.releaseLock(p);
            }
        }
    }

    public void releaseLock(ActionParameter p) {
        PageLockUtils.releaseAll(p);
    }

    public String do_read(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_print(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_wizread(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_wizmove(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_insert(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_cancel(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_getxml(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        Enumeration em = p.request.getParameterNames();
        while (em.hasMoreElements()) {
            String _key = (String)em.nextElement();
            if (!"action_New".equals(_key)) continue;
            return true;
        }
        return false;
    }

    protected void updateTransaction(final ActionParameter p, final E entity) throws IOException, ServletException {
        TransactionTemplate requiredTransactionTemplate = this.getRequiredTransactionTemplate();
        if (requiredTransactionTemplate == null) {
            this.updateInTransaction(p, entity);
            return;
        }
        Exception ret = (Exception)requiredTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Exception>(){

            public Exception doInTransaction(TransactionStatus status) {
                try {
                    DbInsertBaseController.this.callScriptUpdateTransactionStart(p, status);
                    DbInsertBaseController.this.updateInTransaction(p, entity);
                    DbInsertBaseController.this.callScriptUpdateTransactionEnd(p, status);
                }
                catch (IOException e) {
                    status.setRollbackOnly();
                    return e;
                }
                catch (ServletException e) {
                    status.setRollbackOnly();
                    return e;
                }
                if (p.errors.sizeJfcerror() > 0) {
                    status.setRollbackOnly();
                }
                return null;
            }
        });
        if (ret != null) {
            if (ret instanceof IOException) {
                throw (IOException)ret;
            }
            if (ret instanceof ServletException) {
                throw (ServletException)((Object)ret);
            }
            logger.error("Unknown Exception " + ret, (Throwable)ret);
        }
    }

    protected void updateInTransaction(ActionParameter p, E entity) throws IOException, ServletException {
    }

    protected TransactionTemplate getRequiredTransactionTemplate() {
        return null;
    }

    protected void getCommand_first_hook(ActionParameter p) {
    }

    protected void getCommand_finish_hook(ActionParameter p) {
    }

    protected void retrieveData_first_hook(ActionParameter p) {
    }

    protected void retrieveData_finish_hook(ActionParameter p) {
    }

    protected void do_nodata_first_hook(ActionParameter p) {
    }

    protected void do_nodata_finish_hook(ActionParameter p) {
    }

    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_read_first_hook(ActionParameter p) {
    }

    protected void do_read_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_read_before_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_read_after_gettargetobj_hook(E entity, ActionParameter p) {
    }

    protected void do_read_before_initialize_hook(E entity, ActionParameter p) {
    }

    protected void do_read_after_initialize_hook(E entity, ActionParameter p) {
    }

    protected void do_read_before_s2p_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_read_after_s2p_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_read_before_setattribute_hook(E entity, ActionParameter p) {
    }

    protected void do_read_after_setattribute_hook(E entity, ActionParameter p) {
        new ScriptCodeRunner(this.getModelId()).process(this.getClass().getName(), "do_read_after_setattribute", p);
    }

    protected void do_read_finish_hook(E entity, ActionParameter p) {
    }

    protected void do_insert_first_hook(ActionParameter p) {
    }

    protected void do_insert_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_insert_before_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_insert_after_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_insert_before_filtering_hook(ActionParameter p) {
    }

    protected void do_insert_after_filtering_hook(ActionParameter p) {
    }

    protected void do_insert_before_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_insert_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_insert_before_inputcheck_hook(ActionParameter p) {
    }

    protected void do_insert_after_inputcheck_hook(ActionParameter p) {
    }

    protected void do_insert_before_inputcheck_all4wizard_hook(ActionParameter p) {
    }

    protected void do_insert_after_inputcheck_all4wizard_hook(ActionParameter p) {
    }

    protected void do_insert_before_duplicatecheck_hook(ActionParameter p) {
    }

    protected void do_insert_after_duplicatecheck_hook(ActionParameter p) {
    }

    protected void do_insert_ready_pbean_hook(ActionParameter p) {
    }

    protected void do_insert_after_pbean_hook(ActionParameter p) {
    }

    protected void do_insert_finish_pbean_hook(ActionParameter p) {
    }

    protected void do_insert_before_pbean_error_hook(ActionParameter p) {
    }

    protected void do_insert_after_pbean_error_hook(ActionParameter p) {
    }

    protected void do_insert_finish_hook(ActionParameter p) {
    }

    protected void do_cancel_first_hook(ActionParameter p) {
    }

    protected void do_cancel_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_cancel_before_filtering_hook(ActionParameter p) {
    }

    protected void do_cancel_after_filtering_hook(ActionParameter p) {
    }

    protected void do_cancel_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_cancel_after_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_cancel_finish_hook(ActionParameter p) {
    }

    protected void do_additem_first_hook(ActionParameter p) {
    }

    protected void do_additem_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_additem_before_filtering_hook(ActionParameter p) {
    }

    protected void do_additem_after_filtering_hook(ActionParameter p) {
    }

    protected void do_additem_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_additem_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_additem_before_itemproc_hook(ActionParameter p) {
    }

    protected void do_additem_after_itemproc_hook(ActionParameter p) {
    }

    protected void do_additem_before_calc_helper_hook(ActionParameter p) {
    }

    protected void do_additem_after_calc_helper_hook(ActionParameter p) {
    }

    protected void do_additem_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_additem_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_additem_finish_hook(ActionParameter p) {
    }

    protected void do_removeitem_first_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_removeitem_before_filtering_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_filtering_hook(ActionParameter p) {
    }

    protected void do_removeitem_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_removeitem_before_itemproc_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_itemproc_hook(ActionParameter p) {
    }

    protected void do_removeitem_before_calc_helper_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_calc_helper_hook(ActionParameter p) {
    }

    protected void do_removeitem_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_removeitem_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_removeitem_finish_hook(ActionParameter p) {
    }

    protected void do_zipCode_first_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_filtering_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_filtering_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_zipCode_before_calc_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_calc_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_inputcheck_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_inputcheck_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_zipsync_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_zipsync_hook(ActionParameter p) {
    }

    protected void do_zipCode_finish_hook(ActionParameter p) {
    }

    protected void do_default_first(ActionParameter p) {
    }

    protected void do_default_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_default_before_filtering_hook(ActionParameter p) {
    }

    protected void do_default_after_filtering_hook(ActionParameter p) {
    }

    protected void do_default_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_default_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_default_before_calc_helper_hook(ActionParameter p) {
    }

    protected void do_default_after_calc_helper_hook(ActionParameter p) {
    }

    protected void do_default_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_default_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_default_finish_hook(ActionParameter p) {
    }

    protected void do_getxml_first_hook(ActionParameter p) {
    }

    protected void do_getxml_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_getxml_before_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_getxml_after_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_getxml_before_filtering_hook(ActionParameter p) {
    }

    protected void do_getxml_after_filtering_hook(ActionParameter p) {
    }

    protected void do_getxml_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_getxml_after_p2s_helper_hook(E entity, ActionParameter p) {
    }

    protected void do_getxml_before_calc_helper_hook(ActionParameter p) {
    }

    protected void do_getxml_after_calc_helper_hook(ActionParameter p) {
    }

    protected void do_getxml_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_getxml_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_getxml_finish_hook(ActionParameter p) {
    }
}

