/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.controller.DbCursorBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbShowBaseController<E extends ContainerBase<E>, PK extends Serializable>
extends DbCursorBaseController<E, PK> {
    private static final Logger logger = LogManager.getLogger((String)DbShowBaseController.class.getName());

    @Override
    public String getScreenType() {
        return "show";
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.action.length() == 0 || p.referrer == null || p.referrer.length() == 0) {
            cmd = CommandType.DoShow;
        } else if (p.action != null && p.action.startsWith("Show")) {
            cmd = CommandType.DoShow;
        } else {
            if (p.action != null && p.action.startsWith("WizNext")) {
                return CommandType.Wizard_Next;
            }
            if (p.action != null && p.action.startsWith("WizPrev")) {
                return CommandType.Wizard_Prev;
            }
            if (p.action != null && p.action.startsWith("WizChange")) {
                return CommandType.Wizard_Change;
            }
            if (p.action != null && p.action.startsWith("JFCPrintScreen")) {
                cmd = CommandType.PrintScreen;
            } else if (p.action != null && p.action.startsWith("Print")) {
                cmd = CommandType.DoPrint;
            } else if (p.action != null && p.action.equals("ChangePreference")) {
                cmd = CommandType.ChangePreference;
            } else {
                if (p.action != null && p.action.startsWith("WizInput")) {
                    return CommandType.DoShow;
                }
                if (p.action != null && p.action.startsWith("Send")) {
                    return CommandType.DoShow;
                }
                if (p.action != null && p.action.startsWith("Next")) {
                    return CommandType.Next;
                }
                if (p.action != null && p.action.startsWith("Prev")) {
                    return CommandType.Prev;
                }
                if (p.action != null && p.action.startsWith("First")) {
                    return CommandType.First;
                }
                if (p.action != null && p.action.startsWith("Last")) {
                    return CommandType.Last;
                }
                if (p.action != null && p.action.startsWith("Jump")) {
                    return CommandType.Jump;
                }
                if (p.action != null && p.action.startsWith("SizePerPage")) {
                    return CommandType.ChangeSizePerPage;
                }
                cmd = p.action != null && p.action.startsWith("JFCSubWindowShow") ? CommandType.SubWindowShow : CommandType.DoShow;
            }
        }
        if (this.getExecuteMethod(p.action) != null) {
            return CommandType.None;
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String endLogMsg;
        String err_forward;
        String data;
        String forward = null;
        this.setCommandToActionParameter(p);
        if (p.cmd == CommandType.UserDefined) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            String forward1 = this.do_checkClientSessionId(p);
            if (forward1 != null) {
                return forward1;
            }
            forward = this.do_original(p);
        } else if (p.cmd == CommandType.DoShow) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            Enumeration em = p.request.getAttributeNames();
            ArrayList<String> removeKeyList = null;
            while (em.hasMoreElements()) {
                String reqkey = (String)em.nextElement();
                if (!reqkey.startsWith("__jfc_control.skipResolvForeignKey")) continue;
                if (removeKeyList == null) {
                    removeKeyList = new ArrayList<String>();
                }
                removeKeyList.add(reqkey);
            }
            if (removeKeyList != null) {
                for (String reqkey : removeKeyList) {
                    p.request.removeAttribute(reqkey);
                }
            }
            forward = this.do_show0(p);
        } else if (p.cmd == CommandType.PrintScreen) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            try {
                this.do_show0(p);
            }
            finally {
                forward = this.getForwardName("printScreen");
            }
        } else if (p.cmd == CommandType.ChangeSidebar || p.cmd == CommandType.ChangeFontSize) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            forward = this.do_show0(p);
        } else if (p.cmd == CommandType.ChangePreference) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            this.do_preference(p);
            forward = this.do_show0(p);
        } else if (this.isPagingCommand(p)) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            this.perform_db_paging(p);
            forward = this.do_show0(p);
        } else if (p.cmd == CommandType.DoPrint) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            try {
                forward = this.do_print(p);
            }
            catch (SecurityException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                this.do_recover(p);
                throw e;
            }
            catch (BusinessLogicException e) {
                logger.debug("occur BusinessLogicException", (Throwable)e);
                if (this.isDeniedNullForward(p)) {
                    forward = this.getEmptyForward();
                }
                this.do_recover(p);
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                Object[] ep = new Object[]{e.getMessage()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                if (this.isDeniedNullForward(p)) {
                    forward = this.getInputForward(p);
                }
                this.do_recover(p);
            }
        } else if (p.cmd == CommandType.Wizard_Next || p.cmd == CommandType.Wizard_Prev || p.cmd == CommandType.Wizard_Change) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            try {
                forward = this.do_wizmove(p);
                p.request.setAttribute("action", (Object)"WizInput");
            }
            catch (SecurityException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                this.do_recover(p);
                throw e;
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                Object[] ep = new Object[]{e.getMessage()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                this.do_recover(p);
            }
        } else if (p.cmd == CommandType.DoRestore) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            try {
                forward = this.do_restore(p);
            }
            catch (SecurityException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                this.do_recover(p);
                throw e;
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                Object[] ep = new Object[]{e.getMessage()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                this.do_recover(p);
            }
        } else if (p.cmd == CommandType.SubWindowShow) {
            p.o = this.retrieveData(p);
            data = p.o == null ? "null" : p.o.toString();
            logger.info(this.getLogHeader(p, data));
            try {
                forward = this.do_show0(p);
            }
            finally {
                forward = "noData".equals(forward) ? "system/subWindowNodata" : this.getForwardName("subWindowShow");
            }
        } else {
            String url;
            logger.info(this.getLogHeader(p, p.action));
            String forward1 = this.execExecuteMethod(p, null);
            forward = forward1 != null && forward1.equals("None") ? (url = p.request.getParameter("forward")) : forward1;
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if ((endLogMsg = this.endLog(p)) != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    protected boolean isPagingCommand(ActionParameter p) {
        return p.cmd == CommandType.Next || p.cmd == CommandType.Prev || p.cmd == CommandType.First || p.cmd == CommandType.Last || p.cmd == CommandType.Jump || p.cmd == CommandType.ChangeSizePerPage;
    }

    protected void perform_db_paging(ActionParameter p) {
        String _size_str;
        int size_per_page;
        FinderContext<?> finderContext;
        String[] actionsp = p.action.split("_", 3);
        if (actionsp.length < 3 || StringUtils.isBlank((CharSequence)actionsp[1]) || !actionsp[1].equals("fkey") || StringUtils.isBlank((CharSequence)actionsp[2])) {
            logger.warn("nothing modelid. p.action=" + p.action);
            return;
        }
        String childmodelid = actionsp[2];
        int step = 0;
        if (p.cmd == CommandType.Jump) {
            int stepscnt = childmodelid.lastIndexOf("_");
            if (stepscnt > 0 && childmodelid.length() <= stepscnt + 1) {
                logger.warn("nothing Jump page number. p.action=" + p.action);
                return;
            }
            String steps = childmodelid.substring(stepscnt + 1);
            step = StringUtil.intValue((String)steps);
            childmodelid = childmodelid.substring(0, stepscnt);
        }
        if ((finderContext = this.getFkeyFinderContext(p, childmodelid)) == null) {
            logger.warn("no exists model. p.action=" + p.action);
            return;
        }
        if (p.cmd == CommandType.Next) {
            if (finderContext.isNextPage()) {
                finderContext.next();
            }
        } else if (p.cmd == CommandType.Prev) {
            if (finderContext.isPrevPage()) {
                finderContext.prev();
            }
        } else if (p.cmd == CommandType.First) {
            finderContext.first();
        } else if (p.cmd == CommandType.Last) {
            finderContext.last();
        } else if (p.cmd == CommandType.Jump) {
            int denominator = finderContext.getPageSize() + 1;
            if (denominator > 0) {
                finderContext.setPageNumberWithCheck(step / finderContext.getPageSize() + 1);
            }
        } else if (p.cmd == CommandType.ChangeSizePerPage && (size_per_page = StringUtil.intValue((String)(_size_str = p.request.getParameter("__jfc_size_per_page")))) > 0) {
            finderContext.setPageSize(size_per_page);
            if (finderContext.getRowCount() > 0) {
                finderContext.first();
            }
        }
    }

    protected void setFkeyFinderContextResultBeanWrapper(ActionParameter p) {
        for (String fkeymodelid : this.getFkeyModelids(p)) {
            logger.debug("fkeymodelid " + fkeymodelid);
            FinderContext<?> finderContext = this.getFkeyFinderContext(p, fkeymodelid);
            p.request.setAttribute("jfc_result_fkey_" + fkeymodelid, (Object)new FinderContextResultBeanWrapper(finderContext));
        }
    }

    protected FinderContext<?> getFkeyFinderContext(ActionParameter p, String fkeymodelid) {
        return null;
    }

    protected String[] getFkeyModelids(ActionParameter p) {
        String[] modelids = new String[]{};
        return modelids;
    }

    protected String do_show0(ActionParameter p) throws IOException, ServletException {
        String forward = null;
        try {
            forward = this.do_show(p);
            Object _status = this.getStatus();
            if (((String)_status).startsWith("my")) {
                Object tmp = ((String)_status).substring(2);
                _status = tmp = ((String)tmp).substring(0, 1).toLowerCase() + ((String)tmp).substring(1);
            }
            HttpSession session = p.request.getSession();
            session.setAttribute("__jfc_latest_showAction_status", _status);
            this.setFkeyFinderContextResultBeanWrapper(p);
        }
        catch (SecurityException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
            this.do_recover(p);
            throw e;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
            Object[] ep = new Object[]{e.getMessage()};
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
            this.do_recover(p);
        }
        return forward;
    }

    public String do_show(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_print(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_restore(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public void do_preference(ActionParameter p) throws IOException, ServletException {
        String key = p.request.getParameter("action_ChangePreference");
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        Item item = p.user.getPreferenceItem(key);
        if (item == null) {
            p.user.setPreferenceItem(key, "true");
        } else {
            p.user.removePreferenceItem(item);
        }
    }

    public String getForwardName(String type) {
        return "";
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        Enumeration em = p.request.getParameterNames();
        while (em.hasMoreElements()) {
            String _key = (String)em.nextElement();
            if (!"action_ShowNext".equals(_key) && !"action_ShowPrev".equals(_key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void do_preprocess(ActionParameter p) {
        this.setResultStatus(p);
    }

    @Override
    public String getInputForward(ActionParameter p) throws IOException, ServletException {
        String s = p.request.getParameter("sw");
        if (StringUtils.isNotBlank((CharSequence)s) && Boolean.parseBoolean(s)) {
            return this.getForwardHeader() + ".input.sw";
        }
        return this.getForwardHeader() + ".input";
    }

    public void setSourceModelList(List<String> sourceModelList, ActionParameter p) {
        if (sourceModelList.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"source_model_list\">");
        String[] _ary = sourceModelList.toArray(new String[sourceModelList.size()]);
        Object path = this.getStatus();
        if (((String)path).startsWith("my")) {
            Object tmp = ((String)path).substring(2);
            path = tmp = ((String)tmp).substring(0, 1).toLowerCase() + ((String)tmp).substring(1);
        }
        for (int i = 0; i < _ary.length; ++i) {
            int size = 0;
            Object o = p.request.getAttribute(_ary[i] + "_lp_rev");
            if (o != null) {
                try {
                    Method[] methods;
                    Class<?> _clazz = o.getClass();
                    for (Method _m : methods = _clazz.getDeclaredMethods()) {
                        if (!_m.getName().equals("sizeItem")) continue;
                        Integer _result = (Integer)_m.invoke(o, new Object[0]);
                        size = _result;
                        break;
                    }
                }
                catch (Exception _clazz) {
                    // empty catch block
                }
            }
            String _key = "_sm_" + _ary[i];
            String _mkey = "__jfc_tablename." + StringUtil.capFirst((String)(_ary[i] + "ModelId"));
            sb.append("<a href=\"").append((String)path).append(".do?action_ChangePreference=");
            sb.append(_key).append("\">");
            if (size > 0) {
                sb.append("[-]");
            } else {
                sb.append("[+]");
            }
            sb.append("&nbsp;");
            sb.append(JFCUtils.getRValue(_mkey, p.locale));
            sb.append("</a>");
            if (i >= _ary.length - 1) continue;
            sb.append("|");
        }
        sb.append("</div>");
        p.request.setAttribute("__jfc_latest_showSourceModel_html", (Object)sb.toString());
    }

    protected void getCommand_first_hook(ActionParameter p) {
    }

    protected void getCommand_finish_hook(ActionParameter p) {
    }

    public void retrieveData_first_hook(ActionParameter p) {
    }

    public void retrieveData_finish_hook(ActionParameter p) {
    }

    protected void do_nodata_first_hook(ActionParameter p) {
    }

    protected void do_nodata_finish_hook(ActionParameter p) {
    }

    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_show_first_hook(ActionParameter p) {
    }

    protected void do_show_after_primarykey_hook(ActionParameter p) {
    }

    protected void do_show_ready_pbean_hook(ActionParameter p) {
    }

    protected void do_show_after_pbean_hook(ActionParameter p) {
    }

    protected void do_show_finish_pbean_hook(Object op, ActionParameter p) {
    }

    protected void do_show_before_setattribute_hook(E entity, ActionParameter p) {
    }

    protected void do_show_after_setattribute_hook(E entity, ActionParameter p) {
    }

    protected void do_show_finish_hook(E entity, ActionParameter p) {
    }
}

