/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.IJcalendarView;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.IcalendarLpHelper;
import jp.jasminesoft.jfc.app.JcalendarLpHelper;
import jp.jasminesoft.jfc.controller.CalendarViewUtils;
import jp.jasminesoft.jfc.controller.DbShowListBaseController;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.icalendar_l.IcalendarL;
import jp.jasminesoft.jfc.model.icalendar_lp.IcalendarLp;
import jp.jasminesoft.jfc.model.jcalendar_l.JcalendarL;
import jp.jasminesoft.jfc.model.jcalendar_lp.JcalendarLp;
import jp.jasminesoft.jfc.model.master.Master;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.HolidayManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DbShowListByJcalendarViewBaseController<E extends ContainerBase<E>, EC, PK extends Serializable>
extends DbShowListBaseController<E, EC, PK>
implements IJcalendarView {
    private static final Logger logger = LogManager.getLogger(DbShowListByJcalendarViewBaseController.class);

    @Override
    public String getScreenType() {
        return "showListCalendar";
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd == CommandType.Refresh) {
            return CommandType.Search;
        }
        return cmd;
    }

    @Override
    protected boolean isRecoverCondition(ActionParameter p) {
        if (!this.getStatus().equals(p.request.getAttribute("__jfc_screen_id"))) {
            return true;
        }
        return super.isRecoverCondition(p);
    }

    public String getUniqueDisplayTypeAttrName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatus());
        sb.append(".");
        sb.append("cal_disptype");
        return sb.toString();
    }

    public String getUniqueTargetDateAttrName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatus());
        sb.append(".");
        sb.append("cal_targetdate");
        return sb.toString();
    }

    public Master[] getSelectOption(ActionParameter p) {
        return null;
    }

    public boolean isValidHoliday() {
        return true;
    }

    public boolean isAvailableUseridFilter(ActionParameter p) {
        return false;
    }

    @Override
    public void do_setData(ActionParameter p) throws IOException, ServletException {
        this.before_do_setData(p);
        Object[] data = (Object[])p.request.getAttribute("data");
        HolidayManager hman = HolidayManager.getInstance();
        String disptype = (String)p.request.getAttribute("cal_disptype");
        String UniqueDisplayAttrName = this.getUniqueDisplayTypeAttrName();
        if (disptype == null) {
            disptype = "month";
        }
        p.appMap.put(UniqueDisplayAttrName, disptype);
        if (this.isSaveParamInUserPreferenceItem() && p.user != null) {
            p.user.setPreferenceItem(UniqueDisplayAttrName, disptype);
        }
        int field = 0;
        if ("month".equals(disptype) || "staffmonth".equals(disptype)) {
            field = 2;
        } else if ("week".equals(disptype) || "staffweek".equals(disptype)) {
            field = 4;
        } else if ("day".equals(disptype)) {
            field = 5;
        }
        Calendar cal = (Calendar)p.appMap.get(this.getUniqueTargetDateAttrName());
        if (cal == null) {
            cal = Calendar.getInstance();
            p.appMap.put(this.getUniqueTargetDateAttrName(), cal);
        }
        Calendar tcal = (Calendar)cal.clone();
        int _org_month = tcal.get(2);
        int day_of_week = tcal.get(7);
        if (field == 2 || field == 4) {
            tcal.add(5, -(day_of_week - 1));
            if (_org_month == tcal.get(2) && field == 2) {
                int _current_month;
                _org_month = tcal.get(2);
                while (_org_month == (_current_month = tcal.get(2)) && tcal.get(4) != 1) {
                    tcal.add(5, -7);
                }
            }
        }
        JcalendarL _list = new JcalendarL();
        IcalendarL _listi = new IcalendarL();
        boolean loop = true;
        int count = 1;
        int max = 0;
        switch (field) {
            case 2: {
                max = 35;
                break;
            }
            case 4: {
                max = 7;
                break;
            }
            case 5: {
                max = 1;
            }
        }
        boolean isICal = this.isICal(p.request);
        int targetmonth = -1;
        HashMap<String, Set<Object>> dateMap = new HashMap<String, Set<Object>>();
        jp.jasminesoft.jfc.model.icalendar_l.Item[] _items = null;
        if (!isICal) {
            this.createDateMap(data, dateMap);
        } else {
            _items = this.do_setIcalendarItem(0, 0, 0, data, p);
        }
        boolean isJholiday = false;
        for (String k : p.appMap.keySet()) {
            String _targetmodel;
            if (!k.endsWith("_c_preserve") || !(_targetmodel = k.substring(0, k.length() - "_c_preserve".length())).equals("jholiday")) continue;
            isJholiday = true;
            break;
        }
        while (loop) {
            int _year = tcal.get(1);
            int _month = tcal.get(2) + 1;
            int _day = tcal.get(5);
            logger.debug("loop " + _year + " " + _month + " " + _day + " " + count);
            if (count > max) {
                if (field == 2 && _month == targetmonth) {
                    max += 7;
                } else {
                    loop = false;
                    continue;
                }
            }
            if (field == 2) {
                if (tcal.get(5) == 1 && targetmonth == -1) {
                    targetmonth = _month;
                }
            } else if (targetmonth == -1) {
                targetmonth = _month;
            }
            if (!isICal) {
                if (!isJholiday && JFCUtils.isRestAPI(p)) {
                    this.setHolidayJcalendarItem(p, hman, tcal, _list, count);
                }
                this.setJcalendarItem(p, hman, tcal, _list, count, dateMap, _year, _month, _day);
            } else if (!isJholiday) {
                this.setHolidayIcalendarItem(p, hman, tcal, _listi, count);
            }
            tcal.add(5, 1);
            ++count;
        }
        if (!isICal) {
            this.setJcalendarLp(p, _list, targetmonth);
        } else {
            this.setIcalendarItem(p, _listi, count, _items);
            logger.debug("_listi " + _listi);
            logger.debug("_listi.size " + _listi.sizeItem());
            this.setIcalendarLp(p, _listi, targetmonth);
            logger.debug("_listi " + _listi);
            logger.debug("_listi.size " + _listi.sizeItem());
        }
        if (!isICal) {
            if ("month".equals(disptype)) {
                this.setMonthSchedule(p);
            } else if ("staffmonth".equals(disptype)) {
                this.setMonthScheduleByStaff(p);
            } else if ("week".equals(disptype)) {
                this.setWeekSchedule(p);
            } else if ("staffweek".equals(disptype)) {
                this.setWeekScheduleByStaff(p);
            } else if ("day".equals(disptype)) {
                this.setDaySchedule(p);
            }
        }
    }

    protected boolean isICal(HttpServletRequest request) {
        Boolean isICal = (Boolean)request.getAttribute("cal_isical");
        if (isICal == null) {
            return false;
        }
        return isICal;
    }

    private void setJcalendarLp(ActionParameter p, JcalendarL _list, int targetmonth) {
        Master[] code_m = this.getSelectOption(p);
        JcalendarLp _listp = JcalendarLpHelper.l2lp(_list, code_m, p);
        if (targetmonth > 0) {
            _listp.setTargetmonth(Integer.toString(targetmonth));
        }
        _listp.setShowlisturl(this.getShowlisturl(p));
        _listp.setInserturl(this.getInserturl(p));
        p.request.setAttribute("jcalendar_lp", (Object)_listp);
    }

    private void setJcalendarItem(ActionParameter p, HolidayManager hman, Calendar tcal, JcalendarL _list, int count, Map<String, Set<Object>> dateMap, int _year, int _month, int _day) {
        Object[] _data;
        jp.jasminesoft.jfc.model.jcalendar_l.Item[] _items;
        boolean setFlag = false;
        Set<Object> set = dateMap.get(JFCUtils.createDateMapKey(_year, _month, _day));
        if (set != null && set.size() > 0 && (_items = this.do_setJcalendarItem(_month, _day, _data = set.toArray(), p)) != null && _items.length > 0) {
            for (int k = 0; k < _items.length; ++k) {
                _items[k].setPosition(count);
                if (this.isValidHoliday() && hman.isPublicHoliday(tcal.getTime())) {
                    String title = hman.getPublicHolidayTitle(tcal.getTime());
                    _items[k].setHoliday(title);
                }
                _list.addItem(_items[k]);
            }
            setFlag = true;
        }
        if (JFCUtils.isRestAPI(p)) {
            return;
        }
        if (!setFlag) {
            jp.jasminesoft.jfc.model.jcalendar_l.Item _item = new jp.jasminesoft.jfc.model.jcalendar_l.Item();
            _item.setCalendarid("");
            _item.setDate(DateTimeUtil.getSQLDate((Date)tcal.getTime()));
            _item.setTitle("");
            _item.setStaff("");
            _item.setNote("");
            _item.setPlace("");
            _item.setPosition(count);
            if (hman.isPublicHoliday(tcal.getTime())) {
                String title = hman.getPublicHolidayTitle(tcal.getTime());
                _item.setHoliday(title);
            }
            _list.addItem(_item);
        }
    }

    private void setIcalendarLp(ActionParameter p, IcalendarL _list, int targetmonth) {
        Master[] code_m = this.getSelectOption(p);
        IcalendarLp _listp = IcalendarLpHelper.l2lp(_list, code_m, p);
        if (targetmonth > 0) {
            _listp.setTargetmonth(Integer.toString(targetmonth));
        }
        _listp.setShowlisturl(this.getShowlisturl(p));
        _listp.setInserturl(this.getInserturl(p));
        p.request.setAttribute("icalendar_lp", (Object)_listp);
    }

    private void setIcalendarItem(ActionParameter p, IcalendarL _list, int count, jp.jasminesoft.jfc.model.icalendar_l.Item[] _items) {
        if (_items != null && _items.length > 0) {
            for (int k = 0; k < _items.length; ++k) {
                _items[k].setPosition(count);
                _list.addItem(_items[k]);
            }
        }
    }

    private void setHolidayIcalendarItem(ActionParameter p, HolidayManager hman, Calendar tcal, IcalendarL _list, int count) {
        if (!hman.isPublicHoliday(tcal.getTime())) {
            return;
        }
        jp.jasminesoft.jfc.model.icalendar_l.Item _item = new jp.jasminesoft.jfc.model.icalendar_l.Item();
        _item.setCalendarid(Integer.toString(count));
        _item.setStart(DateTimeUtil.getSQLTimestamp((Date)tcal.getTime()));
        Calendar tcal2 = (Calendar)tcal.clone();
        tcal2.add(5, 1);
        _item.setEnd(DateTimeUtil.getSQLTimestamp((Date)tcal2.getTime()));
        _item.setStaff("");
        _item.setDescription("");
        _item.setLocation("");
        _item.setPosition(count);
        _item.setAllDay(1);
        _item.setModelid("jholiday");
        _item.setModelname("jholiday");
        _item.setCalendar(JFCUtils.getJholidayModernCalendarviewColor());
        String title = hman.getPublicHolidayTitle(tcal.getTime());
        _item.setHoliday(title);
        _item.setSummary(title);
        _list.addItem(_item);
    }

    private void setHolidayJcalendarItem(ActionParameter p, HolidayManager hman, Calendar tcal, JcalendarL _list, int count) {
        if (!hman.isPublicHoliday(tcal.getTime())) {
            return;
        }
        jp.jasminesoft.jfc.model.jcalendar_l.Item _item = new jp.jasminesoft.jfc.model.jcalendar_l.Item();
        _item.setCalendarid(Integer.toString(count));
        _item.setDate(DateTimeUtil.getSQLDate((Date)tcal.getTime()));
        _item.setStaff("");
        _item.setNote("");
        _item.setPlace("");
        _item.setPosition(count);
        _item.setModelid("jholiday");
        _item.setModelname("jholiday");
        String title = hman.getPublicHolidayTitle(tcal.getTime());
        _item.setHoliday(title);
        _item.setTitle(title);
        _list.addItem(_item);
    }

    @Override
    public boolean forceToSetData(ActionParameter p) {
        return true;
    }

    public void before_do_setData(ActionParameter p) throws IOException, ServletException {
    }

    public void createDateMap(Object[] data, Map map) {
    }

    public jp.jasminesoft.jfc.model.jcalendar_l.Item[] do_setJcalendarItem(int month, int day, Object[] data, ActionParameter p) {
        return null;
    }

    public jp.jasminesoft.jfc.model.icalendar_l.Item[] do_setIcalendarItem(int year, int month, int day, Object[] data, ActionParameter p) {
        return null;
    }

    public void after_do_setData(ActionParameter p) throws IOException, ServletException {
    }

    public abstract String getShowlisturl(ActionParameter var1);

    public String getInserturl(ActionParameter p) {
        return null;
    }

    public abstract void do_common(ActionParameter var1) throws IOException, ServletException;

    @Override
    public void do_recover(ActionParameter p) {
        try {
            this.do_common(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.request.setAttribute("jcalendar_lp", (Object)new JcalendarLp());
    }

    protected void setParameterForCalendar(ActionParameter p) {
        String UniqueTargetDateAttrName = (String)p.request.getAttribute("uniqueTargetDateAttrName");
        String UniqueDisplayTypeAttrName = this.getUniqueDisplayTypeAttrName();
        if (UniqueTargetDateAttrName == null) {
            return;
        }
        Calendar cal = (Calendar)p.appMap.get(UniqueTargetDateAttrName);
        if (cal == null) {
            cal = Calendar.getInstance();
            p.appMap.put(UniqueTargetDateAttrName, cal);
        }
        String disptype = null;
        if (p.action.equals("Search_Day")) {
            disptype = "day";
        } else if (p.action.equals("Search_Week")) {
            disptype = "week";
        } else if (p.action.equals("Search_Month")) {
            disptype = "month";
        } else if (p.action.equals("Search_StaffWeek")) {
            disptype = "staffweek";
        } else if (p.action.equals("Search_StaffMonth")) {
            disptype = "staffmonth";
        }
        if (disptype == null) {
            Item item;
            if (p.user != null && (item = p.user.getPreferenceItem(UniqueDisplayTypeAttrName)) != null) {
                disptype = item.getContent();
            }
            if (disptype == null) {
                disptype = (String)p.appMap.get(UniqueDisplayTypeAttrName);
            }
            if (disptype == null) {
                disptype = "month";
            }
        }
        p.request.setAttribute("cal_disptype", (Object)disptype);
        int field = 0;
        if ("month".equals(disptype) || "staffmonth".equals(disptype)) {
            field = 2;
        } else if ("week".equals(disptype) || "staffweek".equals(disptype)) {
            field = 4;
        } else if ("day".equals(disptype)) {
            field = 5;
        }
        p.appMap.put("cal_targetdate4init", null);
        String targetdate = (String)p.request.getAttribute("targetdate");
        if (targetdate != null && targetdate.length() > 0) {
            String[] pat = new String[]{"yyyy-MM-dd"};
            Date d = DateTimeUtil.getDateWithFormat((String)targetdate, (String[])pat);
            if (d != null) {
                Calendar date1cal = Calendar.getInstance();
                date1cal.setTime(d);
                Calendar initcal = Calendar.getInstance();
                initcal.setTime(date1cal.getTime());
                p.appMap.put("cal_targetdate4init", initcal);
                p.appMap.put(UniqueTargetDateAttrName, initcal);
                if (field == 2 || field == 4) {
                    date1cal.set(4, 1);
                    while (date1cal.get(7) != 1) {
                        date1cal.add(5, -1);
                    }
                }
                p.request.setAttribute("date1jshparam", (Object)DateTimeUtil.getSQLDate((Date)date1cal.getTime()));
                Calendar date2cal = Calendar.getInstance();
                date2cal.setTime(initcal.getTime());
                switch (field) {
                    case 4: {
                        date2cal.add(5, 7);
                        break;
                    }
                    case 5: {
                        date2cal.add(5, 1);
                    }
                }
                if (field == 2) {
                    date2cal.setTime(DateTimeUtil.getLastDayOfThisMonth((Date)date2cal.getTime()));
                    date2cal.add(5, 7);
                    while (date2cal.get(7) != 1) {
                        date2cal.add(5, -1);
                    }
                }
                p.request.setAttribute("date2jshparam", (Object)DateTimeUtil.getSQLDate((Date)date2cal.getTime()));
            }
        } else {
            int step = StringUtil.intValue((String)((String)p.request.getAttribute("__jfc_movestep")));
            if (field == 2) {
                String __jfc_targetyear = (String)p.request.getAttribute("__jfc_targetyear");
                String __jfc_targetmonth = (String)p.request.getAttribute("__jfc_targetmonth");
                if (__jfc_targetyear != null && __jfc_targetmonth != null) {
                    int __month;
                    int __year = StringUtil.intValue((String)__jfc_targetyear);
                    if (__year > 0) {
                        cal.set(1, __year);
                    }
                    if ((__month = StringUtil.intValue((String)__jfc_targetmonth) - 1) > 0) {
                        cal.set(2, __month);
                    }
                }
            }
            p.request.setAttribute("__jfc_movestep", (Object)Integer.toString(step));
            int moveaction = 0;
            if (p.action.equals("Search_Prev")) {
                moveaction = 1;
            } else if (p.action.equals("Search_Next")) {
                moveaction = 2;
            }
            if (moveaction == 2 || moveaction == 1) {
                int k = 1;
                if (moveaction == 1) {
                    k = -1;
                }
                switch (field) {
                    case 2: {
                        cal.add(2, step * k);
                        break;
                    }
                    case 4: {
                        cal.add(5, step * 7 * k);
                        break;
                    }
                    case 5: {
                        cal.add(5, step * k);
                    }
                }
            }
            Calendar ncal = Calendar.getInstance();
            ncal.setTime(cal.getTime());
            if ("day".equals(disptype)) {
                Calendar ncal0 = Calendar.getInstance();
                ncal0.setTime(ncal.getTime());
                p.appMap.put("cal_targetdate4init", ncal0);
            }
            if (field == 2) {
                ncal.set(4, 1);
                if (ncal.get(2) != cal.get(2)) {
                    ncal.set(7, 1);
                }
                if (ncal.get(2) == cal.get(2)) {
                    ncal.add(5, -7);
                }
            } else if (field == 4) {
                ncal.set(7, 1);
            }
            p.request.setAttribute("date1jshparam", (Object)DateTimeUtil.getSQLDate((Date)ncal.getTime()));
            if (field == 2) {
                ncal.setTime(cal.getTime());
            }
            switch (field) {
                case 2: {
                    ncal.add(2, 1);
                    break;
                }
                case 4: {
                    ncal.add(5, 6);
                    break;
                }
                case 5: {
                    ncal.add(5, 0);
                }
            }
            if (field == 2) {
                ncal.add(5, -1);
                if (field == 2) {
                    ncal.set(7, 1);
                    if (ncal.get(2) == cal.get(2)) {
                        ncal.add(5, 6);
                    } else {
                        int wom = ncal.get(4);
                        if (wom > 2) {
                            ncal.set(4, 2);
                        }
                    }
                }
            }
            p.request.setAttribute("date2jshparam", (Object)DateTimeUtil.getSQLDate((Date)ncal.getTime()));
        }
    }

    @Override
    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    @Override
    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_getSelectOption_first_hook(ActionParameter p) {
    }

    protected void do_getSelectOption_finish_hook(ActionParameter p) {
    }

    protected void do_setJcalendarItem_first_hook(ActionParameter p) {
    }

    protected void setMonthSchedule(ActionParameter p) {
        p.request.setAttribute("monthschedule", (Object)CalendarViewUtils.getMonthScheduleHTMLContent(p));
    }

    protected void setMonthScheduleByStaff(ActionParameter p) {
        p.request.setAttribute("monthschedulebystaff", (Object)CalendarViewUtils.getMonthScheduleByStaffHTMLContent(p));
    }

    protected void setWeekSchedule(ActionParameter p) {
        p.request.setAttribute("weekschedule", (Object)CalendarViewUtils.getWeekScheduleHTMLContent(p));
    }

    protected void setWeekScheduleByStaff(ActionParameter p) {
        p.request.setAttribute("weekschedulebystaff", (Object)CalendarViewUtils.getWeekScheduleByStaffHTMLContent(p));
    }

    protected void setDaySchedule(ActionParameter p) {
        p.request.setAttribute("dayschedule", (Object)CalendarViewUtils.getDayScheduleHTMLContent(p));
    }
}

