/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.jasminesoft.jfc.dao.FinderContext;

public class FinderContextResultBeanWrapper {
    private FinderContext<?> finderContext;

    FinderContextResultBeanWrapper(FinderContext<?> finderContext1) {
        this.finderContext = finderContext1;
    }

    private FinderContext<?> getFinderContext() {
        return this.finderContext;
    }

    public int getCurrent() {
        return this.getFinderContext().getFirstResult() + 1;
    }

    public int getSize() {
        if (!this.getFinderContext().isProcess()) {
            return -1;
        }
        return this.getFinderContext().getRowCount();
    }

    public int getNext() {
        return this.getFinderContext().getNext();
    }

    public boolean isPrevPage() {
        return this.getFinderContext().isPrevPage();
    }

    public boolean isNextPage() {
        return this.getFinderContext().isNextPage();
    }

    public int getPageSize() {
        return this.getFinderContext().getPageSize();
    }

    public List<PageInfo> getPageInfo() {
        int pagesize = this.getPageSize();
        if (pagesize <= 0) {
            return Arrays.asList(new PageInfo(1, 0, true));
        }
        int size = this.getSize();
        int current = this.getCurrent();
        int num = 1;
        int start = 0;
        int end = pagesize;
        ArrayList<PageInfo> list = new ArrayList<PageInfo>();
        do {
            boolean iscurrent = current >= start && current < end;
            PageInfo info = new PageInfo(num, start, iscurrent);
            list.add(info);
            ++num;
            end += pagesize;
        } while ((start += pagesize) < size);
        return list;
    }

    public List<PageInfo> getPageInfoWithCurrentRange(int before, int after) {
        int pagesize = this.getPageSize();
        if (pagesize <= 0) {
            return Arrays.asList(new PageInfo(1, 0, true));
        }
        int current = this.getCurrent();
        int currentPage = current / pagesize;
        if (currentPage < 0) {
            currentPage = 0;
        }
        int begin = currentPage - before;
        int end = currentPage + after;
        return this.getPageInfoWithRange(begin, end);
    }

    public List<PageInfo> getPageInfoWithRange(int beginPage, int endPage) {
        int lastPage;
        int pagesize = this.getPageSize();
        if (pagesize <= 0) {
            return Arrays.asList(new PageInfo(1, 0, true));
        }
        int size = this.getSize();
        int current = this.getCurrent();
        if (beginPage < 0) {
            beginPage = 0;
        }
        if (endPage > (lastPage = size / pagesize - 1 + (size % pagesize > 0 ? 1 : 0))) {
            endPage = lastPage;
        }
        int num = beginPage + 1;
        int start = beginPage * pagesize;
        int end = start + pagesize;
        ArrayList<PageInfo> list = new ArrayList<PageInfo>();
        do {
            boolean iscurrent = current >= start && current < end;
            PageInfo info = new PageInfo(num, start, iscurrent);
            list.add(info);
            start += pagesize;
            end += pagesize;
        } while (++num <= endPage + 1);
        return list;
    }

    public static class PageInfo {
        private int num;
        private int index;
        private boolean current;

        PageInfo(int num, int index, boolean current) {
            this.num = num;
            this.index = index;
            this.current = current;
        }

        public int getNum() {
            return this.num;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getCurrent() {
            return this.current;
        }
    }
}

