/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.model.preference.Item;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GridSettingController
extends DbBaseController<Object> {
    @RequestMapping(value={"/rest/jfcpref/gridsetting/{modelid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<? extends Object> getRest(@PathVariable(value="modelid") String modelid, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"GET");
        request.setAttribute("modelid", (Object)modelid);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        String content = (String)request.getAttribute("content");
        return GridSettingController.callRestJsonString(request, response, ret, content);
    }

    public static ResponseEntity<? extends Object> callRestJsonString(HttpServletRequest request, HttpServletResponse response, ResponseEntity<Map<String, Object>> ret, String content) throws IOException, ServletException {
        if (ret.getStatusCode() != HttpStatus.OK) {
            return ret;
        }
        if (content == null) {
            content = "{}";
        }
        HttpHeaders headers = ret.getHeaders();
        HttpHeaders newheaders = new HttpHeaders();
        for (String key : headers.keySet()) {
            newheaders.put(key, headers.get((Object)key));
        }
        newheaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        response.setContentType("application/json;charset=UTF-8");
        return new ResponseEntity((Object)content, (MultiValueMap)newheaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/jfcpref/gridsetting/{modelid}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> putRest(@PathVariable(value="modelid") String modelid, @RequestBody String content, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"PUT");
        request.setAttribute("modelid", (Object)modelid);
        request.setAttribute("content", (Object)content);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        return ret;
    }

    @RequestMapping(value={"/rest/jfcpref/gridsetting/{modelid}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> putRest(@PathVariable(value="modelid") String modelid, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"DELETE");
        request.setAttribute("modelid", (Object)modelid);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        return ret;
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public Permission getPermission() {
        return null;
    }

    public static String getPreferenceitemKey(String modelid) {
        return "jfcgridsetting_" + modelid;
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String modelid = (String)p.request.getAttribute("modelid");
        String key = GridSettingController.getPreferenceitemKey(modelid);
        Item item = p.user.getPreferenceItem(key);
        if (p.action.equals("GET")) {
            if (item != null) {
                p.request.setAttribute("content", (Object)item.getContent());
            }
        } else if (p.action.equals("PUT")) {
            String content = (String)p.request.getAttribute("content");
            if (content != null) {
                p.user.setPreferenceItem(key, content, "jfcpreferenceitem");
            }
        } else if (p.action.equals("DELETE") && item != null) {
            p.user.removePreferenceItem(item);
            p.request.setAttribute("content", null);
        }
        return this.getInputForward(p);
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        return false;
    }
}

