/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionUtils;
import jp.jasminesoft.jfc.menu.IMenuChoice;
import jp.jasminesoft.jfc.menu.Img;
import jp.jasminesoft.jfc.menu.Item;
import jp.jasminesoft.jfc.menu.Menu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.util.StringUtil;
import net.arnx.jsonic.JSON;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class MenuUtils {
    public static final Menu[] getAllMenu(Menubar menubar) {
        Menu[] menus;
        ArrayList<Menu> mlist = new ArrayList<Menu>();
        for (Menu menu : menus = menubar.getMenu()) {
            MenuUtils.getAllMenu(menu, mlist);
        }
        return mlist.toArray(new Menu[0]);
    }

    public static final String getAllMenuJSON(Menubar menubar) {
        return JSON.encode((Object)MenuUtils.getAllMenu(menubar));
    }

    private static final void getAllMenu(Menu menu, List<Menu> mlist) {
        IMenuChoice[] imcs;
        mlist.add(menu);
        for (IMenuChoice imc : imcs = menu.getContent()) {
            if (!(imc instanceof Menu)) continue;
            MenuUtils.getAllMenu((Menu)imc, mlist);
        }
    }

    public static final int getMenuIndex(Menu menu, Menu[] menus) {
        for (int i = 0; i < menus.length; ++i) {
            if (!menus[i].equals(menu)) continue;
            return i + 1;
        }
        return -1;
    }

    public static int getAncestorMenuIndex(Menu menu, Menu[] menus) {
        Menu parent = menu;
        while (true) {
            Menu _parent = MenuUtils.findParentMenu(parent, menus);
            if (MenuUtils.getMenuIndex(parent, menus) == MenuUtils.getMenuIndex(_parent, menus)) break;
            parent = _parent;
        }
        int index = MenuUtils.getMenuIndex(parent, menus);
        return index;
    }

    public static final Menu findParentMenu(Menu menu, Menu[] menus) {
        for (Menu menu0 : menus) {
            if (!MenuUtils.isContainsMenu(menu0, menu)) continue;
            return menu0;
        }
        return menu;
    }

    public static final boolean isContainsMenu(Menu menu0, Menu menu) {
        IMenuChoice[] imcs;
        boolean ret = false;
        IMenuChoice[] iMenuChoiceArray = imcs = menu0 != null ? menu0.getContent() : null;
        if (imcs != null && imcs.length > 0) {
            for (IMenuChoice imc : imcs) {
                Menu _menu;
                if (!(imc instanceof Menu) || !(_menu = (Menu)imc).equals(menu)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static final boolean isLeafMenu(Menu menu) {
        IMenuChoice[] imcs;
        boolean ret = true;
        for (IMenuChoice imc : imcs = menu.getContent()) {
            if (!(imc instanceof Menu)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static final IMenuChoice[] sortMenuOrder(IMenuChoice[] imc) {
        return MenuUtils.sortMenuOrder(imc, true);
    }

    public static final IMenuChoice[] sortMenuOrder(IMenuChoice[] imc, boolean isSortDesc) {
        ComparatorChain comp = new ComparatorChain();
        comp.addComparator((Comparator)new BeanComparator("order"));
        if (isSortDesc) {
            comp.addComparator((Comparator)new BeanComparator("desc"));
        }
        try {
            Arrays.sort(imc, comp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imc;
    }

    public static final String createChildMenuContents(Menu menu, Menu[] menus, boolean debug, String returnMsg) {
        StringBuilder childMenuContents = new StringBuilder();
        IMenuChoice[] imc = MenuUtils.sortMenuOrder(menu.getContent());
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Menu)) continue;
            Menu imenu = (Menu)imc[i];
            Menu _parent = MenuUtils.findParentMenu(imenu, menus);
            childMenuContents.append("<nav id=\"menuId").append(MenuUtils.getMenuIndex(imenu, menus));
            childMenuContents.append("\" class=\"menuContainer\" style=\"display: none;\">").append(StringUtil.CR);
            childMenuContents.append("<a href=\"#\" onClick=\"event.preventDefault();event.stopPropagation();showSubMenu('menuId").append(MenuUtils.getMenuIndex(_parent, menus)).append("',");
            childMenuContents.append(" 'menuId").append(MenuUtils.getMenuIndex(imenu, menus)).append("');removeSubMenuCookies();return false;\"");
            childMenuContents.append(MenuUtils.getTooltip(imenu));
            childMenuContents.append(" style=\"background: ").append(MenuUtils.getMenuColor(imenu)).append(";\">").append(StringUtil.CR);
            childMenuContents.append("<i class=\"").append(MenuUtils.getMenuIconClassValue("fas fa-arrow-alt-circle-up")).append("\"></i>").append(StringUtil.CR);
            childMenuContents.append("<div class=\"menuDescription\"");
            if (StringUtils.isNotBlank((CharSequence)imenu.getLabelcolor())) {
                childMenuContents.append(" style=\"color: ").append(imenu.getLabelcolor()).append(";\"");
            }
            childMenuContents.append(">").append(returnMsg).append("</div>").append(StringUtil.CR);
            childMenuContents.append("</a>").append(StringUtil.CR);
            childMenuContents.append(MenuUtils.createMenuContents(imenu, menus, null, debug));
            childMenuContents.append("</nav>").append(StringUtil.CR);
            if (MenuUtils.isLeafMenu(imenu)) continue;
            childMenuContents.append(MenuUtils.createChildMenuContents(imenu, menus, debug, returnMsg));
        }
        return childMenuContents.toString();
    }

    public static final String createMenuContents(Menu menu, Menu[] menus, ActionParameter p, boolean debug) {
        StringBuilder menuContents = new StringBuilder();
        IMenuChoice[] imc = MenuUtils.sortMenuOrder(menu.getContent());
        Img img = null;
        for (int i = 0; i < imc.length; ++i) {
            if (imc[i] instanceof Item) {
                Object url;
                Item item = (Item)imc[i];
                img = item.getImg();
                String desc = MenuUtils.replaceCRtoBRTag(item.getDesc());
                if (desc == null) {
                    desc = item.getName();
                }
                if (StringUtils.isBlank((CharSequence)(url = StringEscapeUtils.escapeHtml4((String)MenuUtils.replaceSpecialExpr(item.getUrl(), p != null ? p.request : null))))) {
                    url = "mainMenu.do?name=" + StringEscapeUtils.escapeHtml4((String)item.getName());
                }
                if (img == null) {
                    menuContents.append(MenuUtils.getIconMenuButton(item, (String)url, desc, MenuUtils.getMenuClickCode(item, (String)url)));
                    continue;
                }
                menuContents.append(MenuUtils.getImageMenuButton(desc, MenuUtils.getTooltip(item), MenuUtils.getMenuClickCode(item, (String)url), img));
                continue;
            }
            if (!(imc[i] instanceof Menu)) continue;
            Menu imenu = (Menu)imc[i];
            Menu _parent = MenuUtils.findParentMenu(imenu, menus);
            img = imenu.getImg();
            String title = MenuUtils.replaceCRtoBRTag(imenu.getTitle()) + "...";
            if (img == null) {
                menuContents.append(MenuUtils.getIconMenuButton(imenu, "#", title, MenuUtils.getLayerMenuClickCode(imenu, _parent, menus)));
                continue;
            }
            menuContents.append(MenuUtils.getImageMenuButton(title, MenuUtils.getTooltip(imenu), MenuUtils.getLayerMenuClickCode(imenu, _parent, menus), img));
        }
        return menuContents.toString();
    }

    public static String replaceSpecialExpr(String url, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        if (request == null || url.indexOf("${") < 0) {
            return url;
        }
        if (url.indexOf("${multisessionid}") >= 0) {
            String alias = MultipleSessionUtils.getCurrentSessionAlias(request);
            if (StringUtils.isBlank((CharSequence)alias) || "0".equals(alias)) {
                alias = "";
            }
            url = url.replace("${multisessionid}", alias).replace("//", "/");
        }
        return url;
    }

    public String createChildMenuContents(Menu menu, Menu[] menus) {
        StringBuilder childMenuContents = new StringBuilder();
        IMenuChoice[] imc = MenuUtils.sortMenuOrder(menu.getContent());
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Menu)) continue;
            Menu imenu = (Menu)imc[i];
            Menu _parent = MenuUtils.findParentMenu(imenu, menus);
            childMenuContents.append("<ul data-dojo-type=\"dojox/mobile/RoundRectList\">").append(StringUtil.CR);
            childMenuContents.append(MenuUtils.createMenuContents(imenu, menus));
            childMenuContents.append("</ul>").append(StringUtil.CR);
            if (MenuUtils.isLeafMenu(imenu)) continue;
            childMenuContents.append(this.createChildMenuContents(imenu, menus));
        }
        return childMenuContents.toString();
    }

    public static String createMenuContents(Menu menu, Menu[] menus) {
        StringBuilder menuContents = new StringBuilder();
        IMenuChoice[] imc = MenuUtils.sortMenuOrder(menu.getContent());
        for (int i = 0; i < imc.length; ++i) {
            menuContents.append("<li data-dojo-type=\"dojox/mobile/ListItem\"");
            if (imc[i] instanceof Item) {
                Item item = (Item)imc[i];
                Object url = StringEscapeUtils.escapeHtml4((String)item.getUrl());
                if (StringUtils.isBlank((CharSequence)url)) {
                    url = "mobileMenu.do?name=" + StringEscapeUtils.escapeHtml4((String)item.getName());
                }
                StringBuilder props = new StringBuilder();
                props.append("transition: 'slide'").append(", href: '").append((String)url).append("'");
                if ("_blank".equals(item.getTarget())) {
                    props.append(", hrefTarget: '").append(item.getTarget()).append("'");
                }
                menuContents.append(" data-dojo-props=\"").append(props.toString()).append("\">");
                String desc = item.getDesc();
                if (desc != null) {
                    menuContents.append(desc);
                } else {
                    menuContents.append(item.getName());
                }
            } else if (imc[i] instanceof Menu) {
                Menu imenu = (Menu)imc[i];
                menuContents.append("<a>");
                menuContents.append(imenu.getTitle());
            }
            menuContents.append("</li>").append(StringUtil.CR);
        }
        return menuContents.toString();
    }

    public static final String getIconMenuButton(IMenuChoice imc, String href, String label, String onClickCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href=\"").append(href).append("\" onClick=\"").append(onClickCode).append("\"");
        sb.append(MenuUtils.getTooltip(imc)).append(MenuUtils.getIconMenuStyle(imc)).append(">").append(StringUtil.CR);
        sb.append("<i class=\"").append(MenuUtils.getMenuIconClass(imc)).append("\"></i>").append(StringUtil.CR);
        sb.append("<div class=\"menuDescription\"").append(MenuUtils.getIconMenuFontColorStyle(imc)).append(">");
        sb.append(label).append("</div>").append(StringUtil.CR);
        sb.append("</a>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getImageMenuButton(String label, String tooltip, String onClickCode, Img img) {
        StringBuilder sb = new StringBuilder();
        sb.append("<button type=\"button\" class=\"menuButtonImage\" data-label=\"").append(label).append("\"");
        sb.append(tooltip).append(" onClick=\"").append(onClickCode).append("\">").append(StringUtil.CR);
        sb.append("<img src=\"").append(img.getSrc()).append("\" alt=\"").append(label).append("\"");
        if (StringUtils.isNotBlank((CharSequence)img.getStyle())) {
            sb.append(" style=\"").append(img.getStyle()).append("\"");
        }
        sb.append("/>").append(StringUtil.CR);
        sb.append("</button>").append(StringUtil.CR);
        return sb.toString();
    }

    public static final String getIconMenuStyle(IMenuChoice imc) {
        String bgColorStyle;
        StringBuilder style = new StringBuilder();
        String colorStyle = MenuUtils.getMenuFontColor(imc);
        if (StringUtils.isNotBlank((CharSequence)colorStyle)) {
            style.append(colorStyle);
        }
        if (StringUtils.isNotBlank((CharSequence)(bgColorStyle = MenuUtils.getMenuBackgroundColor(imc)))) {
            style.append(bgColorStyle);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" style=\"").append(style.toString()).append("\"");
        return sb.toString();
    }

    public static final String getIconMenuFontColorStyle(IMenuChoice imc) {
        String color = MenuUtils.getMenuFontColor(imc);
        if (StringUtils.isBlank((CharSequence)color)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" style=\"").append(color).append("\"");
        return sb.toString();
    }

    public static final String getMenuFontColor(IMenuChoice imc) {
        String color = imc.getLabelcolor();
        if (StringUtils.isBlank((CharSequence)color)) {
            return "";
        }
        return "color: " + color + ";";
    }

    public static final String getMenuBackgroundColor(IMenuChoice imc) {
        String color = MenuUtils.getMenuColor(imc);
        if (StringUtils.isBlank((CharSequence)color)) {
            return "";
        }
        return "background: " + color + ";";
    }

    public static final String getMenuColor(IMenuChoice imc) {
        String menuColor = imc.getColor();
        if (StringUtils.isBlank((CharSequence)menuColor)) {
            menuColor = imc instanceof Menu ? "#696969" : "#232B42";
        }
        return menuColor;
    }

    public static final String getMenuClickCode(Item item, String url) {
        StringBuilder sb = new StringBuilder();
        if (item.getTarget() != null && "_blank".equals(item.getTarget())) {
            sb.append(" window.open('").append(url).append("', '_blank', 'noopener');");
        } else {
            sb.append(" disablePankuzu(); if(clickedMenu) {return false;} clickedMenu=true;");
            sb.append(" location.href='").append(url).append("';");
        }
        sb.append(" return false;");
        return sb.toString();
    }

    public static final String getLayerMenuClickCode(Menu imenu, Menu _parent, Menu[] menus) {
        StringBuilder sb = new StringBuilder();
        sb.append("event.preventDefault();event.stopPropagation();showSubMenu('menuId").append(MenuUtils.getMenuIndex(imenu, menus)).append("',").append(" 'menuId").append(MenuUtils.getMenuIndex(_parent, menus)).append("');return false;");
        return sb.toString();
    }

    public static final String getMenuIconClass(IMenuChoice imc) {
        String iconClass = imc.getIconClass();
        if (StringUtils.isBlank((CharSequence)iconClass)) {
            iconClass = imc instanceof Menu ? "fas fa-folder" : "fas fa-cubes";
        }
        return MenuUtils.getMenuIconClassValue(iconClass);
    }

    public static final String getTooltip(IMenuChoice imc) {
        if (StringUtils.isBlank((CharSequence)imc.getTooltip())) {
            return "";
        }
        return " title=\"" + MenuUtils.replaceSpaceToCR(imc.getTooltip()) + "\"";
    }

    public static final String getMenuIconClassValue(String iconClass) {
        return iconClass + " fa-3x";
    }

    public static final String createDojoTabMenu(Menubar menubar, Menu[] menus, boolean debug, String returnMsg, ActionParameter p) {
        StringBuilder tabMenu = new StringBuilder();
        for (Menu menu : menubar.getMenu()) {
            tabMenu.append("<div data-dojo-type=\"dijit/layout/ContentPane\" id=\"menuTab");
            tabMenu.append(MenuUtils.getMenuIndex(menu, menus));
            tabMenu.append("\" style=\"background: hsla(210, 25%, 88%, 0.3);\" title=\"");
            tabMenu.append(menu.getTitle());
            if (debug) {
                tabMenu.append(menu.getOrder());
            }
            tabMenu.append("\">").append(StringUtil.CR);
            tabMenu.append("<nav id=\"menuId").append(MenuUtils.getMenuIndex(menu, menus)).append("\" class=\"menuContainer\">").append(StringUtil.CR).append(StringUtil.CR);
            tabMenu.append(MenuUtils.createMenuContents(menu, menus, p, debug)).append(StringUtil.CR);
            tabMenu.append("</nav>").append(StringUtil.CR);
            if (!MenuUtils.isLeafMenu(menu)) {
                tabMenu.append(MenuUtils.createChildMenuContents(menu, menus, debug, returnMsg));
            }
            tabMenu.append("</div>").append(StringUtil.CR);
        }
        return tabMenu.toString();
    }

    public static String createMobileMenu(Menubar menubar, Menu[] menus) {
        StringBuilder mobileMenu = new StringBuilder();
        for (Menu menu : menubar.getMenu()) {
            mobileMenu.append("<h2 data-dojo-type=\"dojox/mobile/RoundRectCategory\">").append(menu.getTitle()).append("</h2>");
            mobileMenu.append("<ul data-dojo-type=\"dojox/mobile/RoundRectList\">").append(StringUtil.CR);
            mobileMenu.append(MenuUtils.createMenuContents(menu, menus));
            mobileMenu.append("</ul>").append(StringUtil.CR);
        }
        return mobileMenu.toString();
    }

    public static final String replaceCRtoBRTag(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("\\r", "<br/>");
    }

    public static final String replaceSpaceToCR(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll(" ", "&#13;");
    }
}

