/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.IActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.controller.RestBaseController;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.dao.ReactAdminRestBaseCriteriaConverter;
import jp.jasminesoft.jfc.dao.SortKey;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.hibernate.AbstractWorkflowRestrictions;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.ObjectNotFoundException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class ReactAdminRestBaseController<E extends ContainerBase<E>, PK extends Serializable, RB extends RequestBodyBase<E>>
extends RestBaseController
implements IActionParameter {
    private static final Logger logger = LogManager.getLogger(ReactAdminRestBaseController.class);
    protected final String modelId;
    protected final EntityMeta<E> entityMeta;
    protected final EntityHelper<E, PK> entityHelper;
    protected final JFCEntityService<E, PK> entityService;

    public ReactAdminRestBaseController(EntityMeta<E> entityMeta, EntityHelper<E, PK> entityHelper, JFCEntityService<E, PK> entityService) {
        this.entityMeta = entityMeta;
        this.modelId = StoreModelUtils.getModelId(entityMeta.entityClass());
        this.entityHelper = entityHelper;
        this.entityService = entityService;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    public Object responseEntity(HttpServletRequest request, E entity) {
        if ("id".equals(this.entityMeta.primarykeyMeta()[0].column())) {
            return entity;
        }
        ActionParameter p = this.getActionParameterContainer().get();
        return new ReactAdminResponseEntity<E>(entity, this.entityHelper.getPrimarykeyAsString(entity, p));
    }

    public E detachEntity(RB requestBody, HttpServletRequest request) {
        ContainerBase entity = (ContainerBase)((RequestBodyBase)requestBody).getEntity();
        if (logger.isDebugEnabled()) {
            logger.debug("entity " + entity);
        }
        return (E)entity;
    }

    public boolean isErrorResponse(ResponseEntity<?> responseEntity) {
        return !responseEntity.getStatusCode().is2xxSuccessful() && !responseEntity.getStatusCode().is3xxRedirection();
    }

    public String getErrorMessage(ResponseEntity<Map<String, Object>> responseEntity) {
        Jfcerrors errors = (Jfcerrors)((Map)responseEntity.getBody()).get("errors");
        return this.getErrorMessage(errors);
    }

    @GetMapping
    public ResponseEntity<List<?>> getList(@RequestParam(name="_start", defaultValue="-1") int firstResult, @RequestParam(name="_end", defaultValue="-1") int endResult, @RequestParam(name="_sort", required=false) String sortKeys, @RequestParam(name="_order", required=false) String keyOrders, @RequestParam MultiValueMap<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        request.setAttribute("__jfc_screen_type", (Object)"showList");
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "showlist"), p);
        ReactAdminRestBaseCriteriaConverter<E> cc = new ReactAdminRestBaseCriteriaConverter<E>(this.entityMeta);
        cc.setActionParameterContainer(this.getActionParameterContainer());
        AbstractWorkflowRestrictions workflowRestrictions = (AbstractWorkflowRestrictions)this.applicationContext.getBean("WorkflowRestrictions", AbstractWorkflowRestrictions.class);
        cc.setWorkflowRestrictions(workflowRestrictions);
        cc.setConditionHelper(new ConditionHelper());
        FinderContext<MultiValueMap<String, String>> finderContext = new FinderContext<MultiValueMap<String, String>>();
        finderContext.setCriteriaConverter(cc);
        finderContext.setCondition(params);
        finderContext.setSortKey(this.getSortKey(sortKeys, keyOrders));
        finderContext.setFirstResult(firstResult);
        if (firstResult >= 0 && endResult >= 0 && endResult > firstResult) {
            finderContext.setPageSize(endResult - firstResult);
        }
        List data = this.entityService.find(finderContext).stream().map(data1 -> this.responseEntity(request, data1)).collect(Collectors.toList());
        logger.info(this.endLog(p));
        HttpHeaders header = new HttpHeaders();
        header.add("X-Total-Count", Integer.toString(finderContext.getRowCount()));
        return new ResponseEntity(data, (MultiValueMap)header, HttpStatus.OK);
    }

    protected SortKey getSortKey(String sKeys, String kOrders) {
        SortKey sortkey = new SortKey();
        if (StringUtils.isBlank((CharSequence)sKeys)) {
            return null;
        }
        String[] orders = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)kOrders)) {
            orders = kOrders.split(",");
        }
        String[] sortKeys = sKeys.split(",");
        for (int i = 0; i < sortKeys.length; ++i) {
            String key = null;
            try {
                key = this.entityMeta.propertyMeta(sortKeys[i]).name();
            }
            catch (IllegalArgumentException e) {
                if ("id".equals(sortKeys[i])) continue;
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
            if (orders.length > i && orders[i].equalsIgnoreCase("desc")) {
                sortkey.addKey(key);
                sortkey.addKey(key);
                continue;
            }
            sortkey.addKey(key);
        }
        return sortkey;
    }

    @GetMapping(params={"id"})
    public ResponseEntity<List<?>> getMany(@RequestParam(name="id") String id, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        this.checkPermission(new JFCAppPermission(this.modelId, "showlist"), p);
        ArrayList<Object> data = new ArrayList<Object>();
        String[] ids = id.split(",");
        HttpHeaders header = new HttpHeaders();
        for (String pkey : ids) {
            E entity;
            try {
                entity = this.entityService.findById(this.entityHelper.getPrimarykey(pkey));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            data.add(this.responseEntity(request, entity));
        }
        header.add("X-Total-Count", Integer.toString(data.size()));
        return new ResponseEntity(data, (MultiValueMap)header, HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> getOne(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) {
        ResponseEntity<Map<String, Object>> re = this.show(id, request, response);
        if (this.isErrorResponse(re)) {
            Map map = (Map)re.getBody();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity((Object)map, (MultiValueMap)re.getHeaders(), re.getStatusCode());
        }
        ContainerBase data = (ContainerBase)((Map)re.getBody()).get("entity");
        return new ResponseEntity(this.responseEntity(request, data), (MultiValueMap)re.getHeaders(), HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<Map<String, Object>> show(String pkey, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        request.setAttribute("__jfc_screen_type", (Object)"show");
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "select,update"), p);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", p.errors);
        HttpHeaders headers = new HttpHeaders();
        Object entity = null;
        String pkeyname = StoreModelUtils.primarykeyNames(this.modelId, p)[0];
        try {
            entity = this.entityService.findById(this.entityHelper.getPrimarykey(pkey));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String[][] params = new String[][]{{pkeyname, JFCUtils.getRValue(this.modelId + "." + pkeyname, p.locale)}};
            String errmsg = this.convertErrorMessage(e, params, p.locale);
            if (errmsg == null) {
                errmsg = "";
            }
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror(this.modelId + ".error.dbaccess", new Object[]{errmsg}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            logger.info(this.endLog(p));
        }
        map.put("entity", entity);
        map.put("pkey", pkey);
        if (entity == null) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.nodata", new Object[]{p.user.getUsername()}, p.locale));
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"_"})
    public ResponseEntity<?> init(HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "insert"), p);
        ContainerBase<E> entity = this.entityHelper.initialize(p);
        logger.info(this.endLog(p));
        HashMap<String, ContainerBase<E>> map = new HashMap<String, ContainerBase<E>>();
        map.put("entity", entity);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Object> raCreate(@RequestBody RB requestBody, HttpServletRequest request, HttpServletResponse response) {
        E entity = this.detachEntity(requestBody, request);
        ActionParameter p = this.createActionParameter(request, response);
        ResponseEntity<Map<String, Object>> re = this.create(p, entity, request, response);
        if (this.isErrorResponse(re)) {
            Map map = (Map)re.getBody();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity((Object)map, (MultiValueMap)re.getHeaders(), re.getStatusCode());
        }
        ContainerBase data = (ContainerBase)((Map)re.getBody()).get("entity");
        return new ResponseEntity(this.responseEntity(request, data), (MultiValueMap)re.getHeaders(), HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<Map<String, Object>> create(ActionParameter p, E entity, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        request.setAttribute("__jfc_screen_type", (Object)"insert");
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "insert"), p);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", p.errors);
        HttpHeaders headers = new HttpHeaders();
        String pkeyname = StoreModelUtils.primarykeyNames(this.modelId, p)[0];
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, (Object)Boolean.TRUE);
        this.entityHelper.calc(entity, p);
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, null);
        this.inputCheck(entity, p);
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        try {
            this.entityService.insert(entity);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String[][] params = new String[][]{{pkeyname, JFCUtils.getRValue(this.modelId + "." + pkeyname, p.locale)}};
            String errmsg = this.convertErrorMessage(e, params, p.locale);
            if (errmsg == null) {
                errmsg = "";
            }
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror(this.modelId + ".error.dbaccess.insert", new Object[]{errmsg}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            logger.info(this.endLog(p));
        }
        map.put("entity", entity);
        map.put("pkey", this.entityHelper.getPrimarykeyAsString(entity, p));
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    public void inputCheck(E entity, ActionParameter p) {
        this.callInputCheckScript(entity, p);
    }

    protected void callInputCheckScript(E entity, ActionParameter p) {
        HashMap<String, E> params = new HashMap<String, E>();
        params.put(this.modelId, entity);
        String inputCheckHelperClassName = StoreModelUtils.normalizeClassName(this.modelId) + "PInputCheckHelper";
        String status = new ScriptCodeRunner(this.modelId).process(inputCheckHelperClassName, "input_check", "process", params, p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            Jfcerror jfcerror = new Jfcerror();
            jfcerror.setContent(status);
            p.errors.addJfcerror(jfcerror);
        }
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<Object> raUpdate(@PathVariable(value="id") String id, @RequestBody RB requestBody, HttpServletRequest request, HttpServletResponse response) {
        E entity;
        ActionParameter p = this.createActionParameter(request, response);
        ResponseEntity<Map<String, Object>> re = this.update(p, id, entity = this.detachEntity(requestBody, request), request, response);
        if (this.isErrorResponse(re)) {
            Map map = (Map)re.getBody();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity((Object)map, (MultiValueMap)re.getHeaders(), re.getStatusCode());
        }
        ContainerBase data = (ContainerBase)((Map)re.getBody()).get("entity");
        return new ResponseEntity(this.responseEntity(request, data), (MultiValueMap)re.getHeaders(), HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<Map<String, Object>> update(ActionParameter p, String pkey, E entity, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        request.setAttribute("__jfc_screen_type", (Object)"update");
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "update"), p);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", p.errors);
        HttpHeaders headers = new HttpHeaders();
        String pkeyname = StoreModelUtils.primarykeyNames(this.modelId, p)[0];
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, (Object)Boolean.TRUE);
        this.entityHelper.calc(entity, p);
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, null);
        this.inputCheck(entity, p);
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        try {
            this.entityService.update(entity);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e);
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.nodata", new Object[]{p.user.getUsername()}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String[][] params = new String[][]{{pkeyname, JFCUtils.getRValue(this.modelId + "." + pkeyname, p.locale)}};
            String errmsg = this.convertErrorMessage(e, params, p.locale);
            if (errmsg == null) {
                errmsg = "";
            }
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror(this.modelId + ".error.dbaccess.update", new Object[]{errmsg}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            logger.info(this.endLog(p));
        }
        map.put("entity", entity);
        map.put("pkey", this.entityHelper.getPrimarykeyAsString(entity, p));
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> raDelete(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        ResponseEntity<Map<String, Object>> re = this.delete(p, id, request, response);
        if (this.isErrorResponse(re)) {
            Map map = (Map)re.getBody();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity((Object)map, (MultiValueMap)re.getHeaders(), re.getStatusCode());
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<Map<String, Object>> delete(ActionParameter p, String pkey, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        request.setAttribute("__jfc_screen_type", (Object)"delete");
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "delete"), p);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", p.errors);
        HttpHeaders headers = new HttpHeaders();
        String pkeyname = StoreModelUtils.primarykeyNames(this.modelId, p)[0];
        try {
            this.entityService.delete(this.entityHelper.getPrimarykey(pkey));
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e);
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.nodata", new Object[]{p.user.getUsername()}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String[][] params = new String[][]{{pkeyname, JFCUtils.getRValue(this.modelId + "." + pkeyname, p.locale)}};
            String errmsg = this.convertErrorMessage(e, params, p.locale);
            if (errmsg == null) {
                errmsg = "";
            }
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror(this.modelId + ".error.dbaccess.delete", new Object[]{errmsg}, p.locale));
            ResponseEntity responseEntity = new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            logger.info(this.endLog(p));
        }
        map.put("pkey", pkey);
        if (p.errors.sizeJfcerror() > 0) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @PutMapping(value={"_"}, consumes={"application/json"})
    public ResponseEntity<E> refresh(@RequestBody RB requestBody, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "insert,update"), p);
        E entity = this.detachEntity(requestBody, request);
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        request.setAttribute("__jfc_control.update_mode." + this.modelId, (Object)Boolean.TRUE);
        this.entityHelper.beforeShow(entity, p);
        logger.info(this.endLog(p));
        return new ResponseEntity(entity, HttpStatus.OK);
    }

    @GetMapping(value={"calc/{calcItemName}"})
    public ResponseEntity<Map<String, Object>> calc(@PathVariable(value="calcItemName") String calcItemName, @RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "insert,update"), p);
        ContainerBase<E> entity = this.entityHelper.initialize(p);
        params.entrySet().stream().forEach(e -> this.writeField(entity, (String)e.getKey(), (String)e.getValue()));
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, (Object)Boolean.TRUE);
        this.entityHelper.beforeShow(entity, p, new HashSet<String>(Arrays.asList(calcItemName)));
        logger.info(this.endLog(p));
        HashMap map = new HashMap();
        PropertyMeta propertyMeta = (PropertyMeta)this.entityMeta.propertyMeta(calcItemName);
        map.put(calcItemName, StoreModelUtils.getSingleValue(entity, propertyMeta, null));
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @GetMapping(value={"resolv/{relatedItemName}/{value}"})
    public ResponseEntity<E> resolv(@PathVariable(value="relatedItemName") String relatedItemName, @PathVariable(value="value") String value, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, "insert,update"), p);
        ContainerBase<E> entity = this.entityHelper.initialize(p);
        this.writeField(entity, relatedItemName, value);
        p.request.setAttribute("__jfc_control.update_mode." + this.modelId, (Object)Boolean.TRUE);
        this.entityHelper.beforeShow(entity, p, new HashSet<String>(Arrays.asList(relatedItemName)));
        logger.info(this.endLog(p));
        return new ResponseEntity(entity, HttpStatus.OK);
    }

    @GetMapping(value={"action/{actionName}/{id}"})
    public ResponseEntity<?> action(@PathVariable(value="actionName") String actionName, @PathVariable(value="id") String id, @RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        this.checkPermission(new JFCAppPermission(this.modelId, actionName), p);
        ResponseEntity<Map<String, Object>> re = this.show(id, request, response);
        if (this.isErrorResponse(re)) {
            Map map = (Map)re.getBody();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity((Object)map, (MultiValueMap)re.getHeaders(), re.getStatusCode());
        }
        ContainerBase entity = (ContainerBase)((Map)re.getBody()).get("entity");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.modelId, entity);
        map.put("requestParam", params);
        HashMap<String, Jfcerrors> responseMap = new HashMap<String, Jfcerrors>();
        responseMap.put("errors", p.errors);
        map.put("responseMap", responseMap);
        this.callCustomActionScript(actionName, map, p);
        if (p.errors.sizeJfcerror() > 0) {
            map.put("message", this.getErrorMessage(p.errors));
            return new ResponseEntity(map, (MultiValueMap)new HttpHeaders(), HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(map.get("responseMap"), HttpStatus.OK);
    }

    protected void callCustomActionScript(String actionName, Map<String, Object> params, ActionParameter p) {
        String scriptBaseName = StoreModelUtils.normalizeClassName(this.modelId) + "ReactAdminRestController";
        String status = new ScriptCodeRunner(this.modelId).process(scriptBaseName, actionName, "process", params, p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            Jfcerror jfcerror = new Jfcerror();
            jfcerror.setContent(status);
            p.errors.addJfcerror(jfcerror);
        }
    }

    @PostMapping(value={"list"}, consumes={"application/json"})
    public ResponseEntity<?> updatelist(@RequestBody RB[] requestBody, HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = this.createActionParameter(request, response);
        logger.info(this.startLog(p));
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            this.updateTransactionInUpdatelist(p, (RequestBodyBase[])requestBody, responseMap);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String pkeyname = StoreModelUtils.primarykeyNames(this.modelId, p)[0];
            String[][] params = new String[][]{{pkeyname, JFCUtils.getRValue(this.modelId + "." + pkeyname, p.locale)}};
            String errmsg = this.convertErrorMessage(e, params, p.locale);
            if (errmsg == null) {
                errmsg = "";
            }
            Jfcerror error = this.getJFCErrorManager().getJfcerror(this.modelId + ".error.dbaccess", new Object[]{errmsg}, p.locale);
            this.putErrorsUpdatelist(responseMap, error);
            return new ResponseEntity(responseMap, HttpStatus.BAD_REQUEST);
        }
        logger.info(this.endLog(p));
        return new ResponseEntity(responseMap, HttpStatus.OK);
    }

    protected void updateTransactionInUpdatelist(ActionParameter p, RB[] requestBody, Map<String, Object> map) throws IOException, ServletException {
        TransactionTemplate requiredTransactionTemplate = this.getRequiredTransactionTemplate();
        if (requiredTransactionTemplate == null) {
            logger.debug("requiredTransactionTemplate is null");
            this.updateInTransactionUpdatelist(p, (RequestBodyBase[])requestBody, map);
            return;
        }
        Exception ret = (Exception)requiredTransactionTemplate.execute(status -> {
            try {
                this.updateInTransactionUpdatelist(p, (RequestBodyBase[])requestBody, map);
            }
            catch (IOException e) {
                status.setRollbackOnly();
                return e;
            }
            catch (ServletException e) {
                status.setRollbackOnly();
                return e;
            }
            if (p.errors.sizeJfcerror() > 0) {
                status.setRollbackOnly();
            }
            return null;
        });
        if (ret != null) {
            if (ret instanceof IOException) {
                throw (IOException)ret;
            }
            if (ret instanceof ServletException) {
                throw (ServletException)((Object)ret);
            }
            logger.error("Unknown Exception " + ret, (Throwable)ret);
        }
    }

    protected void updateInTransactionUpdatelist(ActionParameter p, RB[] requestBody, Map<String, Object> map) throws IOException, ServletException {
        HttpServletRequest request = p.request;
        HttpServletResponse response = p.response;
        HashMap<String, List<Integer>> errormsgMap = new HashMap<String, List<Integer>>();
        ArrayList<Integer> successIndex = new ArrayList<Integer>();
        ArrayList<Integer> errorIndex = new ArrayList<Integer>();
        map.put("successIndex", successIndex);
        map.put("errorIndex", errorIndex);
        for (RB rb : requestBody) {
            ResponseEntity<Map<String, Object>> responseEntity;
            Jfcerror[] pkey;
            E entity = this.detachEntity(rb, request);
            String wbCRUDStatus = ((RequestBodyBase)rb).getWbCRUDStatus();
            Integer wbIndex = ((RequestBodyBase)rb).getWbIndex();
            if (wbIndex == null) {
                logger.warn("wbIndex is nothing, wbCRUDStatus " + wbCRUDStatus + ", ignored");
                continue;
            }
            if (entity == null) {
                logger.warn("wbIndex " + wbIndex + " wbCRUDStatus " + wbCRUDStatus + ", entity is null, ignored");
                continue;
            }
            if (wbCRUDStatus == null) {
                logger.warn("wbIndex " + wbIndex + ", wbCRUDStatus is nothing, ignored");
                continue;
            }
            if (wbCRUDStatus.equals("update")) {
                pkey = this.entityHelper.getPrimarykeyAsString(entity, p);
                responseEntity = this.update(p, (String)pkey, entity, request, response);
            } else if (wbCRUDStatus.equals("insert")) {
                responseEntity = this.create(p, entity, request, response);
            } else if (wbCRUDStatus.equals("delete")) {
                pkey = this.entityHelper.getPrimarykeyAsString(entity, p);
                responseEntity = this.delete(p, (String)pkey, request, response);
            } else {
                logger.warn("wbIndex " + wbIndex + ", wbCRUDStatus is illegal value " + wbCRUDStatus + ", ignored");
                continue;
            }
            if (!this.isErrorResponse(responseEntity)) {
                successIndex.add(wbIndex);
            } else {
                errorIndex.add(wbIndex);
                if (logger.isDebugEnabled()) {
                    logger.debug("p.errors " + p.errors);
                }
                for (Jfcerror jfcerror : p.errors.getJfcerror()) {
                    ArrayList<Integer> indexes = (ArrayList<Integer>)errormsgMap.get(jfcerror.getContent());
                    if (indexes == null) {
                        indexes = new ArrayList<Integer>();
                        errormsgMap.put(jfcerror.getContent(), indexes);
                    }
                    indexes.add(wbIndex);
                }
            }
            Enumeration enu = p.request.getAttributeNames();
            while (enu.hasMoreElements()) {
                p.request.removeAttribute((String)enu.nextElement());
            }
            p.errors = new Jfcerrors();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("successIndex " + successIndex);
            logger.debug("errorIndex " + errorIndex);
            logger.debug("errormsgMap " + errormsgMap);
        }
        if (errorIndex.size() > 0) {
            map.put("errors", this.getErrorsUpdatelist(errormsgMap));
            throw new IOException();
        }
    }

    private void putErrorsUpdatelist(Map<String, Object> responseMap, Jfcerror error) {
        ArrayList errors;
        responseMap.put("successIndex", Collections.emptyList());
        List errorIndex = (List)responseMap.get("errorIndex");
        if (errorIndex == null) {
            responseMap.put("errorIndex", Collections.emptyList());
        }
        if ((errors = (ArrayList)responseMap.get("errors")) == null) {
            errors = new ArrayList();
            responseMap.put("errors", errors);
        }
        HashMap<String, Object> errmsg = new HashMap<String, Object>();
        errmsg.put("message", error.getContent());
        errmsg.put("wbIndex", Collections.emptyList());
        errors.add(errmsg);
    }

    protected List<Map<String, Object>> getErrorsUpdatelist(Map<String, List<Integer>> errormsgMap) {
        ArrayList<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, List<Integer>> e : errormsgMap.entrySet()) {
            HashMap<String, Object> errmsg = new HashMap<String, Object>();
            errmsg.put("message", e.getKey());
            errmsg.put("wbIndex", e.getValue());
            errors.add(errmsg);
        }
        return errors;
    }

    protected TransactionTemplate getRequiredTransactionTemplate() {
        return null;
    }

    protected void writeField(E entity, String itemName, String value) {
        PropertyMetaBase<?> meta = this.entityMeta.propertyMeta(itemName);
        ReflectionUtils.setPrivateField(entity, meta.name(), this.convert(value, meta.getTypeClass()));
    }

    private <T> T convert(String value, Class<T> typeClass) {
        if (String.class.isAssignableFrom(typeClass)) {
            return (T)value;
        }
        if (Byte.class.isAssignableFrom(typeClass)) {
            return (T)Byte.valueOf(NumberUtils.toByte((String)value));
        }
        if (Short.class.isAssignableFrom(typeClass)) {
            return (T)Short.valueOf(NumberUtils.toShort((String)value));
        }
        if (Integer.class.isAssignableFrom(typeClass)) {
            return (T)Integer.valueOf(NumberUtils.toInt((String)value));
        }
        if (Long.class.isAssignableFrom(typeClass)) {
            return (T)Long.valueOf(NumberUtils.toLong((String)value));
        }
        if (Float.class.isAssignableFrom(typeClass)) {
            return (T)Float.valueOf(NumberUtils.toFloat((String)value));
        }
        if (Double.class.isAssignableFrom(typeClass)) {
            return (T)Double.valueOf(NumberUtils.toDouble((String)value));
        }
        if (Date.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLDate((String)value);
        }
        if (Time.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLTime((String)value);
        }
        if (Timestamp.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLTimestamp((String)value);
        }
        throw new IllegalStateException();
    }

    public static class ReactAdminResponseEntity<T extends ContainerBase<T>> {
        @JsonUnwrapped
        private T entity;
        private String id;

        public ReactAdminResponseEntity(T entity, String id) {
            this.entity = entity;
            this.id = id;
        }

        public T getEntity() {
            return this.entity;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class RequestBodyBase<E> {
        private E entity;
        private Map<String, Object> kvs = new HashMap<String, Object>();
        private String wbCRUDStatus;
        private Integer wbIndex;

        @JsonUnwrapped
        public void setEntity(E entity) {
            this.entity = entity;
        }

        @JsonUnwrapped
        public E getEntity() {
            return this.entity;
        }

        @JsonAnySetter
        public void put(String key, Object value) {
            this.kvs.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, Object> getEntries() {
            return this.kvs;
        }

        @JsonProperty(value="wbCRUDStatus")
        public String getWbCRUDStatus() {
            return this.wbCRUDStatus;
        }

        @JsonProperty(value="wbCRUDStatus")
        public void setWbCRUDStatus(String wbCRUDStatus) {
            this.wbCRUDStatus = wbCRUDStatus;
        }

        @JsonProperty(value="wbIndex")
        public Integer getWbIndex() {
            return this.wbIndex;
        }

        @JsonProperty(value="wbIndex")
        public void setWbIndex(Integer wbIndex) {
            this.wbIndex = wbIndex;
        }
    }
}

