/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatus;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcinfo;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ReleaseLogonUserController
extends BaseController {
    public static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final Logger logger = LogManager.getLogger(ReleaseLogonUserController.class);
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public String getForwardHeader() {
        return "releaseLogonUser";
    }

    @Override
    @RequestMapping(value={"/releaseLogonUser.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.releaseLogonUser";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "releaseLogonUser");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("juser", "releaseLogonUser");
    }

    @Override
    public String perform0(ActionParameter p) throws IOException, ServletException {
        if (p.user == null) {
            return this.getErrorForward(p);
        }
        LogonStatusManager LSMAN = (LogonStatusManager)this.applicationContext.getBean(LogonStatusManager.class);
        LogonStatus[] users = LSMAN.getCurrentLogonUsers();
        String userName = p.request.getParameter("userName");
        String sessionId = p.request.getParameter("sessionId");
        String machinename = p.request.getParameter("machinename");
        boolean isCluster = ClusterManagerFactory.getClusterManager().getUseCluster();
        if (users == null) {
            logger.debug(this.getLogHeader(p, "No users is found. "));
            return this.getInputForward(p);
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC90015), LogCodeManager.getMessage(LogCode.JFC90015, p.user, String.valueOf(users.length)));
        String tmpName = null;
        String tmpSessionId = null;
        String tmpMachinename = null;
        String oldUserId = null;
        for (int i = 0; i < users.length; ++i) {
            tmpName = users[i].getUsername();
            tmpSessionId = StringUtil.getMD5Hash((String)users[i].getSessionId());
            tmpMachinename = users[i].getMachinename();
            if (!tmpName.equals(userName) || !tmpSessionId.equals(sessionId) || isCluster && !tmpMachinename.equals(machinename)) continue;
            LSMAN.releaseUserObject(tmpName, users[i].getSessionId(), machinename);
            oldUserId = userName;
            break;
        }
        if (oldUserId != null && oldUserId.trim().length() > 0) {
            String msg = JFCUtils.getRValue("__jfc_common.text.success.releaseLogon", oldUserId, p.locale);
            Jfcinfo info = new Jfcinfo();
            info.setContent(msg);
            p.errors.addJfcinfo(info);
        } else {
            String msg = JFCUtils.getRValue("__jfc_common.text.fail.releaseLogon", p.locale);
            Jfcerror error = new Jfcerror();
            error.setContent(msg);
            p.errors.addJfcerror(error);
        }
        return "redirect:showListLogonUsers.do";
    }
}

