/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.servlet.GoogleOAuth2Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class WebAPIController
extends DbBaseController<Object> {
    private static final Logger LOGGER = LogManager.getLogger(WebAPIController.class);

    @Override
    public String getForwardHeader() {
        return "webapi";
    }

    @Override
    @RequestMapping(value={"/webapi.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.webapi";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "webapi");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("webapi", "all");
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        this.processOAuth2(p);
        return this.getInputForward(p);
    }

    private void processOAuth2(ActionParameter p) {
        Object TokenResponseException;
        GoogleOAuth2Util util = (GoogleOAuth2Util)p.appctx.getBean(GoogleOAuth2Util.class);
        String action = p.request.getParameter("action");
        if (action != null && action.equals("deleteCredential")) {
            util.deleteCredential();
        }
        if ((TokenResponseException = p.request.getSession().getAttribute("GoogleAuthorizationCodeCallbackServlet.TokenResponseException")) != null) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.GoogleOAuth2Util.TokenResponseException", p.locale));
        }
        this.setUserInfo(p, util);
        String authorizePageUrl = util.getRedirectUri(p.request, "/AcceptGMailToken.do");
        p.request.setAttribute("_gmail_authorizePageUrl", (Object)authorizePageUrl);
        String webapiUrl = util.getWebapiRedirectUri(p.request);
        p.request.setAttribute("webapiUrl", (Object)webapiUrl);
    }

    private void setUserInfo(ActionParameter p, GoogleOAuth2Util util) {
        try {
            p.request.setAttribute("info", util.getCredentialInfo());
        }
        catch (GoogleOAuth2Util.GoogleOAuth2Exception e) {
            LOGGER.info("occur exception " + e.getClass().getName() + " : " + e.getMessage());
            LOGGER.debug("occur exception", (Throwable)e);
            String jfcerrorkey = e.getMessage();
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror(jfcerrorkey, p.locale));
            if (jfcerrorkey.equals("error.GoogleOAuth2Util.cannot_read_clientsecret")) {
                p.request.setAttribute("disable_authorize_page_button", (Object)Boolean.TRUE);
            }
            p.request.setAttribute("disable_authorize_page_button", (Object)Boolean.FALSE);
        }
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        return true;
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }
}

