/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.util.address.AddressResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class ZipcodeToAddressController {
    private static Logger LOGGER = LogManager.getLogger((String)ZipcodeToAddressController.class.getName());
    private AddressResolver resolver;

    @GetMapping(value={"/zipcode/{zipcode}"})
    public ResponseEntity<List<Map<String, String>>> getAddressFromZipcode(@PathVariable(value="zipcode", required=true) String zipcode, HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        ArrayList results = new ArrayList();
        if (!AddressResolver.isValid()) {
            LOGGER.warn("AddressResolver is not ready.");
            return new ResponseEntity(results, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (this.resolver == null) {
            this.resolver = AddressResolver.getInstance();
        }
        boolean haveHyphen = false;
        String findZipcode = zipcode;
        if (zipcode.indexOf("-") >= 0) {
            findZipcode = zipcode.replaceAll("-", "");
            haveHyphen = true;
        }
        if (!this.resolver.isValidZipcode(findZipcode)) {
            LOGGER.info("Zip-code [" + zipcode + "] is invalid.");
            return new ResponseEntity(results, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        String[] candidates = this.resolver.findAddressByZipcode(findZipcode);
        if (candidates == null || candidates.length < 1) {
            LOGGER.info("Zip-code [" + zipcode + "] is not matched with any records.");
            LinkedHashMap<String, String> empty = new LinkedHashMap<String, String>();
            empty.put("ZIPCODE", zipcode);
            empty.put("ADDRESS", "");
            results.add(empty);
            return new ResponseEntity(results, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        if (candidates.length == 1) {
            LOGGER.info("Zip-code [" + zipcode + "] exactly matched with [" + candidates[0] + "].");
            LinkedHashMap<String, String> onepair = new LinkedHashMap<String, String>();
            onepair.put("ZIPCODE", zipcode);
            onepair.put("ADDRESS", candidates[0]);
            results.add(onepair);
        } else {
            LOGGER.info("Zip-code [" + zipcode + "] found " + candidates.length + " candidate address.");
            for (String cand : candidates) {
                String[] kv = cand.split(" ");
                if (kv.length != 2) {
                    LOGGER.error("The record format is not valid [" + cand + "] => Ignored.");
                    continue;
                }
                Object zip = kv[0];
                if (haveHyphen && ((String)zip).length() >= 3) {
                    zip = ((String)zip).substring(0, 3) + "-" + ((String)zip).substring(3);
                }
                String addr = kv[1];
                LinkedHashMap<String, String> pair = new LinkedHashMap<String, String>();
                pair.put("ZIPCODE", (String)zip);
                pair.put("ADDRESS", addr);
                results.add(pair);
            }
        }
        return new ResponseEntity(results, (MultiValueMap)headers, HttpStatus.OK);
    }
}

