/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.group;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.app.HibernateMasterJprincipal;
import jp.jasminesoft.jfc.app.MasterJprincipal;
import jp.jasminesoft.jfc.core.group.AllUserElementList;
import jp.jasminesoft.jfc.core.group.By;
import jp.jasminesoft.jfc.core.group.EmptyGroupElement;
import jp.jasminesoft.jfc.core.group.GroupElement;
import jp.jasminesoft.jfc.core.group.GroupElementList;
import jp.jasminesoft.jfc.core.group.GroupNode;
import jp.jasminesoft.jfc.core.group.GroupNodeManager;
import jp.jasminesoft.jfc.core.group.SingleGroupElement;
import jp.jasminesoft.jfc.core.group.SingleUserElement;
import jp.jasminesoft.jfc.core.group.UserElement;
import jp.jasminesoft.jfc.core.group.UserElementList;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.jfc.model.juser.Juser;
import org.springframework.context.ApplicationContext;

public class ElementUtils {
    public static final String REQUEST_GROUPCHART = "__jfc_groupChart";

    protected ElementUtils() {
    }

    public static UserElement getUserElement(ApplicationContext appctx, Integer ... jgroupids) {
        Juser[] jusers = ElementUtils.groupNodeManager(appctx).getJuser(jgroupids, (Integer[])null);
        return ElementUtils.getUserElement(appctx, jusers);
    }

    public static UserElement getUserElement(ApplicationContext appctx, Juser ... jusers) {
        if ((jusers = jusers == null ? new Juser[]{} : (Juser[])Stream.of(jusers).filter(juser -> juser != null).toArray(Juser[]::new)).length == 1) {
            return new SingleUserElement(appctx, jusers[0]);
        }
        return new UserElementList(appctx, jusers);
    }

    public static UserElement getUserElement(ApplicationContext appctx, String userid) {
        Juser[] jusers = ElementUtils.groupNodeManager(appctx).getJuser(userid);
        return ElementUtils.getUserElement(appctx, jusers);
    }

    public static UserElement getUserElement(ApplicationContext appctx, By ... bys) {
        Juser[] jusers = ElementUtils.groupNodeManager(appctx).findJuser(bys);
        return ElementUtils.getUserElement(appctx, jusers);
    }

    public static UserElement allUsers(ApplicationContext appctx) {
        return new AllUserElementList(appctx);
    }

    public static GroupElement rootGroup(ApplicationContext appctx) {
        return new GroupElementList(appctx, new Integer[0]);
    }

    public static GroupElement getGroupElement(ApplicationContext appctx, Integer ... jgroupids) {
        if (jgroupids == null) {
            jgroupids = new Integer[]{};
        }
        if (ArrayUtils.isEmpty((Object[])(jgroupids = (Integer[])Stream.of(jgroupids).filter(jgroupid -> jgroupid != null).distinct().sorted().toArray(Integer[]::new)))) {
            return new EmptyGroupElement(appctx, null);
        }
        if (jgroupids.length == 1) {
            return new SingleGroupElement(jgroupids[0], appctx);
        }
        return new GroupElementList(appctx, jgroupids);
    }

    public static GroupElement getParentGroupElement(ApplicationContext appctx, Integer ... jgroupids) {
        Object[] parentIds = ElementUtils.groupNodeManager(appctx).parent(jgroupids);
        if (ArrayUtils.isEmpty((Object[])parentIds)) {
            return ElementUtils.rootGroup(appctx);
        }
        return ElementUtils.getGroupElement(appctx, (Integer[])parentIds);
    }

    public static GroupElement getChildrenGroupElement(ApplicationContext appctx, Integer ... jgroupids) {
        Integer[] childrenIds = ElementUtils.groupNodeManager(appctx).children(jgroupids);
        GroupElement element = ElementUtils.getGroupElement(appctx, childrenIds);
        if (element instanceof EmptyGroupElement) {
            ((EmptyGroupElement)element).setParent(ElementUtils.getGroupElement(appctx, jgroupids));
        }
        return element;
    }

    public static GroupElement getDescendantsGroupElement(ApplicationContext appctx, Integer ... jgroupids) {
        Integer[] descendantIds = ElementUtils.groupNodeManager(appctx).descendants(jgroupids);
        GroupElement element = ElementUtils.getGroupElement(appctx, descendantIds);
        if (element instanceof EmptyGroupElement) {
            ((EmptyGroupElement)element).setParent(ElementUtils.getGroupElement(appctx, jgroupids));
        }
        return element;
    }

    public static GroupNodeManager groupNodeManager(ApplicationContext appctx) {
        return (GroupNodeManager)appctx.getBean("GroupNodeManager", GroupNodeManager.class);
    }

    public static Integer[] getJprincipalIds(String[] principalNames) {
        return (Integer[])Stream.of(ElementUtils.getJprincipals(principalNames)).map(principal -> principal.getId()).toArray(Integer[]::new);
    }

    public static Jprincipal[] getJprincipals(String[] principalNames) {
        if (ArrayUtils.isEmpty((Object[])principalNames)) {
            return new Jprincipal[0];
        }
        return (Jprincipal[])Stream.of(principalNames).map(principalName -> ElementUtils.getJprincipal(principalName)).toArray(Jprincipal[]::new);
    }

    public static Jprincipal getJprincipal(String principalName) {
        MasterJprincipal masterJprincipal = HibernateMasterJprincipal.getInstance();
        Jprincipal jprincipal = masterJprincipal.getDataByName(principalName);
        if (jprincipal == null) {
            throw new IllegalArgumentException("Principal of name: " + principalName + " not found.");
        }
        return jprincipal;
    }

    public static void displayGroupChart(ApplicationContext appctx, Integer ... jgrupids) {
        ElementUtils.request(appctx).setAttribute(REQUEST_GROUPCHART, (Object)ElementUtils.toJson(ElementUtils.groupNodeManager(appctx).treeGraph(jgrupids)));
    }

    private static HttpServletRequest request(ApplicationContext appctx) {
        return ((ActionParameterContainer)appctx.getBean((String)"ActionParameterContainer", ActionParameterContainer.class)).get().request;
    }

    protected static String toJson(GroupNode groupNode) {
        if (groupNode == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            return mapper.writeValueAsString((Object)groupNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

